package ru.yandex.direct.grid.processing.service.client;

import java.util.Collections;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLContext;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.client.GdClientDevInfo;

@GridGraphQLService(isBeta = true)
@ParametersAreNonnullByDefault
public class ClientDevGraphQlService {
    public static final String CLIENT_DEV_RESOLVER_NAME = "clientDev";

    private final ClientDevDataService clientDevDataService;

    @Autowired
    public ClientDevGraphQlService(ClientDevDataService clientDevDataService) {
        this.clientDevDataService = clientDevDataService;
    }

    @GraphQLNonNull
    @GraphQLQuery(name = CLIENT_DEV_RESOLVER_NAME)
    public GdClientDevInfo getClientDevInfo(@GraphQLRootContext GridGraphQLContext context) {
        return clientDevDataService.getClientDevInfo(context);
    }

    @GraphQLNonNull
    @GraphQLQuery(name = "operatorFeatures")
    public Set<@GraphQLNonNull String> getOperatorFeatures(
            @GraphQLRootContext GridGraphQLContext context,
            @SuppressWarnings("unused") @GraphQLContext GdClientDevInfo gdClientDevInfo) {
        User operator = context.getOperator();
        return clientDevDataService.getUserFeatures(operator);
    }

    @GraphQLNonNull
    @GraphQLQuery(name = "clientFeatures")
    public Set<@GraphQLNonNull String> getClientFeatures(
            @GraphQLRootContext GridGraphQLContext context,
            @SuppressWarnings("unused") @GraphQLContext GdClientDevInfo gdClientDevInfo) {
        User subjectUser = context.getSubjectUser();
        if (subjectUser == null) {
            return Collections.emptySet();
        }
        return clientDevDataService.getUserFeatures(subjectUser);
    }
}
