package ru.yandex.direct.grid.processing.service.client;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWriteSettings;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.client.GdClientMeasurerSystem;
import ru.yandex.direct.grid.processing.model.client.GdRequestChoiceFromConversionModifiersPopup;
import ru.yandex.direct.grid.processing.model.client.GdRequestMetrikaCountersAccess;
import ru.yandex.direct.grid.processing.model.client.GdRequestMetrikaCountersAccessPayload;
import ru.yandex.direct.grid.processing.model.cliententity.mutation.GdAddClientMeasurerAccount;
import ru.yandex.direct.grid.processing.model.cliententity.mutation.GdChoiceFromConversionModifiersPopupPayload;
import ru.yandex.direct.grid.processing.model.cliententity.mutation.GdClientMeasurerAccountPayload;
import ru.yandex.direct.grid.processing.model.cliententity.mutation.GdProcessInternalDontShowDomainsPopup;
import ru.yandex.direct.grid.processing.model.cliententity.mutation.GdProcessInternalDontShowDomainsPopupPayload;
import ru.yandex.direct.grid.processing.service.validation.GridValidationService;

import static com.google.common.base.Preconditions.checkNotNull;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class ClientMutationGraphQlService {

    private final ClientMutationService clientMutationService;
    private final GridValidationService gridValidationService;

    @Autowired
    public ClientMutationGraphQlService(ClientMutationService clientMutationService,
                                        GridValidationService gridValidationService) {
        this.clientMutationService = clientMutationService;
        this.gridValidationService = gridValidationService;
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "requestMetrikaCountersAccess")
    public GdRequestMetrikaCountersAccessPayload requestMetrikaCountersAccess(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdRequestMetrikaCountersAccess input) {
        String userLogin = checkNotNull(context.getSubjectUser()).getLogin();
        Set<Long> counterIds = input.getCounterIds();

        return clientMutationService.requestMetrikaCountersAccess(userLogin, counterIds);
    }

    @GraphQLNonNull
    @PreAuthorizeWriteSettings
    @GraphQLMutation(name = "addMeasurerAccount")
    public GdClientMeasurerAccountPayload addMeasurerAccount(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdAddClientMeasurerAccount input) {
        clientMutationService.fillMeasurerSettings(input);
        gridValidationService.validateClientMeasurerAccount(input);
        clientMutationService.addMeasurerAccount(context.getOperator(), context.getSubjectUser().getClientId(), input);
        return new GdClientMeasurerAccountPayload();
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "processInternalDontShowDomainsPopup")
    public GdProcessInternalDontShowDomainsPopupPayload processInternalDontShowDomainsPopup(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdProcessInternalDontShowDomainsPopup input) {
        return clientMutationService.processInternalDontShowDomainsPopup(input, context);
    }

    @GraphQLNonNull
    @PreAuthorizeWriteSettings
    @GraphQLMutation(name = "deleteMeasurerAccount")
    public GdClientMeasurerAccountPayload deleteMeasurerAccount(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "measurerSystem") GdClientMeasurerSystem measurerSystem) {
        clientMutationService.deleteMeasurerAccount(context.getOperator(), context.getSubjectUser().getClientId(),
                measurerSystem);
        return new GdClientMeasurerAccountPayload();
    }


    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "saveChoiceFromConversionModifiersPopup")
    public GdChoiceFromConversionModifiersPopupPayload saveChoiceFromConversionModifiersPopup(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input")
                    GdRequestChoiceFromConversionModifiersPopup requestChoiceFromConversionModifiersPopup) {
        return clientMutationService.saveChoiceFromConversionModifiersPopup(context,
                requestChoiceFromConversionModifiersPopup);
    }


}
