package ru.yandex.direct.grid.processing.service.client.converter;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.ObjectMapper;
import one.util.streamex.StreamEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.liveresource.LiveResourceFactory;

@Service
public class BusinessCategoriesService {

    private static final Logger logger = LoggerFactory.getLogger(BusinessCategoriesService.class);

    private static final String MAPPING_FILE_PATH = "classpath:///sprav_to_direct_categories_mapping.json";

    public static final String NO_CATEGORY = "-";

    private final Map<String, String> spravToDirectCategory;
    private final List<String> allDirectBusinessCategories;

    @Autowired
    public BusinessCategoriesService() throws IOException {
        String fileContent = LiveResourceFactory.get(MAPPING_FILE_PATH).getContent();

        spravToDirectCategory = new ObjectMapper().readValue(fileContent, HashMap.class);
        allDirectBusinessCategories = StreamEx.of(spravToDirectCategory.values())
                .remove(NO_CATEGORY::equals)
                .sorted()
                .distinct()
                .toImmutableList();
    }

    public List<String> getAllDirectBusinessCategories() {
        return allDirectBusinessCategories;
    }

    @Nullable
    public String convertSpravBusinessCategory(String spravBusinessCategory) {
        if (spravBusinessCategory == null) {
            return null;
        }

        String directBusinessCategory = spravToDirectCategory.get(spravBusinessCategory);

        if (directBusinessCategory == null) {
            logger.warn("Got unknown business category from sprav: {}", spravBusinessCategory);
            return null;
        }

        return directBusinessCategory.equals(NO_CATEGORY) ? null : directBusinessCategory;
    }
}
