package ru.yandex.direct.grid.processing.service.client.converter;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.client.model.ClientLimits;
import ru.yandex.direct.grid.processing.model.client.GdClientLimits;

@ParametersAreNonnullByDefault
public class ClientConstantsConverter {

    public static GdClientLimits toGdClientLimits(ClientLimits clientLimits) {
        return new GdClientLimits()
                .withCampsCountLimit(clientLimits.getCampsCountLimitOrDefault())
                .withPromoExtensionCountLimit(clientLimits.getPromoExtensionCountLimitOrDefault())
                .withUnarcCampsCountLimit(clientLimits.getUnarcCampsCountLimitOrDefault())
                .withGroupsCountLimit(clientLimits.getBannersCountLimitOrDefault())
                .withKeywordsCountLimit(clientLimits.getKeywordsCountLimitOrDefault())
                .withFeedsMaxFileSize(clientLimits.getFeedsMaxFileSizeOrDefault())
                .withFeedCountLimit(clientLimits.getFeedCountLimitOrDefault())
                .withCalloutsCountLimit(clientLimits.getCalloutsCountLimitOrDefault())
                .withCreativesCountLimit(clientLimits.getCreativesCountLimitOrDefault())
                .withGeneralBlacklistSizeLimit(clientLimits.getGeneralBlacklistSizeLimitOrDefault())
                .withVideoBlacklistSizeLimit(clientLimits.getVideoBlacklistSizeLimitOrDefault());
    }
}
