package ru.yandex.direct.grid.processing.service.client.converter

import ru.yandex.direct.core.entity.user.model.User
import ru.yandex.direct.grid.processing.model.client.GdClientInfo
import ru.yandex.direct.grid.processing.model.client.GdMccClient
import ru.yandex.direct.grid.processing.model.client.GdMccRequest
import ru.yandex.direct.grid.processing.model.client.GdUserInfo
import ru.yandex.direct.grid.processing.service.operator.UserDataConverter
import ru.yandex.direct.grid.processing.service.operator.UserDataConverter.getAvatarUrl

fun toGdMccRequest(controlClientChiefUser: User?, managedClientChiefUser: User?): GdMccRequest {
    val request = GdMccRequest()
    controlClientChiefUser?.let{ request.withControlClient(toGdClientInfo(it)) }
    managedClientChiefUser?.let{ request.withManagedClient(toGdClientInfo(it)) }
    return request
}

fun toGdMccRequestShort(controlClientChiefUser: User?, managedClientChiefUser: User?): GdMccRequest {
    val request = GdMccRequest()
    controlClientChiefUser?.let{ request.withControlClient(toGdClientInfoShort(it)) }
    managedClientChiefUser?.let{ request.withManagedClient(toGdClientInfoShort(it)) }
    return request
}

fun toGdMccClient(chiefUser: User): GdMccClient {
    return GdMccClient().withInfo(
        GdClientInfo()
            .withId(chiefUser.clientId.asLong())
            .withChiefUser(UserDataConverter.toGdUserInfo(chiefUser))
    )
}

fun toGdClientInfo(chiefUser: User): GdClientInfo {
    return GdClientInfo()
        .withId(chiefUser.clientId.asLong())
        .withChiefUser(UserDataConverter.toGdUserInfo(chiefUser))
}

fun toGdClientInfoShort(chiefUser: User): GdClientInfo {
    return GdClientInfo()
        .withChiefUser(
            GdUserInfo()
                .withLogin(chiefUser.login)
                .withName(chiefUser.fio)
                .withAvatarUrl(getAvatarUrl(chiefUser.uid))
        )
}
