package ru.yandex.direct.grid.processing.service.client.converter;

import java.util.Objects;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.grid.processing.model.client.GdCoreFeatureWithDescription;

@ParametersAreNonnullByDefault
@Service
public class GdFeatureWithDescriptionConverterService {

    private final TranslationService translationService;

    @Autowired
    public GdFeatureWithDescriptionConverterService(TranslationService translationService) {
        this.translationService = translationService;
    }

    public Set<GdCoreFeatureWithDescription> convertToCore(Set<String> features) {
        return StreamEx.of(features)
                .map(FeatureName::fromString)
                .filter(Objects::nonNull)
                .map(this::getGdCoreFeatureWithDescription)
                .toSet();
    }

    private GdCoreFeatureWithDescription getGdCoreFeatureWithDescription(FeatureName featureName) {
        String description = translationService.translate(featureName.getHumanReadableName());
        return new GdCoreFeatureWithDescription()
                .withFeatureName(featureName)
                .withDescription(description);
    }

}
