package ru.yandex.direct.grid.processing.service.client.loader;

import java.util.Map;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.dataloader.MappedBatchLoaderWithContext;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.core.entity.account.score.service.AccountScoreService;
import ru.yandex.direct.grid.processing.model.client.GdAccountScoreInfo;
import ru.yandex.direct.grid.processing.service.client.converter.ClientDataConverter;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;
import ru.yandex.direct.grid.processing.service.dataloader.GridContextProvider;

@Component
// DataLoader'ы хранят состояние, поэтому жить должны в рамках запроса
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
@ParametersAreNonnullByDefault
public class ClientsAccountScoreInfoDataLoader extends GridBatchingDataLoader<Long, GdAccountScoreInfo> {

    public ClientsAccountScoreInfoDataLoader(GridContextProvider gridContextProvider,
                                             AccountScoreService accountScoreService) {
        this.dataLoader = mappedDataLoader(gridContextProvider, getBatchLoadFunction(accountScoreService));
    }

    private MappedBatchLoaderWithContext<Long, GdAccountScoreInfo> getBatchLoadFunction(AccountScoreService accountScoreService) {
        return (clientIds, environment) -> {
            Map<Long, GdAccountScoreInfo> accountScoreInfoMap = StreamEx.of(clientIds)
                    .mapToEntry(accountScoreService::getLatestAndPreviewsAccountScore)
                    .mapValues(ClientDataConverter::toGdAccountScoreInfo)
                    .nonNullValues()
                    .toMap();
            return CompletableFuture.completedFuture(accountScoreInfoMap);
        };
    }
}
