package ru.yandex.direct.grid.processing.service.client.model;

import java.util.Objects;

import javax.annotation.Nullable;

import ru.yandex.direct.grid.processing.model.client.GdMetrikaCounterSource;

public class MetrikaCounterForSuggest {
    private Long id;
    private Boolean hasEcommerce;
    private GdMetrikaCounterSource source;
    private Boolean isEditableByOperator;
    private Boolean isCalltrackingOnSiteCompatible;
    private boolean isAccessible;
    private Boolean isAccessRequested;

    public Long getId() {
        return id;
    }

    public MetrikaCounterForSuggest withId(Long id) {
        this.id = id;
        return this;
    }

    @Nullable
    public Boolean getHasEcommerce() {
        return hasEcommerce;
    }

    public MetrikaCounterForSuggest withHasEcommerce(Boolean hasEcommerce) {
        this.hasEcommerce = hasEcommerce;
        return this;
    }

    @Nullable
    public GdMetrikaCounterSource getSource() {
        return source;
    }

    public MetrikaCounterForSuggest withSource(GdMetrikaCounterSource source) {
        this.source = source;
        return this;
    }

    public Boolean getEditableByOperator() {
        return isEditableByOperator;
    }

    public MetrikaCounterForSuggest withEditableByOperator(Boolean editableByOperator) {
        isEditableByOperator = editableByOperator;
        return this;
    }

    public Boolean getCalltrackingOnSiteCompatible() {
        return isCalltrackingOnSiteCompatible;
    }

    public MetrikaCounterForSuggest withCalltrackingOnSiteCompatible(Boolean calltrackingCompatible) {
        isCalltrackingOnSiteCompatible = calltrackingCompatible;
        return this;
    }

    public boolean getAccessible() {
        return isAccessible;
    }

    public MetrikaCounterForSuggest withAccessible(boolean isAccessible) {
        this.isAccessible = isAccessible;
        return this;
    }

    public Boolean getAccessRequested() {
        return isAccessRequested;
    }

    public MetrikaCounterForSuggest withAccessRequested(Boolean isAccessRequested) {
        this.isAccessRequested = isAccessRequested;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MetrikaCounterForSuggest that = (MetrikaCounterForSuggest) o;
        return isAccessible == that.isAccessible
                && Objects.equals(id, that.id)
                && Objects.equals(hasEcommerce, that.hasEcommerce)
                && source == that.source
                && Objects.equals(isEditableByOperator, that.isEditableByOperator)
                && Objects.equals(isCalltrackingOnSiteCompatible, that.isCalltrackingOnSiteCompatible)
                && Objects.equals(isAccessRequested, that.isAccessRequested);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, hasEcommerce, source, isEditableByOperator, isCalltrackingOnSiteCompatible,
                isAccessible, isAccessRequested);
    }
}
