package ru.yandex.direct.grid.processing.service.client.validation

import ru.yandex.direct.validation.result.Defect

fun clientAlreadyLinked(): Defect<Void> {
    return Defect(ClientMccDefectIds.Gen.CLIENT_ALREADY_LINKED)
}

fun clientNotAllowed(): Defect<Void> {
    return Defect(ClientMccDefectIds.Gen.CLIENT_NOT_ALLOWED)
}

fun requestNotFound(): Defect<Void> {
    return Defect(ClientMccDefectIds.Gen.REQUEST_NOT_FOUND)
}

fun mccRequestsLimitExceeded(limit: Int): Defect<Int> {
    return Defect(ClientMccDefectIds.Num.MCC_REQUESTS_LIMIT_EXCEEDED, limit)
}

fun mccLinkNotFound(): Defect<Void> {
    return Defect(ClientMccDefectIds.Gen.MCC_LINK_NOT_FOUND)
}

fun managedClientsLimitExceeded(limit: Int): Defect<Int> {
    return Defect(ClientMccDefectIds.Num.MANAGED_CLIENTS_LIMIT_EXCEEDED, limit)
}

