package ru.yandex.direct.grid.processing.service.client.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.grid.processing.model.client.GdRequestChoiceFromConversionModifiersPopup;
import ru.yandex.direct.grid.processing.service.validation.GridValidationService;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.unconditional;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

@Service
@ParametersAreNonnullByDefault
public class SaveChoiceFromConversionModifiersPopupValidationService {
    private final GridValidationService gridValidationService;

    @Autowired
    public SaveChoiceFromConversionModifiersPopupValidationService(GridValidationService gridValidationService) {
        this.gridValidationService = gridValidationService;
    }

    public void validateChoiceFromConversionModifiersPopupRequest(GdRequestChoiceFromConversionModifiersPopup input,
                                                                  boolean conversionModifiersPopupEnabled) {
        gridValidationService.applyValidator(
                getChoiceFromConversionModifiersPopupRequestValidator(conversionModifiersPopupEnabled),
                input, false);
    }

    private static Validator<GdRequestChoiceFromConversionModifiersPopup, Defect>
    getChoiceFromConversionModifiersPopupRequestValidator(boolean conversionModifiersPopupEnabled) {
        return request -> {
            var vb = ModelItemValidationBuilder.of(request);
            vb.check(unconditional(invalidValue()), When.isFalse(conversionModifiersPopupEnabled));

            return vb.getResult();
        };
    }
}
