package ru.yandex.direct.grid.processing.service.constant;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.enums.YandexDomain;
import ru.yandex.direct.common.util.HttpUtil;
import ru.yandex.direct.env.EnvironmentType;

/**
 * Тут логика про обработку запросов crowdtest стенда см
 * <a href="https://wiki.yandex-team.ru/users/sonick/crowdtest-stands/">вики</a>
 */
@Service
@ParametersAreNonnullByDefault
public class CrowdTestSettingsService {

    private final EnvironmentType environmentType;

    public static final String CROWD_TEST_DOMAIN_PREFIX = "release.crowdtest.direct.";
    public static final String CROWD_TEST_TURBOLANDINGS_API_URL_PREFIX = "https://ad-constructor.crowdtest.";
    public static final String CROWD_TEST_BALANCE_URL_PREFIX = "https://user-balance-greed-tm.crowdtest.";

    @Autowired
    public CrowdTestSettingsService(EnvironmentType environmentType) {
        this.environmentType = environmentType;
    }

    public String getCrowdTestTurbolandingApiUrl(YandexDomain domain) {
        return CROWD_TEST_TURBOLANDINGS_API_URL_PREFIX + domain.getYandexDomain();
    }

    /**
     * Определить, пришёл ли запрос с балансера crowdtest по наличию заголовка Host
     * Таботает только на ТС
     */
    public boolean isCrowdTestRequest(YandexDomain domain) {
        if (environmentType != EnvironmentType.TESTING) {
            return false;
        }
        String hostHeader = getHostHeader();
        return hostHeader != null && (CROWD_TEST_DOMAIN_PREFIX + domain.getYandexDomain()).startsWith(hostHeader);
    }

    String getHostHeader() {
        return HttpUtil.getExactHostHeader();
    }

    public String getCrowdTestBalanceApiUrl(YandexDomain domain) {
        return CROWD_TEST_BALANCE_URL_PREFIX + domain.getYandexDomain();
    }
}
