package ru.yandex.direct.grid.processing.service.constant

import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants
import ru.yandex.direct.grid.model.campaign.GdMeaningfulGoal
import ru.yandex.direct.grid.model.strategy.GdStrategyAttributionModel
import ru.yandex.direct.grid.model.strategy.GdStrategyDayBudgetShowMode
import ru.yandex.direct.grid.model.strategy.GdStrategyName
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetAvgClickDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetAvgCpaDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetAvgCpaPerCampDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetAvgCpaPerFilterDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetAvgCpcPerCampDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetAvgCpcPerFilterDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetAvgCpiDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetAvgCpvCustomPeriodDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetAvgCpvDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetCrrDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetMaxImpressionsCustomPeriodDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetMaxImpressionsDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetMaxReachCustomPeriodDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetMaxReachDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetMediaDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetRoiDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetWeekBundleDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdAutobudgetWeekSumDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdCpmDefaultDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdDefaultManualStrategyDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdPackageStrategiesDefaults
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdPackageStrategyDefaultValues
import ru.yandex.direct.grid.processing.model.strategy.defaults.GdPeriodFixBidDefaultValues
import java.math.BigDecimal
import java.time.LocalDate

object PackageStrategyDefaultValuesUtils {
    @JvmStatic
    fun getPackageStrategiesDefaults(): GdPackageStrategiesDefaults {
        val now = LocalDate.now()
        val strategies = strategyTypeToDefaultsSupplier(now).mapValues { (strategyName, defaultsSupplier) ->
            val defaults = defaultsSupplier()
            fillCommonDefaults(defaults)
                .withType(strategyName)
        }

        return GdPackageStrategiesDefaults()
            .withDefaultStrategy(strategies[GdStrategyName.AUTOBUDGET_AVG_CPA])
    }

    private fun getGdAutobudgetAvgClickDefaultValues(): GdAutobudgetAvgClickDefaultValues {
        val defaults = GdAutobudgetAvgClickDefaultValues()
        defaults.meaningfulGoals = DEFAULT_MEANINGFUL_GOALS
        return defaults
    }

    private fun getGdAutobudgetAvgCpaDefaultValues(): GdAutobudgetAvgCpaDefaultValues {
        val defaults = GdAutobudgetAvgCpaDefaultValues()
        defaults.meaningfulGoals = DEFAULT_MEANINGFUL_GOALS
        defaults.isPayForConversionEnabled = false
        return defaults
    }

    private fun getGdAutobudgetAvgCpaPerCampDefaultValues(): GdAutobudgetAvgCpaPerCampDefaultValues {
        val defaults = GdAutobudgetAvgCpaPerCampDefaultValues()
        defaults.isPayForConversionEnabled = false
        defaults.meaningfulGoals = DEFAULT_MEANINGFUL_GOALS
        return defaults
    }

    private fun getGdAutobudgetAvgCpaPerFilterDefaultValues(): GdAutobudgetAvgCpaPerFilterDefaultValues {
        val defaults = GdAutobudgetAvgCpaPerFilterDefaultValues()
        defaults.isPayForConversionEnabled = false
        defaults.meaningfulGoals = DEFAULT_MEANINGFUL_GOALS
        return defaults
    }

    private fun getGdAutobudgetAvgCpcPerCampDefaultValues(): GdAutobudgetAvgCpcPerCampDefaultValues {
        val defaults = GdAutobudgetAvgCpcPerCampDefaultValues()
        defaults.meaningfulGoals = DEFAULT_MEANINGFUL_GOALS
        return defaults
    }

    private fun getGdAutobudgetAvgCpcPerFilterDefaultValues(): GdAutobudgetAvgCpcPerFilterDefaultValues {
        val defaults = GdAutobudgetAvgCpcPerFilterDefaultValues()
        defaults.meaningfulGoals = DEFAULT_MEANINGFUL_GOALS
        return defaults
    }

    private fun getGdAutobudgetAvgCpiDefaultValues(): GdAutobudgetAvgCpiDefaultValues {
        val defaults = GdAutobudgetAvgCpiDefaultValues()
        defaults.isPayForConversionEnabled = false
        return defaults
    }

    private fun getGdAutobudgetAvgCpvCustomPeriodDefaultValues(now: LocalDate): GdAutobudgetAvgCpvCustomPeriodDefaultValues {
        val defaults = GdAutobudgetAvgCpvCustomPeriodDefaultValues()
        defaults.start = now
        defaults.finish = defaults.start.plusDays(DEFAULT_CUSTOM_PERIOD)
        defaults.autoProlongation = true
        return defaults
    }

    private fun getGdAutobudgetAvgCpvDefaultValues() =
        GdAutobudgetAvgCpvDefaultValues()

    private fun getGdAutobudgetCrrDefaultValues(): GdAutobudgetCrrDefaultValues {
        val defaults = GdAutobudgetCrrDefaultValues()
        defaults.isPayForConversionEnabled = false
        defaults.meaningfulGoals = DEFAULT_MEANINGFUL_GOALS
        return defaults
    }

    private fun getGdAutobudgetMaxImpressionsCustomPeriodDefaultValues(now: LocalDate): GdAutobudgetMaxImpressionsCustomPeriodDefaultValues {
        val defaults =
            GdAutobudgetMaxImpressionsCustomPeriodDefaultValues()
        defaults.autoProlongation = true
        defaults.start = now
        defaults.finish = defaults.start.plusDays(DEFAULT_CUSTOM_PERIOD)
        return defaults
    }

    private fun getGdAutobudgetMaxImpressionsDefaultValues() =
        GdAutobudgetMaxImpressionsDefaultValues()

    private fun getGdAutobudgetMaxReachCustomPeriodDefaultValues(now: LocalDate): GdAutobudgetMaxReachCustomPeriodDefaultValues {
        val defaults = GdAutobudgetMaxReachCustomPeriodDefaultValues()
        defaults.autoProlongation = true
        defaults.start = now
        defaults.finish = defaults.start.plusDays(DEFAULT_CUSTOM_PERIOD)
        return defaults
    }

    private fun getGdAutobudgetMaxReachDefaultValues() =
        GdAutobudgetMaxReachDefaultValues()

    private fun getGdAutobudgetMediaDefaultValues() =
        GdAutobudgetMediaDefaultValues()

    private fun getGdAutobudgetRoiDefaultValues(): GdAutobudgetRoiDefaultValues {
        val defaults = GdAutobudgetRoiDefaultValues()
        defaults.meaningfulGoals = DEFAULT_MEANINGFUL_GOALS
        return defaults
    }

    private fun getGdAutobudgetWeekBundleDefaultValues(): GdAutobudgetWeekBundleDefaultValues {
        val defaults = GdAutobudgetWeekBundleDefaultValues()
        defaults.meaningfulGoals = DEFAULT_MEANINGFUL_GOALS
        return defaults
    }

    private fun getGdAutobudgetWeekSumDefaultValues(): GdAutobudgetWeekSumDefaultValues {
        val defaults = GdAutobudgetWeekSumDefaultValues()
        defaults.meaningfulGoals = DEFAULT_MEANINGFUL_GOALS
        return defaults
    }

    private fun getGdCpmDefaultDefaultValues(): GdCpmDefaultDefaultValues {
        val defaults = GdCpmDefaultDefaultValues()
        defaults.dayBudget = BigDecimal.ZERO
        defaults.dayBudgetShowMode = GdStrategyDayBudgetShowMode.DEFAULT_
        return defaults
    }

    private fun getGdDefaultManualStrategyDefaultValues(): GdDefaultManualStrategyDefaultValues {
        val defaults = GdDefaultManualStrategyDefaultValues()
        defaults.dayBudget = BigDecimal.ZERO
        defaults.dayBudgetShowMode = GdStrategyDayBudgetShowMode.DEFAULT_
        defaults.meaningfulGoals = DEFAULT_MEANINGFUL_GOALS
        defaults.enableCpcHold = true
        return defaults
    }

    private fun getGdPeriodFixBidDefaultValues(now: LocalDate): GdPeriodFixBidDefaultValues {
        val defaults = GdPeriodFixBidDefaultValues()
        defaults.start = now
        defaults.finish = defaults.start.plusDays(DEFAULT_CUSTOM_PERIOD)
        defaults.autoProlongation = true
        return defaults
    }

    private fun fillCommonDefaults(defaults: GdPackageStrategyDefaultValues): GdPackageStrategyDefaultValues {
        defaults.attributionModel =
            defaults.attributionModel ?: GdStrategyAttributionModel.LAST_YANDEX_DIRECT_CLICK_CROSS_DEVICE
        defaults.isPublic = defaults.isPublic ?: false
        defaults.name = "Новая пакетная стратегия"
        return defaults
    }

    private val DEFAULT_MEANINGFUL_GOALS = listOf(
        GdMeaningfulGoal()
            .withGoalId(CampaignConstants.ENGAGED_SESSION_GOAL_ID)
    )
    private const val DEFAULT_CUSTOM_PERIOD = 29L

    private fun strategyTypeToDefaultsSupplier(now: LocalDate) = mapOf(
        GdStrategyName.AUTOBUDGET_AVG_CLICK to { getGdAutobudgetAvgClickDefaultValues() },
        GdStrategyName.AUTOBUDGET_AVG_CPA to { getGdAutobudgetAvgCpaDefaultValues() },
        GdStrategyName.AUTOBUDGET_AVG_CPA_PER_CAMP to { getGdAutobudgetAvgCpaPerCampDefaultValues() },
        GdStrategyName.AUTOBUDGET_AVG_CPA_PER_FILTER to { getGdAutobudgetAvgCpaPerFilterDefaultValues() },
        GdStrategyName.AUTOBUDGET_AVG_CPC_PER_CAMP to { getGdAutobudgetAvgCpcPerCampDefaultValues() },
        GdStrategyName.AUTOBUDGET_AVG_CPC_PER_FILTER to { getGdAutobudgetAvgCpcPerFilterDefaultValues() },
        GdStrategyName.AUTOBUDGET_AVG_CPI to { getGdAutobudgetAvgCpiDefaultValues() },
        GdStrategyName.AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD to { getGdAutobudgetAvgCpvCustomPeriodDefaultValues(now) },
        GdStrategyName.AUTOBUDGET_AVG_CPV to { getGdAutobudgetAvgCpvDefaultValues() },
        GdStrategyName.AUTOBUDGET_CRR to { getGdAutobudgetCrrDefaultValues() },
        GdStrategyName.AUTOBUDGET_MAX_IMPRESSIONS_CUSTOM_PERIOD to {
            getGdAutobudgetMaxImpressionsCustomPeriodDefaultValues(
                now
            )
        },
        GdStrategyName.AUTOBUDGET_MAX_IMPRESSIONS to { getGdAutobudgetMaxImpressionsDefaultValues() },
        GdStrategyName.AUTOBUDGET_MAX_REACH_CUSTOM_PERIOD to { getGdAutobudgetMaxReachCustomPeriodDefaultValues(now) },
        GdStrategyName.AUTOBUDGET_MAX_REACH to { getGdAutobudgetMaxReachDefaultValues() },
        GdStrategyName.AUTOBUDGET_MEDIA to { getGdAutobudgetMediaDefaultValues() },
        GdStrategyName.AUTOBUDGET_ROI to { getGdAutobudgetRoiDefaultValues() },
        GdStrategyName.AUTOBUDGET_WEEK_BUNDLE to { getGdAutobudgetWeekBundleDefaultValues() },
        GdStrategyName.AUTOBUDGET to { getGdAutobudgetWeekSumDefaultValues() },
        GdStrategyName.CPM_DEFAULT to { getGdCpmDefaultDefaultValues() },
        GdStrategyName.DEFAULT_ to { getGdDefaultManualStrategyDefaultValues() },
        GdStrategyName.PERIOD_FIX_BID to { getGdPeriodFixBidDefaultValues(now) }
    )
}
