package ru.yandex.direct.grid.processing.service.constant;

import java.util.Set;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutConstants;
import ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupValidationService;
import ru.yandex.direct.core.entity.banner.model.ImageSize;
import ru.yandex.direct.core.entity.banner.service.validation.BannerConstants;
import ru.yandex.direct.core.entity.banner.service.validation.BannerLettersConstants;
import ru.yandex.direct.core.entity.banner.service.validation.BannerTextConstants;
import ru.yandex.direct.core.entity.banner.type.body.BannerWithBodyConstants;
import ru.yandex.direct.core.entity.banner.type.callouts.BannerWithCalloutsConstants;
import ru.yandex.direct.core.entity.banner.type.displayhref.BannerWithDisplayHrefConstraints;
import ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefConstants;
import ru.yandex.direct.core.entity.banner.type.pixels.BannerPixelsConstants;
import ru.yandex.direct.core.entity.banner.type.title.BannerConstantsService;
import ru.yandex.direct.core.entity.banner.type.titleextension.BannerWithTitleExtensionConstants;
import ru.yandex.direct.core.entity.banner.type.turbogallery.BannerTurboGalleryConstraints;
import ru.yandex.direct.core.entity.banner.type.turbolanding.BannerWithTurbolandingConstants;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants;
import ru.yandex.direct.core.entity.cashback.CashbackConstants;
import ru.yandex.direct.core.entity.client.Constants;
import ru.yandex.direct.core.entity.feature.service.FeatureHelper;
import ru.yandex.direct.core.entity.image.service.ImageConstants;
import ru.yandex.direct.core.entity.image.service.validation.ImageConstraints;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseConstraints;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhrasePredicates;
import ru.yandex.direct.core.entity.minuskeywordspack.service.validation.MinusKeywordsPackValidationService;
import ru.yandex.direct.core.entity.vcard.service.validation.AddVcardValidationService;
import ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator;
import ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator;
import ru.yandex.direct.core.entity.vcard.service.validation.PointOnMapValidator;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.grid.processing.model.cliententity.image.GdImageSize;
import ru.yandex.direct.grid.processing.model.constants.GdDirectConstantsAdGroupValidationData;
import ru.yandex.direct.grid.processing.model.constants.GdDirectConstantsAdValidationData;
import ru.yandex.direct.grid.processing.model.constants.GdDirectConstantsCalloutValidationData;
import ru.yandex.direct.grid.processing.model.constants.GdDirectConstantsCampaignValidationData;
import ru.yandex.direct.grid.processing.model.constants.GdDirectConstantsCashbackValidationData;
import ru.yandex.direct.grid.processing.model.constants.GdDirectConstantsKeywordsValidationData;
import ru.yandex.direct.grid.processing.model.constants.GdDirectConstantsMinusWordsLibValidationData;
import ru.yandex.direct.grid.processing.model.constants.GdDirectConstantsMinusWordsValidationData;
import ru.yandex.direct.grid.processing.model.constants.GdDirectConstantsPromoExtensionValidationData;
import ru.yandex.direct.grid.processing.model.constants.GdDirectConstantsSitelinkValidationData;
import ru.yandex.direct.grid.processing.model.constants.GdDirectConstantsVcardValidationData;
import ru.yandex.direct.grid.processing.service.banner.BannerDataConverter;
import ru.yandex.direct.grid.processing.service.campaign.CampaignValidationService;
import ru.yandex.direct.grid.processing.service.group.validation.AdGroupMassActionsValidationService;
import ru.yandex.direct.grid.processing.util.GridValidationConstants;
import ru.yandex.direct.utils.TextConstants;

import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.KEYWORD_MAX_LENGTH;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.WORDS_MAX_COUNT;
import static ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseConstraints.WORD_MAX_LENGTH;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkConstants.ALLOW_SITELINK_LETTERS;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkConstants.MAX_SITELINK_DESC_LENGTH;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkConstants.MAX_SITELINK_HREF_LENGTH;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkConstants.MAX_SITELINK_TITLE_LENGTH;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkSetValidationService.MAX_SITELINKS_PER_SET;
import static ru.yandex.direct.grid.processing.service.campaign.CampaignValidationService.ALLOWED_TYPES_TO_UPDATE_STRATEGIES;
import static ru.yandex.direct.utils.FunctionalUtils.mapSet;

@Service
public class ValidationConstantsService {

    private static final Logger logger = Logger.getLogger(ValidationConstantsService.class);

    /**
     * На фронте в поле PageIds вводятся через запятую,
     * поэтому идет проверка на количество символов, как это сделано и в старом интерфейсе
     **/
    static final int MAX_ALLOWED_PAGE_IDS_LENGTH = 4096;

    private final BannerConstantsService bannerConstantsService;

    @Autowired
    public ValidationConstantsService(BannerConstantsService bannerConstantsService) {
        this.bannerConstantsService = bannerConstantsService;
    }

    static GdDirectConstantsCampaignValidationData getCampaignValidationData(Set<String> availableFeatures) {
        return new GdDirectConstantsCampaignValidationData()
                .withMinWarningBalanceInPercent(CampaignConstants.MIN_CAMPAIGN_WARNING_BALANCE)
                .withMaxWarningBalanceInPercent(CampaignConstants.MAX_CAMPAIGN_WARNING_BALANCE)
                .withMaxNameLength(CampaignConstants.MAX_CAMPAIGN_NAME_LENGTH)
                .withMaxDisabledIpsCount(CampaignConstants.MAX_DISABLED_IPS_COUNT)
                .withMinBroadMatchLimit(CampaignConstants.BROAD_MATCH_LIMIT_MIN)
                .withMaxBroadMatchLimit(CampaignConstants.BROAD_MATCH_LIMIT_MAX)
                .withMaxLengthHref(BannerWithHrefConstants.MAX_LENGTH_HREF)
                .withMaxCompanyNameLength(CampaignConstants.MAX_COMPANY_NAME_LENGTH)
                .withMaxBusinessCategoryLength(CampaignConstants.MAX_BUSINESS_CATEGORY_LENGTH)
                .withMaxAllowedPageIdsLength(MAX_ALLOWED_PAGE_IDS_LENGTH)
                .withMaxAllowedPageIdsCount(CampaignConstants.MAX_ALLOWED_PAGE_IDS_COUNT)
                .withMaxDisabledPlacesCount(Constants.DEFAULT_DISABLED_PLACES_COUNT_LIMIT)
                .withMaxCampaignTagCount(CampaignConstants.MAX_CAMPAIGN_TAG_COUNT)
                .withMaxCampaignTagNameLength(CampaignConstants.MAX_CAMPAIGN_TAG_NAME_LENGTH)
                .withMaxMetrikaCountersNumberForTextCampaign(CampaignConstants.MAX_NUMBER_OF_OPTIONAL_METRIKA_COUNTERS)
                .withAutoContextLimit(CampaignConstants.AUTO_CONTEXT_LIMIT)
                .withMaxContextLimit(CampaignConstants.MAX_CONTEXT_LIMIT)
                .withMinContextLimit(CampaignConstants.MIN_CONTEXT_LIMIT)
                .withNoContextLimit(CampaignConstants.NO_CONTEXT_LIMIT)
                .withShowsDisabledContextLimit(CampaignConstants.SHOWS_DISABLED_CONTEXT_LIMIT)
                .withProfitabilityMax(CampaignConstants.PROFITABILITY_MAX)
                .withProfitabilityMin(CampaignConstants.PROFITABILITY_MIN)
                .withReserveReturnMax(CampaignConstants.RESERVE_RETURN_MAX)
                .withReserveReturnMin(CampaignConstants.RESERVE_RETURN_MIN)
                .withReserveReturnStep(CampaignConstants.RESERVE_RETURN_STEP)
                .withRoiCoefMin(CampaignConstants.ROI_COEF_MIN)
                .withCrrMin(CampaignConstants.CRR_MIN)
                .withCrrMax(CampaignConstants.CRR_MAX)
                .withMinInternalCampaignRotationGoalId((int) CampaignConstants.MIN_INTERNAL_CAMPAIGN_ROTATION_GOAL_ID)
                .withMinInternalCampaignRestrictionValue(
                        (int) CampaignConstants.MIN_INTERNAL_CAMPAIGN_RESTRICTION_VALUE)
                .withMaxCampaignsCountPerUpdate(CampaignValidationService.MAX_CAMPAIGNS_COUNT_PER_UPDATE)
                .withMaxCampaignsCountPerUpdateStrategies(
                        CampaignValidationService.MAX_CAMPAIGNS_STRATEGY_COUNT_PER_UPDATE
                )
                .withMaxCampaignsCountPerUpdateOrganizations(
                        CampaignValidationService.MAX_CAMPAIGNS_ORGANIZATION_COUNT_PER_UPDATE
                )
                .withAllowedTypesToMassUpdateStrategies(ALLOWED_TYPES_TO_UPDATE_STRATEGIES);
    }

    static GdDirectConstantsAdGroupValidationData getAdGroupValidationData() {
        return new GdDirectConstantsAdGroupValidationData()
                .withMaxAdGroupsCountPerUpdate(AdGroupMassActionsValidationService.MAX_AD_GROUPS_COUNT_PER_UPDATE)
                .withMaxNameLength(AdGroupValidationService.MAX_NAME_LENGTH)
                .withMaxMinusKeywordsTextLength(MinusPhraseConstraints.GROUP_MINUS_KEYWORDS_MAX_LENGTH);
    }

    static GdDirectConstantsCashbackValidationData getCashbackValidationData() {
        return new GdDirectConstantsCashbackValidationData()
                .withMinDetalizationPeriod(CashbackConstants.DETALIZATION_MIN_LENGTH)
                .withMaxDetalizationPeriod(CashbackConstants.DETALIZATION_MAX_LENGTH);
    }

    public GdDirectConstantsAdValidationData getAdValidationData(ClientId clientId) {
        int maxTitleLength = bannerConstantsService.getMaxLengthTitle(clientId);
        int maxUcTitleLength = bannerConstantsService.getMaxLengthUcTitle(clientId);
        var sizes = FeatureHelper.feature(FeatureName.ALLOW_PROPORTIONALLY_LARGER_IMAGES).enabled()
                ? ImageConstants.ALLOWED_SIZES_FOR_AD_IMAGE_ORIGINAL
                : ImageConstants.ALLOWED_SIZES_FOR_AD_IMAGE;
        var res = new GdDirectConstantsAdValidationData()
                .withMaxLengthTitle(maxTitleLength)
                .withMaxLengthMobileTitle(maxTitleLength)
                .withMaxLengthUcTitle(maxUcTitleLength)
                .withMaxLengthContentPromotionTitle(BannerConstantsService.MAX_LENGTH_CONTENT_PROMOTION_TITLE)
                .withMaxLengthFrontPageTitle(BannerConstantsService.MAX_LENGTH_VIDEO_FRONTPAGE_TITLE)
                .withMaxLengthTitleExtension(BannerWithTitleExtensionConstants.MAX_LENGTH_TITLE_EXTENSION)
                .withMaxLengthTitleWord(BannerConstantsService.MAX_LENGTH_TITLE_WORD)
                .withMaxLengthBody(BannerWithBodyConstants.MAX_LENGTH_BODY)
                .withMaxLengthMobileBody(BannerWithBodyConstants.MAX_LENGTH_MOBILE_BODY)
                .withMaxLengthContentPromotionBody(BannerWithBodyConstants.MAX_LENGTH_CONTENT_PROMOTION_BODY)
                .withMaxLengthBodyWord(BannerWithBodyConstants.MAX_LENGTH_BODY_WORD)
                .withMaxNumberOfNarrowCharacters(BannerTextConstants.MAX_NUMBER_OF_NARROW_CHARACTERS)
                .withMaxLengthHref(BannerWithHrefConstants.MAX_LENGTH_HREF)
                .withMaxLengthDisplayHref(BannerWithDisplayHrefConstraints.MAX_LENGTH_DISPLAY_HREF)
                .withMaxLengthTurbolandingParams(BannerWithTurbolandingConstants.MAX_LENGTH_TURBOLANDING_PARAMS)
                .withMaxLengthTurboGalleryHref(BannerTurboGalleryConstraints.MAX_LENGTH_TURBO_GALLERY_HREF)
                .withMaxAdsInAdgroup(BannerConstants.MAX_BANNERS_IN_ADGROUP)
                .withMaxCalloutsCountOnAd(BannerWithCalloutsConstants.MAX_CALLOUTS_COUNT_ON_BANNER)
                .withMaxYaAudiencePixelsCountOnAd(BannerPixelsConstants.MAX_YA_AUDIENCE_PIXELS_COUNT_ON_BANNER)
                .withMaxNotYaAudiencePixelsCountOnAd(
                        BannerPixelsConstants.MAX_NOT_YA_AUDIENCE_PIXELS_COUNT_ON_BANNER_DEFAULT)
                .withAllowAdLetters(BannerLettersConstants.ALLOW_BANNER_LETTERS_STR)
                .withAllowAdDisplayHrefLetters(BannerWithDisplayHrefConstraints.ALLOW_BANNER_DISPLAY_HREF_LETTERS_STR)
                .withNarrowSymbols(BannerTextConstants.NARROW_SYMBOLS)
                .withAggregationDomains(GridValidationConstants.SITELINK_VALID_DOMAINS)
                .withAdTypesSupportsImages(
                        mapSet(ImageConstraints.BANNER_TYPES_SUPPORTS_IMAGE, BannerDataConverter::toGdAdType))
                .withImageAdImagesAllowedSizes(toGdImageSizes(sizes))
                .withMcbannerImagesAllowedSizes(toGdImageSizes(ImageConstants.ALLOWED_SIZES_FOR_MCBANNER));

        logger.info(res);

        return res;
    }

    public static Set<GdImageSize> toGdImageSizes(Set<ImageSize> imageSize) {
        return mapSet(imageSize, ValidationConstantsService::toGdImageSize);
    }

    public static GdImageSize toGdImageSize(ImageSize imageSize) {
        return new GdImageSize().withWidth(imageSize.getWidth()).withHeight(imageSize.getHeight());
    }

    static GdDirectConstantsVcardValidationData getVcardValidationData() {
        return new GdDirectConstantsVcardValidationData()
                .withCompanyNameMaxLength(AddVcardValidationService.COMPANY_NAME_MAX_LENGTH)
                .withContactPersonMaxLength(AddVcardValidationService.CONTACT_PERSON_MAX_LENGTH)
                .withContactEmailMaxLength(AddVcardValidationService.CONTACT_EMAIL_MAX_LENGTH)
                .withExtraMessageMaxLength(AddVcardValidationService.EXTRA_MESSAGE_MAX_LENGTH)
                .withCountryMaxLength(AddVcardValidationService.COUNTRY_MAX_LENGTH)
                .withCityMaxLength(AddVcardValidationService.CITY_MAX_LENGTH)
                .withStreetMaxLength(AddVcardValidationService.STREET_MAX_LENGTH)
                .withHouseWithBuildingMaxLength(AddVcardValidationService.HOUSE_MAX_LENGTH)
                .withApartmentMaxLength(AddVcardValidationService.APART_MAX_LENGTH)
                .withInstantMessengerLoginMaxLength(InstantMessengerValidator.LOGIN_MAX_LENGTH)
                .withPointOnMapLongitudeMin(PointOnMapValidator.LONGITUDE_MIN)
                .withPointOnMapLongitudeMax(PointOnMapValidator.LONGITUDE_MAX)
                .withPointOnMapLatitudeMin(PointOnMapValidator.LATITUDE_MIN)
                .withPointOnMapLatitudeMax(PointOnMapValidator.LATITUDE_MAX)
                .withCountryCodeMaxLength(PhoneValidator.COUNTRY_CODE_MAX_LENGTH)
                .withCityCodeMaxLength(PhoneValidator.CITY_CODE_MAX_LENGTH)
                .withPhoneNumberMinLength(PhoneValidator.PHONE_NUMBER_MIN_LENGTH)
                .withPhoneNumberMaxLength(PhoneValidator.PHONE_NUMBER_MAX_LENGTH)
                .withExtensionMaxLength(PhoneValidator.EXTENSION_MAX_LENGTH)
                .withEntirePhoneMinLength(PhoneValidator.ENTIRE_PHONE_MIN_LENGTH)
                .withEntirePhoneMaxLength(PhoneValidator.ENTIRE_PHONE_MAX_LENGTH)
                .withEntirePhoneWithExtensionMaxLength(PhoneValidator.ENTIRE_PHONE_WITH_EXTENSION_MAX_LENGTH);
    }

    static GdDirectConstantsCalloutValidationData getCalloutValidationData() {
        return new GdDirectConstantsCalloutValidationData()
                .withCalloutLettersAllowed(CalloutConstants.ALLOW_CALLOUT_LETTERS)
                .withCalloutsOnClientMaxCount(CalloutConstants.MAX_CALLOUTS_COUNT_ON_CLIENT)
                .withCalloutsOnClientMaxCountWithDeleted(CalloutConstants.MAX_CALLOUTS_COUNT_ON_CLIENT_WITH_DELETED)
                .withCalloutTextMaxLength(CalloutConstants.MAX_CALLOUT_TEXT_LENGTH);
    }

    static GdDirectConstantsSitelinkValidationData getSitelinkValidationData() {
        return new GdDirectConstantsSitelinkValidationData()
                .withSitelinkMaxCount(MAX_SITELINKS_PER_SET)
                .withAllowLetters(ALLOW_SITELINK_LETTERS)
                .withMaxDescriptionLength(MAX_SITELINK_DESC_LENGTH)
                .withMaxHrefLength(MAX_SITELINK_HREF_LENGTH)
                .withMaxTitleLength(MAX_SITELINK_TITLE_LENGTH);
    }

    static GdDirectConstantsKeywordsValidationData getKeywordsValidationData() {
        return new GdDirectConstantsKeywordsValidationData()
                .withKeywordMaxLength(KEYWORD_MAX_LENGTH)
                .withWordMaxLength(WORD_MAX_LENGTH)
                .withWordsMaxCount(WORDS_MAX_COUNT);
    }

    static GdDirectConstantsMinusWordsLibValidationData getMinusWordsLibValidationData() {
        return new GdDirectConstantsMinusWordsLibValidationData()
                .withLibMinusKeywordsTextMaxLength(MinusPhraseConstraints.GROUP_MINUS_KEYWORDS_MAX_LENGTH)
                .withMaxLibraryPacksCount(MinusPhraseConstraints.MAX_LIBRARY_PACKS_COUNT)
                .withMaxLinkedPacksToOneAdGroup(MinusPhraseConstraints.MAX_LINKED_PACKS_TO_ONE_AD_GROUP)
                .withMaxNameLength(MinusKeywordsPackValidationService.MAX_NAME_LENGTH)
                .withMaxWordsInMinusPhrase(MinusPhraseConstraints.WORDS_MAX_COUNT)
                .withNameAllowLetters(TextConstants.ALL)
                .withTextAllowLetters(MinusPhrasePredicates.ALLOW_MINUS_KEYWORD_CHARS);

    }

    static GdDirectConstantsMinusWordsValidationData getMinusWordsValidationData() {
        return new GdDirectConstantsMinusWordsValidationData()
                .withNormalizedMinusKeywordsMaxLength(MinusPhraseConstraints.CAMPAIGN_MINUS_KEYWORDS_MAX_LENGTH);
    }

    static GdDirectConstantsPromoExtensionValidationData getPromoExtensionValidationData() {
        return new GdDirectConstantsPromoExtensionValidationData();
    }
}
