package ru.yandex.direct.grid.processing.service.contentpromotion;

import ru.yandex.direct.core.entity.contentpromotion.DefaultContentPromotionMeta;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContentType;
import ru.yandex.direct.core.entity.contentpromotion.type.video.VideoContentPromotionMeta;
import ru.yandex.direct.grid.processing.model.contentpromotion.GdContentPromotionMeta;

class ContentPromotionConverter {

    static GdContentPromotionMeta convertContentPromotionMeta(ContentPromotionContentType contentPromotionType,
                                                              DefaultContentPromotionMeta contentPromotionMeta) {
        if (contentPromotionMeta == null) {
            return null;
        }

        GdContentPromotionMeta gdContentPromotionMeta = new GdContentPromotionMeta()
                .withContentId(contentPromotionMeta.getContentId())
                .withPreviewUrl(contentPromotionMeta.getPreviewUrl())
                .withUrl(contentPromotionMeta.getUrl());

        switch (contentPromotionType) {
            case VIDEO:
                VideoContentPromotionMeta videoContentPromotionMeta = (VideoContentPromotionMeta) contentPromotionMeta;

                return gdContentPromotionMeta
                        .withTitle(videoContentPromotionMeta.getTitle())
                        .withDescription(videoContentPromotionMeta.getDescription());
            case COLLECTION:
                return gdContentPromotionMeta;
            default:
                throw new IllegalArgumentException("Content promotion type is not supported: " + contentPromotionType);
        }
    }
}
