package ru.yandex.direct.grid.processing.service.contentpromotion.model;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.contentpromotion.ContentStatus;

public enum GdContentPromotionStatus {
    OK,

    NOT_FOUND,

    INACCESSIBLE;

    @Nullable
    public static GdContentPromotionStatus fromSource(ContentStatus value) {
        if (value == null) {
            return null;
        }

        switch (value) {
            case OK:
                return OK;
            case NOT_FOUND:
                return NOT_FOUND;
            case INACCESSIBLE:
                return INACCESSIBLE;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }

    @Nullable
    public static ContentStatus toSource(GdContentPromotionStatus value) {
        if (value == null) {
            return null;
        }

        switch (value) {
            case OK:
                return ContentStatus.OK;
            case NOT_FOUND:
                return ContentStatus.NOT_FOUND;
            case INACCESSIBLE:
                return ContentStatus.INACCESSIBLE;
            default:
                throw new IllegalStateException("No such value: " + value);
        }
    }
}
