package ru.yandex.direct.grid.processing.service.contentpromotion.validation;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.grid.processing.model.contentpromotion.GdContentPromotionType;
import ru.yandex.direct.grid.processing.model.contentpromotion.GdGetContentPromotionMetaInput;
import ru.yandex.direct.grid.processing.service.validation.GridValidationService;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.contentpromotion.validation.defects.ContentPromotionDefects.contentPromotionTypeIsNotSupported;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Service
@ParametersAreNonnullByDefault
public class ContentPromotionMetaValidationService {

    private static final Set<GdContentPromotionType> SUPPORTED_CONTENT_PROMOTION_TYPES = Set.of(
            GdContentPromotionType.VIDEO,
            GdContentPromotionType.COLLECTION
    );

    private final GridValidationService gridValidationService;

    @Autowired
    public ContentPromotionMetaValidationService(GridValidationService gridValidationService) {
        this.gridValidationService = gridValidationService;
    }

    public void validateGetContentPromotionMetaInput(GdGetContentPromotionMetaInput gdGetContentPromotionMetaInput) {
        gridValidationService.applyValidator(this::validateGetContentPromotionMeta, gdGetContentPromotionMetaInput, false);
    }

    private ValidationResult<GdGetContentPromotionMetaInput, Defect> validateGetContentPromotionMeta(
            GdGetContentPromotionMetaInput input)
    {
        ItemValidationBuilder<GdGetContentPromotionMetaInput, Defect> vb = ItemValidationBuilder.of(input);

        vb.item(input.getContentPromotionType(), "contentPromotionType")
                .check(supportedType());

        vb.item(input.getUrl(), "url")
                .check(notNull());

        return vb.getResult();
    }

    private Constraint<GdContentPromotionType, Defect> supportedType() {
        return Constraint.fromPredicate(SUPPORTED_CONTENT_PROMOTION_TYPES::contains,
                contentPromotionTypeIsNotSupported());
    }
}
