package ru.yandex.direct.grid.processing.service.conversioncenter

import org.springframework.context.annotation.Scope
import org.springframework.context.annotation.ScopedProxyMode
import org.springframework.stereotype.Component
import org.springframework.web.context.WebApplicationContext
import ru.yandex.direct.core.entity.conversionsource.service.ConversionSourceService
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext
import ru.yandex.direct.grid.processing.model.goal.GdConversionCenterInfo
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader
import ru.yandex.direct.grid.processing.service.dataloader.GridContextProvider
import java.util.concurrent.CompletableFuture

@Component
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
class GoalConversionCenterInfoDataLoader(
    gridContextProvider: GridContextProvider,
    private val conversionSourceService: ConversionSourceService,
) : GridBatchingDataLoader<Long, GdConversionCenterInfo>() {

    init {
        dataLoader = mappedDataLoader(gridContextProvider) { goalIds: Set<Long>, environment ->
            if (goalIds.isEmpty()) {
                return@mappedDataLoader CompletableFuture.completedFuture(emptyMap())
            }
            val context = environment.getContext<GridGraphQLContext>()
            val clientId = context.queriedClient?.let { ClientId.fromLong(it.id) }
                ?: throw IllegalStateException("No queriedClient in graphql context")
            val result = conversionSourceService.calcSelectionInfo(clientId, goalIds)
            val converted = result.entries.associate { (goalId, selectionInfo) ->
                goalId to GdConversionCenterInfo()
                    .withSelected(selectionInfo.isSelected)
                    .withValue(selectionInfo.value.toGrid())
            }
            return@mappedDataLoader CompletableFuture.completedFuture(converted)
        }
    }
}
