package ru.yandex.direct.grid.processing.service.conversioncenter.validation

import org.springframework.stereotype.Service
import ru.yandex.direct.grid.processing.model.goal.GdConversionSourceSettingsUnion
import ru.yandex.direct.grid.processing.model.goal.GdConversionSourceTypeCode
import ru.yandex.direct.grid.processing.model.goal.GdUpdateConversionSource
import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.constraint.CommonConstraints.inSet
import ru.yandex.direct.validation.defect.CommonDefects
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.D
import ru.yandex.direct.validation.util.item
import ru.yandex.direct.validation.util.validateModel

private val SETTING_TYPES = mapOf(
    GdConversionSourceTypeCode.LINK to GdConversionSourceSettingsUnion::getLinkSettings,
    GdConversionSourceTypeCode.FTP to GdConversionSourceSettingsUnion::getFtpSettings,
    GdConversionSourceTypeCode.SFTP to GdConversionSourceSettingsUnion::getSftpSettings,
    GdConversionSourceTypeCode.GOOGLE_SHEETS to GdConversionSourceSettingsUnion::getGoogleSheetsSettings
)

@Service
class ConversionCenterValidationService {
    fun validateUpdateConversionSourceInput(input: GdUpdateConversionSource): ValidationResult<*, D> {
        val validationResult = validateModel(input) {
            item(GdUpdateConversionSource.TYPE) {
                check(inSet(SETTING_TYPES.keys))
            }
            if (!result.hasAnyErrors()) {
                item(GdUpdateConversionSource.SETTINGS) {
                    check(settingsIsSuitableForType(input.type))
                }
            }
        }
        return validationResult
    }

    private fun settingsIsSuitableForType(type: GdConversionSourceTypeCode): Constraint<GdConversionSourceSettingsUnion, D> {
        return Constraint.fromPredicate({ union: GdConversionSourceSettingsUnion ->
            val getSettings = SETTING_TYPES[type] ?: return@fromPredicate true
            getSettings(union) != null
        }, CommonDefects.invalidValue())
    }
}
