package ru.yandex.direct.grid.processing.service.creative;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import org.dataloader.MappedBatchLoaderWithContext;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.model.campaign.GdCampaignForLink;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;
import ru.yandex.direct.grid.processing.service.dataloader.GridContextProvider;

import static java.util.Collections.emptyList;

@Component
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class UsedInCampaignsLoader extends GridBatchingDataLoader<Long, List<GdCampaignForLink>> {

    public UsedInCampaignsLoader(GridContextProvider gridContextProvider,
                                 CreativeDataService creativeDataService) {
        dataLoader = mappedDataLoader(gridContextProvider, getBatchLoadFunction(creativeDataService));
    }

    private static MappedBatchLoaderWithContext<Long, List<GdCampaignForLink>> getBatchLoadFunction(
            CreativeDataService creativeDataService) {
        return (creativeIds, environment) -> {
            GridGraphQLContext context = environment.getContext();
            //noinspection ConstantConditions
            ClientId clientId = context.getSubjectUser().getClientId();
            Map<Long, List<GdCampaignForLink>> usedInCampaigns =
                    new HashMap<>(creativeDataService.getUsedInCampaigns(clientId, creativeIds));

            for (Long creativeId : creativeIds) {
                // Если кампании для креатива не нашлись, возвращаем пустой список
                usedInCampaigns.putIfAbsent(creativeId, emptyList());
            }
            return CompletableFuture.completedFuture(usedInCampaigns);
        };
    }

}
