package ru.yandex.direct.grid.processing.service.daas;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLEnvironment;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import io.leangen.graphql.execution.ResolutionEnvironment;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.grid.processing.annotations.EnableLoggingOnValidationIssues;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.daas.GdDaasMarkDeletedPayload;
import ru.yandex.direct.grid.processing.model.daas.GdDaasMarkStoppedPayload;
import ru.yandex.direct.grid.processing.model.daas.GdDaasModifyPayload;
import ru.yandex.direct.grid.processing.model.daas.GdDaasTaskInput;
import ru.yandex.direct.grid.processing.model.daas.GdDaasTaskListState;
import ru.yandex.direct.grid.processing.model.daas.GdDaasTaskType;
import ru.yandex.direct.grid.processing.processor.util.GridRequestedFields;
import ru.yandex.direct.grid.processing.processor.util.GridRequestedFieldsHolder;

import static com.google.common.base.Preconditions.checkState;

/**
 * Сервис, создания заказа для покупки Директа по кнопке
 */
@GridGraphQLService
@ParametersAreNonnullByDefault
public class GdDaasTaskCreationService {
    public static final String MODIFY_RESOLVER_NAME = "daasModify";
    public static final String STOP_RESOLVER_NAME = "daasStop";
    public static final String DELETE_RESOLVER_NAME = "daasDelete";
    public static final String GET_RESOLVER_NAME = "daasTaskInfo";
    public static final String TYPE_ARGUMENT_NAME = "type";
    public static final String EXTERNAL_ID_ARGUMENT_NAME = "extId";
    public static final String DAAS_INPUT_NAME = "input";

    private static final String DAAS_TASK_RESULT_FIELD = "tasksResult";

    static {
        checkState(DAAS_TASK_RESULT_FIELD.equals(GdDaasTaskListState.TASKS_RESULT.name()));
    }

    @Autowired
    public GdDaasTaskCreationService() {
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @EnableLoggingOnValidationIssues
    @GraphQLMutation(name = MODIFY_RESOLVER_NAME)
    public GdDaasModifyPayload daasModify(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLArgument(name = DAAS_INPUT_NAME) @GraphQLNonNull GdDaasTaskInput input,
            @GraphQLArgument(name = TYPE_ARGUMENT_NAME) @GraphQLNonNull GdDaasTaskType type,
            @GraphQLArgument(name = EXTERNAL_ID_ARGUMENT_NAME) @Nullable String extId,
            @GraphQLEnvironment ResolutionEnvironment resolutionEnvironment) {
        throw new UnsupportedOperationException("daas not supported");
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @EnableLoggingOnValidationIssues
    @GraphQLMutation(name = STOP_RESOLVER_NAME)
    public GdDaasMarkStoppedPayload daasStop(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLArgument(name = "stopped") @GraphQLNonNull Boolean isStopped,
            @GraphQLArgument(name = TYPE_ARGUMENT_NAME) @GraphQLNonNull GdDaasTaskType type,
            @GraphQLArgument(name = EXTERNAL_ID_ARGUMENT_NAME) @GraphQLNonNull String extId) {
        throw new UnsupportedOperationException("daas not supported");
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @EnableLoggingOnValidationIssues
    @GraphQLMutation(name = DELETE_RESOLVER_NAME)
    public GdDaasMarkDeletedPayload daasDelete(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLArgument(name = TYPE_ARGUMENT_NAME) @GraphQLNonNull GdDaasTaskType type,
            @GraphQLArgument(name = EXTERNAL_ID_ARGUMENT_NAME) @GraphQLNonNull String extId) {
        throw new UnsupportedOperationException("daas not supported");
    }

    @GraphQLNonNull
    @PreAuthorizeRead
    @GraphQLQuery(name = GET_RESOLVER_NAME)
    public GdDaasTaskListState daasTaskInfo(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLArgument(name = TYPE_ARGUMENT_NAME) @GraphQLNonNull GdDaasTaskType type,
            @GraphQLArgument(name = EXTERNAL_ID_ARGUMENT_NAME) @Nullable String extId,
            @GridRequestedFields(childFieldPath = {
                    DAAS_TASK_RESULT_FIELD //"tasksResult"
            }) GridRequestedFieldsHolder requestedFieldsHolder) {
        throw new UnsupportedOperationException("daas not supported");
    }
}
