package ru.yandex.direct.grid.processing.service.dataloader;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.dataloader.BatchLoader;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderOptions;
import org.dataloader.MappedBatchLoaderWithContext;


/**
 * Обертка над {@link DataLoader} с отключенным по умолчанию кэшированием.
 * <p>
 * Используемые в {@link ru.yandex.direct.grid.processing.processor.GridGraphQLProcessor} {@link DataLoader}'ы
 * рекомендуется наследовать от {@link GridBatchingDataLoader}, чтобы они регистрировались
 * в {@link GridDataLoaderRegistry} при инициализации Spring-контекста.
 */
@ParametersAreNonnullByDefault
abstract public class GridBatchingDataLoader<K, V> implements DataLoaderProvider<K, V> {

    protected DataLoader<K, V> dataLoader;

    protected GridBatchingDataLoader() {
    }

    @Override
    public DataLoader<K, V> get() {
        return dataLoader;
    }

    protected static <K, V> DataLoader<K, V> dataLoader(BatchLoader<K, V> batchLoadFunction) {
        return new DataLoader<>(batchLoadFunction, getDataLoaderOptions(null));
    }

    protected static <K, V> DataLoader<K, V> mappedDataLoader(GridContextProvider gridContextProvider,
                                                              MappedBatchLoaderWithContext<K, V> batchLoadFunction) {
        return DataLoader.newMappedDataLoader(batchLoadFunction, getDataLoaderOptions(gridContextProvider));
    }

    private static DataLoaderOptions getDataLoaderOptions(@Nullable GridContextProvider gridContextProvider) {
        DataLoaderOptions dataLoaderOptions = new DataLoaderOptions().setCachingEnabled(false);
        if (gridContextProvider != null) {
            dataLoaderOptions.setBatchLoaderContextProvider(gridContextProvider::getGridContext);
        }
        return dataLoaderOptions;
    }

}
