package ru.yandex.direct.grid.processing.service.dataloader;

import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;

/**
 * Request-scoped хранилище {@link GridGraphQLContext}. Удобно при использовании в {@link org.dataloader.DataLoader},
 * требующих контекста в виде {@code subjectUser} или {@code operator}.
 */
@Component
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class GridContextProvider {
    private GridGraphQLContext gridContext;

    public GridGraphQLContext getGridContext() {
        return gridContext;
    }

    public void setGridContext(GridGraphQLContext context) {
        this.gridContext = context;
    }
}
