package ru.yandex.direct.grid.processing.service.dynamiccondition;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicFeedAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicFeedRule;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicTextAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRule;
import ru.yandex.direct.grid.processing.model.api.GdValidationResult;
import ru.yandex.direct.grid.processing.model.dynamiccondition.mutation.GdAddDynamicFeedAdTargets;
import ru.yandex.direct.grid.processing.model.dynamiccondition.mutation.GdAddDynamicFeedAdTargetsItem;
import ru.yandex.direct.grid.processing.model.dynamiccondition.mutation.GdAddDynamicFeedCondition;
import ru.yandex.direct.grid.processing.model.dynamiccondition.mutation.GdAddDynamicWebpageAdTargets;
import ru.yandex.direct.grid.processing.model.dynamiccondition.mutation.GdAddDynamicWebpageAdTargetsItem;
import ru.yandex.direct.grid.processing.model.dynamiccondition.mutation.GdAddDynamicWebpageCondition;
import ru.yandex.direct.grid.processing.model.dynamiccondition.mutation.GdUpdateDynamicFeedAdTargets;
import ru.yandex.direct.grid.processing.model.dynamiccondition.mutation.GdUpdateDynamicFeedAdTargetsItem;
import ru.yandex.direct.grid.processing.model.dynamiccondition.mutation.GdUpdateDynamicWebpageAdTargets;
import ru.yandex.direct.grid.processing.model.dynamiccondition.mutation.GdUpdateDynamicWebpageAdTargetsItem;
import ru.yandex.direct.grid.processing.service.validation.presentation.SkipByDefaultMappingPathNodeConverter;
import ru.yandex.direct.validation.result.DefaultPathNodeConverterProvider;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.Path;
import ru.yandex.direct.validation.result.PathNode;
import ru.yandex.direct.validation.result.PathNodeConverter;
import ru.yandex.direct.validation.result.PathNodeConverterProvider;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.grid.processing.service.validation.GridValidationResultConversionService.buildGridValidationResultIfErrors;
import static ru.yandex.direct.validation.result.PathHelper.emptyPath;
import static ru.yandex.direct.validation.result.PathHelper.field;
import static ru.yandex.direct.validation.result.PathHelper.path;

@ParametersAreNonnullByDefault
public class DynamicConditionsPathConverters {

    private static final PathNodeConverter PATH_CONVERTER_FOR_GD_ADD_DYNAMIC_WEBPAGE_AD_TARGET =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .replace(DynamicTextAdTarget.AD_GROUP_ID, GdAddDynamicWebpageAdTargetsItem.AD_GROUP_ID)
                    .replace(DynamicTextAdTarget.CONDITION_NAME, GdAddDynamicWebpageAdTargetsItem.NAME)
                    .replace(DynamicTextAdTarget.CONDITION, GdAddDynamicWebpageAdTargetsItem.CONDITIONS)
                    .replace(DynamicTextAdTarget.PRICE, GdAddDynamicWebpageAdTargetsItem.PRICE)
                    .replace(DynamicTextAdTarget.PRICE_CONTEXT, GdAddDynamicWebpageAdTargetsItem.PRICE_CONTEXT)
                    .replace(DynamicTextAdTarget.AUTOBUDGET_PRIORITY,
                            GdAddDynamicWebpageAdTargetsItem.AUTOBUDGET_PRIORITY)
                    .build();

    private static final PathNodeConverter PATH_CONVERTER_FOR_GD_UPDATE_DYNAMIC_WEBPAGE_AD_TARGET =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .replace(DynamicTextAdTarget.ID, GdUpdateDynamicWebpageAdTargetsItem.ID)
                    .replace(DynamicTextAdTarget.CONDITION_NAME, GdUpdateDynamicWebpageAdTargetsItem.NAME)
                    .replace(DynamicTextAdTarget.CONDITION, GdUpdateDynamicWebpageAdTargetsItem.CONDITIONS)
                    .replace(DynamicTextAdTarget.PRICE, GdUpdateDynamicWebpageAdTargetsItem.PRICE)
                    .replace(DynamicTextAdTarget.PRICE_CONTEXT, GdUpdateDynamicWebpageAdTargetsItem.PRICE_CONTEXT)
                    .replace(DynamicTextAdTarget.AUTOBUDGET_PRIORITY,
                            GdUpdateDynamicWebpageAdTargetsItem.AUTOBUDGET_PRIORITY)
                    .replace(DynamicTextAdTarget.IS_SUSPENDED, GdUpdateDynamicWebpageAdTargetsItem.IS_SUSPENDED)
                    .build();

    private static final PathNodeConverter PATH_CONVERTER_FOR_GD_ADD_DYNAMIC_WEBPAGE_CONDITION =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .replace(WebpageRule.TYPE, GdAddDynamicWebpageCondition.OPERAND)
                    .replace(WebpageRule.KIND, GdAddDynamicWebpageCondition.OPERATOR)
                    .replace(WebpageRule.VALUE, GdAddDynamicWebpageCondition.ARGUMENTS)
                    .build();

    private static final PathNodeConverterProvider PATH_CONVERTER_PROVIDER_FOR_GD_ADD_DYNAMIC_WEBPAGE_AD_TARGETS =
            DefaultPathNodeConverterProvider.builder()
                    .register(DynamicTextAdTarget.class, PATH_CONVERTER_FOR_GD_ADD_DYNAMIC_WEBPAGE_AD_TARGET)
                    .register(WebpageRule.class, PATH_CONVERTER_FOR_GD_ADD_DYNAMIC_WEBPAGE_CONDITION)
                    .build();

    private static final PathNodeConverterProvider PATH_CONVERTER_PROVIDER_FOR_GD_UPDATE_DYNAMIC_WEBPAGE_AD_TARGETS =
            DefaultPathNodeConverterProvider.builder()
                    .register(DynamicTextAdTarget.class, PATH_CONVERTER_FOR_GD_UPDATE_DYNAMIC_WEBPAGE_AD_TARGET)
                    .register(WebpageRule.class, PATH_CONVERTER_FOR_GD_ADD_DYNAMIC_WEBPAGE_CONDITION)
                    .build();

    private static final PathNodeConverter PATH_CONVERTER_FOR_GD_ADD_DYNAMIC_FEED_AD_TARGET =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .replace(DynamicFeedAdTarget.AD_GROUP_ID, GdAddDynamicFeedAdTargetsItem.AD_GROUP_ID)
                    .replace(DynamicFeedAdTarget.CONDITION_NAME, GdAddDynamicFeedAdTargetsItem.NAME)
                    .replace(DynamicFeedAdTarget.CONDITION, GdAddDynamicFeedAdTargetsItem.CONDITIONS)
                    .replace(DynamicFeedAdTarget.PRICE, GdAddDynamicFeedAdTargetsItem.PRICE)
                    .replace(DynamicFeedAdTarget.PRICE_CONTEXT, GdAddDynamicFeedAdTargetsItem.PRICE_CONTEXT)
                    .replace(DynamicFeedAdTarget.AUTOBUDGET_PRIORITY,
                            GdAddDynamicFeedAdTargetsItem.AUTOBUDGET_PRIORITY)
                    .replace(DynamicFeedAdTarget.TAB, GdAddDynamicFeedAdTargetsItem.TAB)
                    .build();

    private static final PathNodeConverter PATH_CONVERTER_FOR_GD_UPDATE_DYNAMIC_FEED_AD_TARGET =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .replace(DynamicFeedAdTarget.ID, GdUpdateDynamicFeedAdTargetsItem.ID)
                    .replace(DynamicFeedAdTarget.CONDITION_NAME, GdUpdateDynamicFeedAdTargetsItem.NAME)
                    .replace(DynamicFeedAdTarget.CONDITION, GdUpdateDynamicFeedAdTargetsItem.CONDITIONS)
                    .replace(DynamicFeedAdTarget.PRICE, GdUpdateDynamicFeedAdTargetsItem.PRICE)
                    .replace(DynamicFeedAdTarget.PRICE_CONTEXT, GdUpdateDynamicFeedAdTargetsItem.PRICE_CONTEXT)
                    .replace(DynamicFeedAdTarget.AUTOBUDGET_PRIORITY,
                            GdUpdateDynamicFeedAdTargetsItem.AUTOBUDGET_PRIORITY)
                    .replace(DynamicFeedAdTarget.IS_SUSPENDED, GdUpdateDynamicFeedAdTargetsItem.IS_SUSPENDED)
                    .replace(DynamicFeedAdTarget.TAB, GdUpdateDynamicFeedAdTargetsItem.TAB)
                    .build();

    private static final PathNodeConverter PATH_CONVERTER_FOR_GD_ADD_DYNAMIC_FEED_CONDITION =
            new PathNodeConverter() {
                private PathNodeConverter innerConverter = SkipByDefaultMappingPathNodeConverter.builder()
                        .replace(DynamicFeedRule.FIELD_NAME, GdAddDynamicFeedCondition.FIELD)
                        .replace(DynamicFeedRule.OPERATOR, GdAddDynamicFeedCondition.OPERATOR)
                        .replace(DynamicFeedRule.STRING_VALUE, GdAddDynamicFeedCondition.STRING_VALUE)
                        .replace(DynamicFeedRule.PARSED_VALUE, GdAddDynamicFeedCondition.STRING_VALUE.name())
                        .build();

                @Override
                public Path convert(PathNode.Field field) {
                    return innerConverter.convert(field);
                }

                /**
                 * Убирает индекс из пути для списочных объектов, т.к. списочные объекты в ядровой модели появляются
                 * только при парсинге нз несписочного STRING_VALUE в гридовой модели.
                 */
                @Override
                public Path convert(PathNode.Field field, PathNode.Index index) {
                    return emptyPath();
                }
            };

    private static final PathNodeConverterProvider PATH_CONVERTER_PROVIDER_FOR_GD_ADD_DYNAMIC_FEED_AD_TARGETS =
            DefaultPathNodeConverterProvider.builder()
                    .register(DynamicFeedAdTarget.class, PATH_CONVERTER_FOR_GD_ADD_DYNAMIC_FEED_AD_TARGET)
                    .register(DynamicFeedRule.class, PATH_CONVERTER_FOR_GD_ADD_DYNAMIC_FEED_CONDITION)
                    .build();

    private static final PathNodeConverterProvider PATH_CONVERTER_PROVIDER_FOR_GD_UPDATE_DYNAMIC_FEED_AD_TARGETS =
            DefaultPathNodeConverterProvider.builder()
                    .register(DynamicFeedAdTarget.class, PATH_CONVERTER_FOR_GD_UPDATE_DYNAMIC_FEED_AD_TARGET)
                    .register(DynamicFeedRule.class, PATH_CONVERTER_FOR_GD_ADD_DYNAMIC_FEED_CONDITION)
                    .build();

    private DynamicConditionsPathConverters() {
    }

    @Nullable
    public static GdValidationResult toGdAddWebpageAdTargetsValidationResult(@Nullable ValidationResult<?, Defect> vr) {
        return buildGridValidationResultIfErrors(vr, path(field(GdAddDynamicWebpageAdTargets.ADD_ITEMS)),
                PATH_CONVERTER_PROVIDER_FOR_GD_ADD_DYNAMIC_WEBPAGE_AD_TARGETS);
    }

    @Nullable
    public static GdValidationResult toGdAddFeedAdTargetsValidationResult(@Nullable ValidationResult<?, Defect> vr) {
        return buildGridValidationResultIfErrors(vr, path(field(GdAddDynamicFeedAdTargets.ADD_ITEMS)),
                PATH_CONVERTER_PROVIDER_FOR_GD_ADD_DYNAMIC_FEED_AD_TARGETS);
    }

    @Nullable
    public static GdValidationResult toGdUpdateWebpageAdTargetsValidationResult(
            @Nullable ValidationResult<?, Defect> vr) {
        return buildGridValidationResultIfErrors(vr, path(field(GdUpdateDynamicWebpageAdTargets.UPDATE_ITEMS)),
                PATH_CONVERTER_PROVIDER_FOR_GD_UPDATE_DYNAMIC_WEBPAGE_AD_TARGETS);
    }

    @Nullable
    public static GdValidationResult toGdUpdateFeedAdTargetsValidationResult(@Nullable ValidationResult<?, Defect> vr) {
        return buildGridValidationResultIfErrors(vr, path(field(GdUpdateDynamicFeedAdTargets.UPDATE_ITEMS)),
                PATH_CONVERTER_PROVIDER_FOR_GD_UPDATE_DYNAMIC_FEED_AD_TARGETS);
    }
}
