package ru.yandex.direct.grid.processing.service.feedoffer;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLContext;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.processing.annotations.EnableLoggingOnValidationIssues;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.client.GdClient;
import ru.yandex.direct.grid.processing.model.feedoffer.GdAddOrUpdateFeedOffer;
import ru.yandex.direct.grid.processing.model.feedoffer.GdAddOrUpdateFeedOfferPayload;
import ru.yandex.direct.grid.processing.model.feedoffer.GdFeedOffersContext;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class FeedOfferGraphQlService {

    private final FeedOfferDataService feedOfferDataService;

    @Autowired
    public FeedOfferGraphQlService(FeedOfferDataService feedOfferDataService) {
        this.feedOfferDataService = feedOfferDataService;
    }

    @GraphQLNonNull
    @GraphQLQuery(name = "feedOffers")
    public GdFeedOffersContext getFeedOffers(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLContext GdClient client
    ) {
        ClientId clientId = ClientId.fromLong(client.getInfo().getId());

        return feedOfferDataService.getFeedOffers(clientId);
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @EnableLoggingOnValidationIssues
    @GraphQLMutation(name = "addOrUpdateFeedOffers")
    public GdAddOrUpdateFeedOfferPayload addOrUpdateFeedOffers(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdAddOrUpdateFeedOffer input
    ) {
        //noinspection ConstantConditions
        return feedOfferDataService.addOrUpdateFeedOffers(context.getSubjectUser().getClientId(),
                context.getSubjectUser().getUid(), context.getOperator().getUid(), input);
    }
}
