package ru.yandex.direct.grid.processing.service.feedoffer.converter;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.feedoffer.model.FeedOffer;
import ru.yandex.direct.core.entity.feedoffer.model.RetailFeedOfferParams;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.processing.model.api.GdValidationResult;
import ru.yandex.direct.grid.processing.model.feedoffer.GdFeedOffer;
import ru.yandex.direct.grid.processing.model.feedoffer.GdFeedOfferAddItem;
import ru.yandex.direct.grid.processing.model.feedoffer.GdRetailFeedOfferParams;
import ru.yandex.direct.grid.processing.service.validation.GridValidationResultConversionService;
import ru.yandex.direct.grid.processing.service.validation.presentation.SkipByDefaultMappingPathNodeConverter;
import ru.yandex.direct.validation.result.DefaultPathNodeConverterProvider;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.Path;
import ru.yandex.direct.validation.result.PathNodeConverter;
import ru.yandex.direct.validation.result.PathNodeConverterProvider;
import ru.yandex.direct.validation.result.ValidationResult;

public class GdFeedOfferConverter {

    private static final PathNodeConverter VALIDATE_GD_FEED_OFFER_ADD_ITEM_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .replace(FeedOffer.ID.name(), GdFeedOfferAddItem.ID.name())
                    .replace(FeedOffer.LABEL.name(), GdFeedOfferAddItem.LABEL.name())
                    .replace(FeedOffer.DESCRIPTION.name(), GdFeedOfferAddItem.DESCRIPTION.name())
                    .replace(FeedOffer.HREF.name(), GdFeedOfferAddItem.HREF.name())
                    .replace(FeedOffer.IMAGES.name(), GdFeedOfferAddItem.IMAGES.name())
                    .replace(FeedOffer.CURRENCY.name(), GdFeedOfferAddItem.CURRENCY.name())
                    .replace(FeedOffer.CURRENT_PRICE.name(), GdFeedOfferAddItem.CURRENT_PRICE.name())
                    .replace(FeedOffer.OLD_PRICE.name(), GdFeedOfferAddItem.OLD_PRICE.name())
                    .replace(FeedOffer.IS_AVAILABLE.name(), GdFeedOfferAddItem.IS_AVAILABLE.name())
                    .replace(FeedOffer.RETAIL_FEED_OFFER_PARAMS.name(), GdFeedOfferAddItem.RETAIL_PARAMS.name())
                    .build();

    private static final PathNodeConverter VALIDATE_GD_RETAIL_FEED_OFFER_PARAMS_CONVERTER =
            SkipByDefaultMappingPathNodeConverter.builder()
                    .replace(RetailFeedOfferParams.CATEGORY.name(), GdRetailFeedOfferParams.CATEGORY.name())
                    .replace(RetailFeedOfferParams.VENDOR.name(), GdRetailFeedOfferParams.VENDOR.name())
                    .replace(RetailFeedOfferParams.MODEL.name(), GdRetailFeedOfferParams.MODEL.name())
                    .build();

    private static final PathNodeConverterProvider PATH_NODE_CONVERTER_PROVIDER =
            DefaultPathNodeConverterProvider.builder()
                    .register(FeedOffer.class, VALIDATE_GD_FEED_OFFER_ADD_ITEM_CONVERTER)
                    .register(RetailFeedOfferParams.class, VALIDATE_GD_RETAIL_FEED_OFFER_PARAMS_CONVERTER)
                    .build();

    private GdFeedOfferConverter() {
    }

    public static FeedOffer fromGdFeedOfferAddItem(GdFeedOfferAddItem feedOffer, ClientId clientId) {
        return new FeedOffer()
                .withId(feedOffer.getId())
                .withClientId(clientId.asLong())
                .withLabel(feedOffer.getLabel())
                .withDescription(feedOffer.getDescription())
                .withHref(feedOffer.getHref())
                .withImages(feedOffer.getImages())
                .withCurrency(feedOffer.getCurrency())
                .withCurrentPrice(feedOffer.getCurrentPrice())
                .withOldPrice(feedOffer.getOldPrice())
                .withIsAvailable(feedOffer.getIsAvailable())
                .withRetailFeedOfferParams(fromGdRetailFeedOfferParams(feedOffer.getRetailParams()));
    }

    private static RetailFeedOfferParams fromGdRetailFeedOfferParams(GdRetailFeedOfferParams params) {
        if (params == null) {
            return null;
        }

        return new RetailFeedOfferParams()
                .withCategory(params.getCategory())
                .withVendor(params.getVendor())
                .withModel(params.getModel());
    }

    public static GdFeedOffer toGdFeedOffer(FeedOffer offer) {
        return new GdFeedOffer()
                .withId(offer.getId())
                .withLabel(offer.getLabel())
                .withDescription(offer.getDescription())
                .withHref(offer.getHref())
                .withImages(offer.getImages())
                .withCurrency(offer.getCurrency())
                .withCurrentPrice(offer.getCurrentPrice())
                .withOldPrice(offer.getOldPrice())
                .withIsAvailable(offer.getIsAvailable())
                .withRetailParams(toGdRetailFeedOfferParams(offer.getRetailFeedOfferParams()));
    }

    private static GdRetailFeedOfferParams toGdRetailFeedOfferParams(RetailFeedOfferParams params) {
        if (params == null) {
            return null;
        }

        return new GdRetailFeedOfferParams()
                .withCategory(params.getCategory())
                .withVendor(params.getVendor())
                .withModel(params.getModel());
    }

    @Nullable
    public static GdValidationResult getValidationResult(ValidationResult<?, Defect> vr, Path path) {
        return GridValidationResultConversionService
                .buildGridValidationResultIfErrors(vr, path, PATH_NODE_CONVERTER_PROVIDER);
    }
}
