package ru.yandex.direct.grid.processing.service.forecast;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLQuery;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.forecast.GdForecast;
import ru.yandex.direct.grid.processing.model.forecast.GdForecastContainer;
import ru.yandex.direct.grid.processing.model.forecast.GdShowStat;
import ru.yandex.direct.grid.processing.model.forecast.GdShowStatContainer;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class ForecastGraphQlService {

    private final ForecastService forecastService;

    @Autowired
    public ForecastGraphQlService(ForecastService forecastService) {
        this.forecastService = forecastService;
    }

    @GraphQLNonNull
    @GraphQLQuery(name = "showStat")
    public GdShowStat getShowStat(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdShowStatContainer input) {
        return forecastService.getShowStat(input);
    }

    @GraphQLNonNull
    @GraphQLQuery(name = "forecast")
    public GdForecast getClicksForecast(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdForecastContainer input) {
        return forecastService.getForecast(context, input);
    }
}
