package ru.yandex.direct.grid.processing.service.forecast.clicks;

public class BoughtTrafficItem {

    private final TrafficItem trafficItem;
    private final Long boughtClicks;

    public BoughtTrafficItem(TrafficItem trafficItem, Long boughtClicks) {
        this.trafficItem = trafficItem;
        this.boughtClicks = boughtClicks;
    }

    public Long getBoughtClicks() {
        return boughtClicks;
    }

    public boolean isBoughtMaxClicks() {
        return boughtClicks.equals(trafficItem.getMaxClicks());
    }

    public Double getCost() {
        return boughtClicks * trafficItem.getCpc();
    }
}
