package ru.yandex.direct.grid.processing.service.freelancer;

import java.util.concurrent.CompletableFuture;

import org.dataloader.DataLoader;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.grid.processing.model.freelancer.GdFreelancerClient;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;

/**
 * {@link DataLoader} для отложенной batch'евой загрузки клиентов, относящихся к проекту
 *
 * @see GridBatchingDataLoader
 * @see ru.yandex.direct.grid.processing.service.dataloader.GridDataLoaderRegistry
 */
@Component
// DataLoader'ы хранят состояние, поэтому жить должны в рамках запроса
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class FreelancerClientDataLoader extends GridBatchingDataLoader<Long, GdFreelancerClient> {

    public FreelancerClientDataLoader(FreelancerDataService freelancerDataService) {
        dataLoader =
                dataLoader(keys -> CompletableFuture.completedFuture(freelancerDataService.getFreelancerClients(keys)));
    }
}
