package ru.yandex.direct.grid.processing.service.freelancer;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

import one.util.streamex.StreamEx;
import org.dataloader.DataLoader;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.grid.processing.model.freelancer.GdFreelancer;
import ru.yandex.direct.grid.processing.model.freelancer.GdFreelancerFilter;
import ru.yandex.direct.grid.processing.model.freelancer.GdFreelancerFull;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * {@link DataLoader} для отложенной batch'евой загрузки проектов фрилансера
 *
 * @see GridBatchingDataLoader
 * @see ru.yandex.direct.grid.processing.service.dataloader.GridDataLoaderRegistry
 */
@Component
// DataLoader'ы хранят состояние, поэтому жить должны в рамках запроса
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class FreelancerDataLoader extends GridBatchingDataLoader<Long, GdFreelancer> {

    public FreelancerDataLoader(FreelancerDataService freelancerDataService) {
        dataLoader = dataLoader(keys -> {
            Map<Long, GdFreelancer> freelancersById = StreamEx.of(freelancerDataService
                    .getFreelancers(new GdFreelancerFilter().withFreelancerIds(keys), GdFreelancerFull::new, null))
                    .toMap(GdFreelancer::getFreelancerId, Function.identity());
            return CompletableFuture.completedFuture(mapList(keys, freelancersById::get));
        });

    }
}
