package ru.yandex.direct.grid.processing.service.freelancer;

import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerProject;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerProjectStatus;
import ru.yandex.direct.grid.processing.model.freelancer.GdFreelancerProject;
import ru.yandex.direct.grid.processing.model.freelancer.GdFreelancerProjectStatus;
import ru.yandex.direct.grid.processing.model.freelancer.GdProject;

/**
 * Конвертер из core-модели {@link FreelancerProject} в модель интерфейса {@link GdFreelancerProject}
 */
@Component
@ParametersAreNonnullByDefault
class FreelancerProjectConverter {
    <T extends GdProject> T convert(FreelancerProject project, Supplier<T> modelSupplier) {
        T model = modelSupplier.get();
        model.withId(project.getId())
                .withCreatedTime(project.getCreatedTime())
                .withStartedTime(project.getStartedTime())
                .withUpdatedTime(project.getUpdatedTime())
                .withClientId(project.getClientId())
                .withFreelancerId(project.getFreelancerId())
                .withStatus(toGdStatus(project.getStatus()));
        return model;
    }

    private GdFreelancerProjectStatus toGdStatus(FreelancerProjectStatus status) {
        switch (status) {
            case NEW:
                return GdFreelancerProjectStatus.NEW;
            case INPROGRESS:
                return GdFreelancerProjectStatus.IN_PROGRESS;
            case CANCELLEDBYCLIENT:
                return GdFreelancerProjectStatus.CANCELLED_BY_CLIENT;
            case CANCELLEDBYFREELANCER:
                return GdFreelancerProjectStatus.CANCELLED_BY_FREELANCER;
            default:
                throw new IllegalStateException("No such value: " + status);
        }
    }

}
