package ru.yandex.direct.grid.processing.service.freelancer;

import java.util.Map;
import java.util.concurrent.CompletableFuture;

import org.dataloader.DataLoader;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.grid.processing.model.freelancer.GdFreelancerRegionTranslation;
import ru.yandex.direct.grid.processing.model.freelancer.GdFreelancerRegionTranslationKey;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * {@link DataLoader} для отложенной batch'евой загрузки региона специалиста {@link GdFreelancerRegionTranslation}
 *
 * @see GridBatchingDataLoader
 * @see ru.yandex.direct.grid.processing.service.dataloader.GridDataLoaderRegistry
 */
@Component
// DataLoader'ы хранят состояние, поэтому жить должны в рамках запроса
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class FreelancerRegionTranslationDataLoader extends GridBatchingDataLoader<GdFreelancerRegionTranslationKey, GdFreelancerRegionTranslation> {

    public FreelancerRegionTranslationDataLoader(FreelancerDataService freelancerDataService) {
        dataLoader = dataLoader(keys -> {
            Map<GdFreelancerRegionTranslationKey, GdFreelancerRegionTranslation> translationsByKey =
                    freelancerDataService.getRegionTranslations(keys);
            return CompletableFuture.completedFuture(mapList(keys, translationsByKey::get));
        });
    }
}
