package ru.yandex.direct.grid.processing.service.freelancer;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import org.dataloader.DataLoader;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.grid.processing.model.freelancer.GdFreelancerSkill;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;

/**
 * {@link DataLoader} для отложенной batch'евой загрузки услуг фрилансера
 *
 * @see ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader
 * @see ru.yandex.direct.grid.processing.service.dataloader.GridDataLoaderRegistry
 */
@Component
// DataLoader'ы хранят состояние, поэтому жить должны в рамках запроса
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class FreelancerSkillDataLoader extends GridBatchingDataLoader<Long, List<GdFreelancerSkill>> {

    public FreelancerSkillDataLoader(FreelancerDataService freelancerDataService) {
        dataLoader =
                dataLoader(keys -> CompletableFuture.completedFuture(freelancerDataService.getFreelancersSkills(keys)));
    }
}
