package ru.yandex.direct.grid.processing.service.goal;

import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.GraphQLRootContext;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.processing.annotations.GridGraphQLService;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.goal.mutation.GdCreateMetrikaGoals;
import ru.yandex.direct.grid.processing.model.goal.mutation.GdCreateMetrikaGoalsPayload;
import ru.yandex.direct.grid.processing.model.goal.mutation.GdLalSegments;
import ru.yandex.direct.grid.processing.model.goal.mutation.GdLalSegmentsPayload;
import ru.yandex.direct.grid.processing.model.goal.mutation.GdMetrikaSegmentByPresets;
import ru.yandex.direct.grid.processing.model.goal.mutation.GdMetrikaSegmentsByPresetsPayload;

@GridGraphQLService
@ParametersAreNonnullByDefault
public class GoalMutationGraphQlService {

    private final GoalMutationService goalMutationService;

    @Autowired
    public GoalMutationGraphQlService(GoalMutationService goalMutationService) {
        this.goalMutationService = goalMutationService;
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "createMetrikaSegmentByPreset")
    public GdMetrikaSegmentsByPresetsPayload createMetrikaSegmentByPreset(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdMetrikaSegmentByPresets input
    ) {
        ClientId clientId = context.getSubjectUser().getClientId();
        return goalMutationService.createMetrikaSegmentByPreset(clientId, input.getItems());
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "createLalSegmentForGoal")
    public GdLalSegmentsPayload createLalSegmentForGoal(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdLalSegments input
    ) {
        ClientId clientId = context.getSubjectUser().getClientId();
        return goalMutationService.createLalSegments(clientId, input);
    }

    @GraphQLNonNull
    @PreAuthorizeWrite
    @GraphQLMutation(name = "createMetrikaGoals")
    public GdCreateMetrikaGoalsPayload createMetrikaGoals(
            @GraphQLRootContext GridGraphQLContext context,
            @GraphQLNonNull @GraphQLArgument(name = "input") GdCreateMetrikaGoals input
    ) {

        ClientId clientId = context.getSubjectUser().getClientId();
        Long operatorUid = context.getOperator().getUid();
        return goalMutationService.createMetrikaGoals(operatorUid, clientId, input);
    }
}
