package ru.yandex.direct.grid.processing.service.goal;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

public interface GoalNameTranslations extends TranslationBundle {
    GoalNameTranslations INSTANCE = I18NBundle.implement(GoalNameTranslations.class);

    @TranslationStub("Клики по всем email - создано в Яндекс.Директ")
    Translatable clickOnAnyEmail();

    @MessageFormatStub("Клики по email {0} - создано в Яндекс.Директ")
    Translatable clickOnSpecifiedEmail(String email);

    @TranslationStub("Клики по всем телефонам - создано в Яндекс.Директ")
    Translatable clickOnAnyPhone();

    @MessageFormatStub("Клики по номеру {0} - создано в Яндекс.Директ")
    Translatable clickOnSpecifiedPhone(String phone);

    @TranslationStub("Все формы - создано в Яндекс.Директ")
    Translatable submitAnyForm();
}
