package ru.yandex.direct.grid.processing.service.goal

import ru.yandex.direct.grid.model.Order.ASC
import ru.yandex.direct.grid.processing.model.goal.GdGoal
import ru.yandex.direct.grid.processing.model.goal.GdGoalsOrderBy
import ru.yandex.direct.grid.processing.model.goal.GdGoalsOrderByField
import ru.yandex.direct.grid.processing.model.goal.GdGoalsOrderByField.CONVERSION_VISITS_COUNT

object GoalServiceUtils {
    private fun getComparatorByField(field: GdGoalsOrderByField) =
        Comparator.comparing(
            when (field) {
                CONVERSION_VISITS_COUNT -> GdGoal::getConversionVisitsCount
            }
        )

    @JvmStatic
    fun getComparator(orderBy: List<GdGoalsOrderBy>): Comparator<GdGoal> {
        if (orderBy.isEmpty()) {
            return Comparator { _, _ -> 0 }
        }
        return orderBy
            .map {
                val comparator = Comparator.nullsLast(getComparatorByField(it.field))
                if (it.order == ASC) comparator else comparator.reversed()
            }
            .reduce { acc, comparator -> acc.thenComparing(comparator) }
    }
}
