package ru.yandex.direct.grid.processing.service.goal

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.mobileapp.model.MobileGoalConversions
import ru.yandex.direct.core.entity.mobileapp.service.MobileAppConversionStatisticService
import ru.yandex.direct.core.entity.retargeting.model.Goal
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.grid.processing.model.goal.GdMobileGoalConversionsInfo

@Service
class MobileGoalConversionsDataService(
    private val conversionStatisticService: MobileAppConversionStatisticService
) {
    /**
     * Возвращает информацию по наличию конверсий по целям для мобильного приложения.
     *
     * Метод вычисляет результат для всех переданных в goalIds целей мобильных приложений,
     * даже если по ним не найдена статистика. Цели же, которые не признаны "мобильными"
     * не будут присутствовать в результате.
     */
    fun getMobileGoalConversions(
        clientId: ClientId, mobileAppId: Long, goalIds: List<Long>, daysNum: Int
    ): List<GdMobileGoalConversionsInfo> {
        // получаем конверсии только по целям для мобильных приложений
        val mobileGoalIds = goalIds.filter { it in Goal.MOBILE_GOAL_IDS }.distinct()
        if (mobileGoalIds.isEmpty()) {
            return listOf()
        }
        val conversions = conversionStatisticService.getMobileGoalConversions(
            clientId, mobileAppId, mobileGoalIds, daysNum)

        val mobileGoalConversionsMap = conversions.map { it.goalId to it }.toMap()
        return mobileGoalIds.map { goalId -> toConversionsInfo(goalId, mobileGoalConversionsMap[goalId]) }
    }
}

private fun toConversionsInfo(goalId: Long, goalConversions: MobileGoalConversions?): GdMobileGoalConversionsInfo {
    if (goalConversions == null) {
        return GdMobileGoalConversionsInfo()
            .withGoalId(goalId)
            .withAttributed(false)
            .withNotAttributed(false)
    }
    val hasAttributed = goalConversions.attributedConversions > 0
    val hasNotAttributed = goalConversions.notAttributedConversions > 0
    return GdMobileGoalConversionsInfo()
        .withGoalId(goalId)
        .withAttributed(hasAttributed)
        .withNotAttributed(hasNotAttributed)
}
