package ru.yandex.direct.grid.processing.service.group;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupStates;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.grid.core.entity.group.model.GdiCpmVideoGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiCpmYndxFrontpageGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiGroup;
import ru.yandex.direct.grid.model.campaign.GdCampaignStatus;
import ru.yandex.direct.grid.model.campaign.GdCampaignTruncated;
import ru.yandex.direct.grid.model.campaign.GdCampaignType;
import ru.yandex.direct.grid.model.campaign.GdiBaseCampaign;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.group.GdAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupAccess;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupModerationStatus;
import ru.yandex.direct.grid.processing.model.group.GdCpmPriceAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmPriceVideoAdGroup;

import static ru.yandex.direct.core.entity.adgroup.service.AdGroupCpmPriceUtils.isDefaultPriority;
import static ru.yandex.direct.grid.processing.service.campaign.CampaignServiceUtils.isCpmPriceCampaignReadyToStart;
import static ru.yandex.direct.grid.processing.service.group.AvailableAdGroupTypesCalculator.canAcceptModerationAdGroupType;
import static ru.yandex.direct.grid.processing.service.group.AvailableAdGroupTypesCalculator.canBeSentToRemoderationAdGroupType;

/**
 * Класс содержит методы, которые помогают определить
 * удовлетворяет ли группа необходимым условиям для возможности применения операции
 */
@ParametersAreNonnullByDefault
public class AdGroupActionConditionsUtil {

    static boolean canBeSentToRemoderationConditions(GdAdGroupAccess gdAdGroupAccess) {
        return canBeSentToRemoderationAdGroupType(gdAdGroupAccess.getType())
                && isAdGroupNotDraftAndNotArchived(gdAdGroupAccess);
    }

    static boolean isAdGroupNotDraftAndNotArchived(GdAdGroupAccess gdAdGroupAccess) {
        return hasAdsAndNotArchived(gdAdGroupAccess)
                && !isDraft(gdAdGroupAccess);
    }

    static boolean isAdGroupInDraftAndNotArchived(GdAdGroupAccess gdAdGroupAccess) {
        return hasAdsAndNotArchived(gdAdGroupAccess)
                && isDraft(gdAdGroupAccess);
    }

    static boolean canAcceptModerationConditions(GdAdGroupAccess gdAdGroupAccess) {
        return canAcceptModerationAdGroupType(gdAdGroupAccess.getType())
                && hasAdsAndNotArchived(gdAdGroupAccess);
    }

    private static boolean hasAdsAndNotArchived(GdAdGroupAccess gdAdGroupAccess) {
        return hasAds(gdAdGroupAccess) && !gdAdGroupAccess.getStatus().getArchived();
    }

    private static boolean isDraft(GdAdGroupAccess gdAdGroupAccess) {
        return gdAdGroupAccess.getMainAdStatusModerate() == BannerStatusModerate.NEW
                || gdAdGroupAccess.getStatus().getModerationStatus() == GdAdGroupModerationStatus.DRAFT;
    }

    /**
     * Если у группы нет главного объявления, значит группа пустая
     * Если у {@link GdAdGroupAccess} отсутствует статус модерации главного объявления, значит у группы нет главного
     * объявления
     */
    private static boolean hasAds(GdAdGroupAccess gdAdGroupAccess) {
        return gdAdGroupAccess.getMainAdStatusModerate() != null;
    }

    public static boolean canBeSentToModerationByClient(boolean canEditAdGroup, AdGroupStates adGroupStates,
                                                        GdCampaignStatus campaignStatus) {
        return canEditAdGroup && adGroupStates.getHasDraftAds() && !campaignStatus.getDraft();
    }

    public static boolean isCpmPriceDefaultAdGroupReadyToStart(GdAdGroup adGroup, GdiBaseCampaign campaign) {
        return isCpmPriceDefaultAdGroup(adGroup) && isCpmPriceCampaignReadyToStart(campaign);
    }

    public static boolean isCpmPriceDefaultAdGroupReadyToStart(GdiGroup internal, GdiBaseCampaign gdiBaseCampaign) {
        Long priority = getGdiCpmPriceGroupPriority(internal);
        return isCpmPriceCampaignReadyToStart(gdiBaseCampaign) &&
                priority != null &&
                isDefaultPriority(priority);
    }

    public static boolean isCpmPriceDefaultAdGroup(GridGraphQLContext context, Long adGroupId) {
        return isCpmPriceDefaultAdGroup(context.getGdAdGroupsMap().get(adGroupId));
    }

    public static boolean isCpmPriceDefaultAdGroup(GdAdGroup adGroup) {
        return adGroup instanceof GdCpmPriceAdGroup &&
                isDefaultPriority(((GdCpmPriceAdGroup) adGroup).getPriority())
                ||
                adGroup instanceof GdCpmPriceVideoAdGroup &&
                        isDefaultPriority(((GdCpmPriceVideoAdGroup) adGroup).getPriority());
    }

    public static boolean isCpmPriceDefaultAdGroup(GdiGroup internal, GdCampaignTruncated campaign) {
        Long priority = getGdiCpmPriceGroupPriority(internal);
        return campaign.getType() == GdCampaignType.CPM_PRICE &&
                priority != null &&
                isDefaultPriority(priority);
    }

    private static Long getGdiCpmPriceGroupPriority(GdiGroup internal) {
        if (internal instanceof GdiCpmYndxFrontpageGroup) {
            return ((GdiCpmYndxFrontpageGroup) internal).getPriority();
        }
        if (internal instanceof GdiCpmVideoGroup) {
            return ((GdiCpmVideoGroup) internal).getPriority();
        }
        return null;
    }

}
