package ru.yandex.direct.grid.processing.service.group;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.adgroup.container.AdGroupNewMinusKeywords;
import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexContentPromotionAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexCpmAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexDynamicAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexMcBannerAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexMobileContentAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexPerformanceAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupSimple;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.AdShowType;
import ru.yandex.direct.core.entity.adgroup.model.DynamicAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.DynamicFeedAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.DynamicTextAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.McBannerAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.PerformanceAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.TextAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.UsersSegment;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.ModerationMode;
import ru.yandex.direct.core.entity.adgroup.service.UpdateAdGroupMinusKeywordsOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupAddOperationFactory;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupUpdateOperationFactory;
import ru.yandex.direct.core.entity.adgroup.service.complex.cpm.ComplexCpmAdGroupAddOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.cpm.ComplexCpmAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.mcbanner.ComplexMcBannerAdGroupAddOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.performance.ComplexPerformanceAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.AddRetargetingConditionsSubOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.text.ComplexTextAdGroupAddOperation;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdGroupId;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain;
import ru.yandex.direct.core.entity.banner.repository.BannerTypedRepository;
import ru.yandex.direct.core.entity.banner.service.BannerSuspendResumeService;
import ru.yandex.direct.core.entity.banner.service.DatabaseMode;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.client.service.ClientGeoService;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.core.entity.crypta.exception.InvalidCryptaSegmentException;
import ru.yandex.direct.core.entity.crypta.service.CryptaSuggestService;
import ru.yandex.direct.core.entity.currency.service.CpmYndxFrontpageCurrencyService;
import ru.yandex.direct.core.entity.dynamictextadtarget.DynamicTextAdTargetTranslations;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicAdTargetTab;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicFeedAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicFeedRule;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicTextAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRule;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.DynamicTextAdTargetService;
import ru.yandex.direct.core.entity.dynamictextadtarget.utils.DynamicTextAdTargetHashUtils;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.feed.model.BusinessType;
import ru.yandex.direct.core.entity.feed.model.Feed;
import ru.yandex.direct.core.entity.feed.model.FeedType;
import ru.yandex.direct.core.entity.feed.service.FeedService;
import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.core.entity.keyword.service.KeywordService;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseValidator;
import ru.yandex.direct.core.entity.minuskeywordspack.model.MinusKeywordsPack;
import ru.yandex.direct.core.entity.minuskeywordspack.repository.MinusKeywordsPackRepository;
import ru.yandex.direct.core.entity.mobilecontent.repository.MobileContentRepository;
import ru.yandex.direct.core.entity.performancefilter.PerformanceFilterTranslations;
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterStorage;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.Retargeting;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionBase;
import ru.yandex.direct.core.entity.retargeting.model.TargetInterest;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionService;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingService;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionFixedAutoPrices;
import ru.yandex.direct.core.entity.tag.model.Tag;
import ru.yandex.direct.core.entity.tag.repository.TagRepository;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.dbschema.ppc.enums.RetargetingConditionsRetargetingConditionsType;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.model.UidAndClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.grid.processing.model.api.GdValidationResult;
import ru.yandex.direct.grid.processing.model.crypta.GdCryptaGoalsSuggestItem;
import ru.yandex.direct.grid.processing.model.feedfilter.GdFeedFilter;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddAdGroupMinusKeywords;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddAdGroupMinusKeywordsPayload;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddAdGroupPayload;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddAdGroupPayloadItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddAdGroupsMinusKeywords;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddAdGroupsMinusKeywordsPayload;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddContentPromotionAdGroup;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddDynamicAdGroup;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddDynamicAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddMcBannerAdGroup;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddMcBannerAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddMobileContentAdGroup;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddSmartAdGroup;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddSmartAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddTextAdGroup;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddTextAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdCpmGroupType;
import ru.yandex.direct.grid.processing.model.group.mutation.GdRemoveAdGroupsMinusKeywords;
import ru.yandex.direct.grid.processing.model.group.mutation.GdRemoveAdGroupsMinusKeywordsPayload;
import ru.yandex.direct.grid.processing.model.group.mutation.GdRepalceAdGroupMinusKeywords;
import ru.yandex.direct.grid.processing.model.group.mutation.GdReplaceAdGroupMinusKeywordsPayload;
import ru.yandex.direct.grid.processing.model.group.mutation.GdReplaceAdGroupsMinusKeywords;
import ru.yandex.direct.grid.processing.model.group.mutation.GdReplaceAdGroupsMinusKeywordsPayload;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateAdGroupMinusKeywords;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateAdGroupMinusKeywordsPayload;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateAdGroupPayload;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateAdGroupPayloadItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateAdGroupRetargetingItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateContentPromotionAdGroup;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateContentPromotionAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateCpmAdGroup;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateCpmAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateDynamicAdGroup;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateMcBannerAdGroup;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateMcBannerAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateMobileContentAdGroup;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateMobileContentAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdatePerformanceAdGroup;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdatePerformanceAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateTextAdGroup;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateTextAdGroupItem;
import ru.yandex.direct.grid.processing.model.smartfilter.GdSmartFilterTab;
import ru.yandex.direct.grid.processing.model.smartfilter.GdSmartFilterTargetFunnel;
import ru.yandex.direct.grid.processing.model.smartfilter.mutation.GdAddSmartFilters;
import ru.yandex.direct.grid.processing.model.smartfilter.mutation.GdAddSmartFiltersItem;
import ru.yandex.direct.grid.processing.model.smartfilter.mutation.GdAddSmartFiltersPayload;
import ru.yandex.direct.grid.processing.service.adgeneration.AdGenerationLoggingService;
import ru.yandex.direct.grid.processing.service.feedfilter.FeedFilterGdConverter;
import ru.yandex.direct.grid.processing.service.goal.CryptaGoalsConverter;
import ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter;
import ru.yandex.direct.grid.processing.service.group.validation.ContentPromotionAdGroupValidationService;
import ru.yandex.direct.grid.processing.service.group.validation.CpmAdGroupValidationService;
import ru.yandex.direct.grid.processing.service.group.validation.DynamicAdGroupValidationService;
import ru.yandex.direct.grid.processing.service.group.validation.McBannerAdGroupValidationService;
import ru.yandex.direct.grid.processing.service.group.validation.MobileContentAdGroupValidationService;
import ru.yandex.direct.grid.processing.service.group.validation.PerformanceAdGroupValidationService;
import ru.yandex.direct.grid.processing.service.group.validation.TextAdGroupValidationService;
import ru.yandex.direct.grid.processing.service.smartfilter.SmartFilterDataService;
import ru.yandex.direct.grid.processing.service.validation.GridValidationService;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.multitype.entity.LimitOffset;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.result.Result;
import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.ytcore.entity.statistics.service.RecentStatisticsService;

import static java.util.Arrays.asList;
import static java.util.Collections.emptyList;
import static java.util.Collections.emptyMap;
import static java.util.Collections.singleton;
import static java.util.Collections.singletonList;
import static java.util.function.Function.identity;
import static java.util.stream.Collectors.groupingBy;
import static java.util.stream.Collectors.mapping;
import static java.util.stream.Collectors.toList;
import static org.apache.commons.collections4.CollectionUtils.isEmpty;
import static ru.yandex.direct.core.entity.dynamictextadtarget.utils.DynamicTextAdTargetHashUtils.getHashForDynamicFeedRules;
import static ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionShortcutService.RETARGETING_CONDITION_SHORTCUT_DEFAULT_IDS;
import static ru.yandex.direct.core.validation.ValidationUtils.hasValidationIssues;
import static ru.yandex.direct.feature.FeatureName.ENABLED_DYNAMIC_FEED_AD_TARGET_IN_TEXT_AD_GROUP;
import static ru.yandex.direct.grid.processing.service.bidmodifier.BidModifierDataConverter.toComplexBidModifier;
import static ru.yandex.direct.grid.processing.service.group.AdGroupMutationUtils.getAutoPriceParamsForAddContentPromotion;
import static ru.yandex.direct.grid.processing.service.group.AdGroupMutationUtils.getAutoPriceParamsForAddMcBanner;
import static ru.yandex.direct.grid.processing.service.group.AdGroupMutationUtils.getAutoPriceParamsForAddMobileContent;
import static ru.yandex.direct.grid.processing.service.group.AdGroupMutationUtils.getAutoPriceParamsForUpdateContentPromotion;
import static ru.yandex.direct.grid.processing.service.group.AdGroupMutationUtils.getAutoPriceParamsForUpdateMcBanner;
import static ru.yandex.direct.grid.processing.service.group.AdGroupMutationUtils.getAutoPriceParamsForUpdateMobileContent;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.createEmptyGdAddAdGroupPayload;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.createEmptyGdUpdateAdGroupPayload;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.fromUpdateItemToComplexCpmAdGroup;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.getGdAddAdGroupPayloadItems;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.getGdUpdateAdGroupPayloadItems;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.toAddedItems;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.toCaRetargetingCondition;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.toComplexAdGroups;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.toComplexContentPromotionAdGroup;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.toComplexMcBannerAdGroups;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.toComplexMobileContentAdGroups;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.toComplexTextAdGroupForCa;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.toCoreContentCategoriesRetargetingRules;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.toCoreKeywords;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.toCoreOfferRetargetings;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.toCoreRelevanceMatches;
import static ru.yandex.direct.grid.processing.service.group.converter.AdGroupsMutationDataConverter.toRetargetingCondition;
import static ru.yandex.direct.grid.processing.util.ResponseConverter.getResults;
import static ru.yandex.direct.grid.processing.util.ResultConverterHelper.getSuccessfullyUpdatedIds;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.validation.result.PathHelper.emptyPath;
import static ru.yandex.direct.validation.result.PathHelper.field;
import static ru.yandex.direct.validation.result.PathHelper.path;


/**
 * Сервис, для изменений параметров группы объявлений
 */
@Service
@ParametersAreNonnullByDefault
public class AdGroupMutationService {

    static final String PATH_FOR_UPDATE_TEXT_AD_GROUP = "updateAdGroupItems"; // так сделано вместо
    // GdUpdateTextAdGroup.UPDATE_ITEMS в DIRECT-93871 т.к. фронт уже завязался на updateAdGroupItems
    private static final String DEFAULT_FILTERS_NOT_ADDED_RUNTIME_MESSAGE =
            "Failed to add default {} filters to groups with ids: {}. StackTrace: ";
    private static final String DEFAULT_FILTERS_NOT_ADDED_VALIDATION_MESSAGE =
            "Failed to add default {} filters to groups with ids: {}. Validation failed: {}";
    private static final String SMART_NAME = "smart";
    private static final String DYNAMIC_NAME = "dynamic";
    private static final MinusPhraseValidator.ValidationMode MINUS_PHRASE_VALIDATION_MODE =
            MinusPhraseValidator.ValidationMode.ONE_ERROR_PER_TYPE;

    private final Logger logger = LoggerFactory.getLogger(AdGroupMutationService.class);

    private final AdGroupService adGroupService;
    private final KeywordService keywordService;
    private final ClientGeoService clientGeoService;
    private final GridValidationService gridValidationService;
    private final TextAdGroupValidationService textAdGroupValidationService;
    private final CpmAdGroupValidationService cpmAdGroupValidationService;
    private final PerformanceAdGroupValidationService performanceAdGroupValidationService;
    private final McBannerAdGroupValidationService mcBannerAdGroupValidationService;
    private final MobileContentAdGroupValidationService mobileContentAdGroupValidationService;
    private final DynamicAdGroupValidationService dynamicAdGroupValidationService;
    private final ComplexAdGroupAddOperationFactory complexAdGroupAddOperationFactory;
    private final ComplexAdGroupUpdateOperationFactory complexAdGroupUpdateOperationFactory;
    private final RecentStatisticsService recentStatisticsService;
    private final ClientService clientService;
    private final RetargetingService retargetingService;
    private final MinusKeywordsPackRepository packRepository;
    private final ShardHelper shardHelper;
    private final TagRepository tagRepository;
    private final FeatureService featureService;
    private final RetargetingConditionService retargetingConditionService;
    private final ContentPromotionAdGroupValidationService contentPromotionAdGroupValidationService;
    private final CpmYndxFrontpageCurrencyService cpmYndxFrontpageCurrencyService;
    private final TranslationService translationService;
    private final CampaignRepository campaignRepository;
    private final AdGroupRepository adGroupRepository;
    private final BannerTypedRepository bannerTypedRepository;
    private final MobileContentRepository mobileContentRepository;
    private final AdGenerationLoggingService adGenerationLoggingService;
    private final CryptaSuggestService cryptaSuggestService;
    private final RetargetingConditionOperationFactory retargetingConditionOperationFactory;
    private final SmartFilterDataService smartFilterDataService;
    private final DynamicTextAdTargetService dynamicTextAdTargetService;
    private final PerformanceFilterStorage filterSchemaStorage;
    private final FeedService feedService;
    private final BannerSuspendResumeService bannerSuspendResumeService;

    @Autowired
    public AdGroupMutationService(AdGroupService adGroupService,
                                  KeywordService keywordService,
                                  ClientGeoService clientGeoService,
                                  GridValidationService gridValidationService,
                                  TextAdGroupValidationService textAdGroupValidationService,
                                  CpmAdGroupValidationService cpmAdGroupValidationService,
                                  PerformanceAdGroupValidationService performanceAdGroupValidationService,
                                  McBannerAdGroupValidationService mcBannerAdGroupValidationService,
                                  MobileContentAdGroupValidationService mobileContentAdGroupValidationService,
                                  DynamicAdGroupValidationService dynamicAdGroupValidationService,
                                  ComplexAdGroupAddOperationFactory complexAdGroupAddOperationFactory,
                                  ComplexAdGroupUpdateOperationFactory complexAdGroupUpdateOperationFactory,
                                  RecentStatisticsService recentStatisticsService,
                                  ClientService clientService,
                                  RetargetingService retargetingService,
                                  MinusKeywordsPackRepository packRepository,
                                  ShardHelper shardHelper,
                                  TagRepository tagRepository,
                                  FeatureService featureService,
                                  RetargetingConditionService retargetingConditionService,
                                  ContentPromotionAdGroupValidationService contentPromotionAdGroupValidationService,
                                  CpmYndxFrontpageCurrencyService cpmYndxFrontpageCurrencyService,
                                  CampaignRepository campaignRepository,
                                  MobileContentRepository mobileContentRepository,
                                  AdGroupRepository adGroupRepository,
                                  BannerTypedRepository bannerTypedRepository,
                                  TranslationService translationService,
                                  AdGenerationLoggingService adGenerationLoggingService,
                                  CryptaSuggestService cryptaSuggestService,
                                  RetargetingConditionOperationFactory retargetingConditionOperationFactory,
                                  SmartFilterDataService smartFilterDataService,
                                  DynamicTextAdTargetService dynamicTextAdTargetService,
                                  PerformanceFilterStorage filterSchemaStorage,
                                  FeedService feedService,
                                  BannerSuspendResumeService bannerSuspendResumeService) {
        this.adGroupService = adGroupService;
        this.keywordService = keywordService;
        this.clientGeoService = clientGeoService;
        this.gridValidationService = gridValidationService;
        this.textAdGroupValidationService = textAdGroupValidationService;
        this.cpmAdGroupValidationService = cpmAdGroupValidationService;
        this.performanceAdGroupValidationService = performanceAdGroupValidationService;
        this.mcBannerAdGroupValidationService = mcBannerAdGroupValidationService;
        this.mobileContentAdGroupValidationService = mobileContentAdGroupValidationService;
        this.dynamicAdGroupValidationService = dynamicAdGroupValidationService;
        this.complexAdGroupAddOperationFactory = complexAdGroupAddOperationFactory;
        this.complexAdGroupUpdateOperationFactory = complexAdGroupUpdateOperationFactory;
        this.recentStatisticsService = recentStatisticsService;
        this.clientService = clientService;
        this.retargetingService = retargetingService;
        this.packRepository = packRepository;
        this.shardHelper = shardHelper;
        this.tagRepository = tagRepository;
        this.featureService = featureService;
        this.retargetingConditionService = retargetingConditionService;
        this.contentPromotionAdGroupValidationService = contentPromotionAdGroupValidationService;
        this.cpmYndxFrontpageCurrencyService = cpmYndxFrontpageCurrencyService;
        this.campaignRepository = campaignRepository;
        this.adGroupRepository = adGroupRepository;
        this.bannerTypedRepository = bannerTypedRepository;
        this.mobileContentRepository = mobileContentRepository;
        this.translationService = translationService;
        this.adGenerationLoggingService = adGenerationLoggingService;
        this.cryptaSuggestService = cryptaSuggestService;
        this.retargetingConditionOperationFactory = retargetingConditionOperationFactory;
        this.smartFilterDataService = smartFilterDataService;
        this.dynamicTextAdTargetService = dynamicTextAdTargetService;
        this.filterSchemaStorage = filterSchemaStorage;
        this.feedService = feedService;
        this.bannerSuspendResumeService = bannerSuspendResumeService;
    }

    GdAddAdGroupsMinusKeywordsPayload massAddMinusKeywords(GdAddAdGroupsMinusKeywords request, Long operatorUid,
                                                           ClientId clientId) {
        gridValidationService.validateAddAdGroupsMinusKeywordsRequest(request);

        List<AdGroupNewMinusKeywords> adGroupsNewMinusKeywordsList = new ArrayList<>();
        request.getAdGroupIds().forEach((id) ->
                adGroupsNewMinusKeywordsList.add(new AdGroupNewMinusKeywords(id, request.getMinusKeywords())));

        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);
        UpdateAdGroupMinusKeywordsOperation operation = adGroupService
                .createAppendMinusKeywordsOperation(Applicability.PARTIAL, adGroupsNewMinusKeywordsList, geoTree,
                        operatorUid, clientId);
        MassResult<Long> result = operation.prepareAndApply();

        GdValidationResult validationResult =
                gridValidationService.getValidationResult(result, path(field(GdAddAdGroupsMinusKeywords.AD_GROUP_IDS)));
        return new GdAddAdGroupsMinusKeywordsPayload()
                .withAddedAdGroupIds(mapList(operation.getValidElementIndexes(), request.getAdGroupIds()::get))
                .withValidationResult(validationResult);
    }

    GdRemoveAdGroupsMinusKeywordsPayload massRemoveMinusKeywords(GdRemoveAdGroupsMinusKeywords request,
                                                                 Long operatorUid,
                                                                 ClientId clientId) {
        gridValidationService.validateRemoveAdGroupsMinusKeywordsRequest(request);

        List<AdGroupNewMinusKeywords> adGroupsNewMinusKeywordsList = new ArrayList<>();
        request.getAdGroupIds().forEach((id) ->
                adGroupsNewMinusKeywordsList.add(new AdGroupNewMinusKeywords(id, request.getMinusKeywords())));

        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);
        UpdateAdGroupMinusKeywordsOperation operation = adGroupService
                .createRemoveMinusKeywordsOperation(Applicability.PARTIAL, adGroupsNewMinusKeywordsList, geoTree,
                        operatorUid, clientId);
        MassResult<Long> result = operation.prepareAndApply();

        GdValidationResult validationResult =
                gridValidationService.getValidationResult(result, path(field(GdAddAdGroupsMinusKeywords.AD_GROUP_IDS)));
        return new GdRemoveAdGroupsMinusKeywordsPayload()
                .withRemovedAdGroupIds(mapList(operation.getValidElementIndexes(), request.getAdGroupIds()::get))
                .withValidationResult(validationResult);
    }

    GdReplaceAdGroupsMinusKeywordsPayload massReplaceMinusKeywords(GdReplaceAdGroupsMinusKeywords request,
                                                                   Long operatorUid,
                                                                   ClientId clientId) {
        gridValidationService.validateReplaceAdGroupsMinusKeywordsRequest(request);

        List<AdGroupNewMinusKeywords> adGroupsNewMinusKeywordsList = new ArrayList<>();
        request.getAdGroupIds().forEach((id) ->
                adGroupsNewMinusKeywordsList.add(new AdGroupNewMinusKeywords(id, request.getMinusKeywords())));

        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);
        UpdateAdGroupMinusKeywordsOperation operation = adGroupService
                .createReplaceMinusKeywordsOperation(Applicability.PARTIAL, adGroupsNewMinusKeywordsList, geoTree,
                        operatorUid, clientId);
        MassResult<Long> result = operation.prepareAndApply();

        GdValidationResult validationResult =
                gridValidationService.getValidationResult(result, path(field(GdAddAdGroupsMinusKeywords.AD_GROUP_IDS)));
        return new GdReplaceAdGroupsMinusKeywordsPayload()
                .withReplacedAdGroupIds(mapList(operation.getValidElementIndexes(), request.getAdGroupIds()::get))
                .withValidationResult(validationResult);
    }

    GdAddAdGroupMinusKeywordsPayload addMinusKeywords(GdAddAdGroupMinusKeywords request, Long operatorUid,
                                                      ClientId clientId) {
        gridValidationService.validateAddAdGroupMinusKeywordsRequest(request);

        List<AdGroupNewMinusKeywords> adGroupNewMinusKeywordsList =
                mapList(request.getAddItems(),
                        addItem -> new AdGroupNewMinusKeywords(addItem.getAdGroupId(), addItem.getMinusKeywords()));
        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);
        UpdateAdGroupMinusKeywordsOperation operation = adGroupService
                .createAppendMinusKeywordsOperation(Applicability.PARTIAL, adGroupNewMinusKeywordsList, geoTree,
                        operatorUid, clientId
                );
        MassResult<Long> result = operation.prepareAndApply();

        GdValidationResult validationResult =
                gridValidationService.getValidationResult(result, path(field(GdAddAdGroupMinusKeywords.ADD_ITEMS)));
        return new GdAddAdGroupMinusKeywordsPayload()
                .withAddedItems(toAddedItems(operation.getNormalMinusKeywords()))
                .withValidationResult(validationResult);
    }

    void fillDynamicAdTargets(Map<Boolean, List<Long>> adGroupIdsWithFeedPartition, ClientId clientId,
                              Long operatorUid) {
        // Добавляем дефолтные динамические фильтры для фидов
        List<Long> feedAdGroupIds = adGroupIdsWithFeedPartition.get(true);
        try {
            List<DynamicFeedAdTarget> defaultFeedDynamicFilters =
                    mapList(feedAdGroupIds, id -> createDefaultFeedDynamicFilter(id,
                            feedService.getFeedByDynamicAdGroupId(clientId, feedAdGroupIds)));
            MassResult<Long> feedDefaultFiltersResult = dynamicTextAdTargetService.addDynamicFeedAdTargets(clientId,
                    operatorUid, defaultFeedDynamicFilters);

            ValidationResult feedValidationResult = feedDefaultFiltersResult.getValidationResult();

            if (hasValidationIssues(feedValidationResult)) {
                logValidationError(DYNAMIC_NAME, feedAdGroupIds, JsonUtils.toJson(feedValidationResult));
            }
        } catch (RuntimeException e) {
            logRuntimeError(DYNAMIC_NAME, feedAdGroupIds, e);
        }

        // Добавляем дефолтные динамические фильтры для сайтов
        List<Long> webpageAdGroupIds = adGroupIdsWithFeedPartition.get(false);
        try {
            List<DynamicTextAdTarget> defaultWebpageDynamicFilters =
                    mapList(webpageAdGroupIds, this::createDefaultWebpageDynamicFilter);
            MassResult<Long> webpageDefaultFiltersResult = dynamicTextAdTargetService.addDynamicTextAdTargets(clientId,
                    operatorUid, defaultWebpageDynamicFilters);

            ValidationResult webpageValidationResult = webpageDefaultFiltersResult.getValidationResult();

            if (hasValidationIssues(webpageValidationResult)) {
                logValidationError(DYNAMIC_NAME, webpageAdGroupIds, JsonUtils.toJson(webpageValidationResult));
            }
        } catch (RuntimeException e) {
            logRuntimeError(DYNAMIC_NAME, webpageAdGroupIds, e);
        }
    }

    /**
     * Создание групп ТГО
     */
    GdAddAdGroupPayload addTextAdGroups(ClientId clientId, Long operatorUid, Long clientUid, GdAddTextAdGroup input) {
        if (isEmpty(input.getAddItems())) {
            return createEmptyGdAddAdGroupPayload();
        }

        input.setAddItems(mapList(input.getAddItems(), item -> item.withFeedId(null).withFeedFilterCategories(null)));

        textAdGroupValidationService.validateCreateTextAdGroups(clientId, input);
        textAdGroupValidationService.additionalValidationOfAddAdGroup(clientId, input);

        List<ComplexTextAdGroup> complexAdGroups = toCoreTextGroup(input.getAddItems(), clientId);

        fillSmartFeedFilters(clientId, complexAdGroups,
                mapList(input.getAddItems(), GdAddTextAdGroupItem::getSmartFeedFilter));

        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);

        ShowConditionAutoPriceParams showConditionAutoPriceParams = getAutoPriceParamsForAdd(input.getAddItems());

        List<TargetInterest> targetInterests = StreamEx.of(complexAdGroups)
                .map(ComplexTextAdGroup::getTargetInterests)
                .nonNull()
                .flatMap(Collection::stream)
                .toList();
        int shard = shardHelper.getShardByClientId(clientId);
        updateDefaultRetargetingConditionShortcutIds(shard, clientId, targetInterests, true);

        boolean saveDraft = nvl(input.getSaveDraft(), false);
        ComplexTextAdGroupAddOperation addOperation = complexAdGroupAddOperationFactory
                .createTextAdGroupAddOperation(saveDraft, complexAdGroups, geoTree, true,
                        showConditionAutoPriceParams, operatorUid, clientId, clientUid, DatabaseMode.ONLY_MYSQL);
        MassResult<Long> result = addOperation.prepareAndApply();

        boolean dynamicFeedAdTargetsEnabled =
                featureService.isEnabledForClientId(clientId, ENABLED_DYNAMIC_FEED_AD_TARGET_IN_TEXT_AD_GROUP);
        if (dynamicFeedAdTargetsEnabled) {
            Map<Boolean, List<Long>> adGroupIdsPartition = EntryStream.zip(result.getResult(), input.getAddItems())
                    .filterKeys(r -> r.isSuccessful() && r.getResult() != null)
                    .filterValues(item -> {
                        var dynamicFeedAdTarget = item.getDynamicFeedAdTarget();
                        return dynamicFeedAdTarget != null && dynamicFeedAdTarget.getIsActive();
                    })
                    .mapKeys(Result::getResult)
                    .collect(Collectors.partitioningBy(entry -> entry.getValue().getSmartFeedId() != null,
                            Collectors.mapping(Map.Entry::getKey, Collectors.toList())));

            fillDynamicAdTargets(adGroupIdsPartition, clientId, operatorUid);
        }

        adGenerationLoggingService.logGroupKeywords(operatorUid, clientId, complexAdGroups, result);

        GdValidationResult validationResult = textAdGroupValidationService
                .getValidationResult(result.getValidationResult(), path(field(GdAddTextAdGroup.ADD_ITEMS)));

        List<GdAddAdGroupPayloadItem> successfullyAddedAdGroups = getGdAddAdGroupPayloadItems(result);

        return new GdAddAdGroupPayload()
                .withAddedAdGroupItems(successfullyAddedAdGroups)
                .withValidationResult(validationResult);
    }

    /**
     * Обновление групп ТГО
     *
     * @param uidAndClientId Пара Uid + ClientId клиента
     * @param operatorUid    идентификатор пользователя оператора
     * @param input          запрос на редактирование группы
     */
    GdUpdateAdGroupPayload updateTextAdGroup(UidAndClientId uidAndClientId, Long operatorUid,
                                             GdUpdateTextAdGroup input) {
        if (isEmpty(input.getUpdateItems())) {
            return createEmptyGdUpdateAdGroupPayload();
        }

        ClientId clientId = uidAndClientId.getClientId();
        textAdGroupValidationService.validateUpdateRequest(input, clientId);

        var isCaEnabled = featureService.isEnabledForClientId(clientId, FeatureName.CUSTOM_AUDIENCE_ENABLED);
        Set<ModelProperty> propertiesToUpdate = detectPropertiesToUpdate(input, isCaEnabled);

        List<Long> adGroupIds = mapList(input.getUpdateItems(), GdUpdateTextAdGroupItem::getAdGroupId);
        Map<Long, AdGroupType> adGroupTypes = adGroupService.getAdGroupTypes(clientId, adGroupIds);

        textAdGroupValidationService.additionalValidationOfUpdateAdGroup(clientId, adGroupTypes, input);

        //страхуемся на случай, если во фронте не заполнят keywordId.
        Map<Long, List<Keyword>> keywordsByAdGroupIds = keywordService.getKeywordsByAdGroupIds(clientId, adGroupIds);

        int shard = shardHelper.getShardByClientId(clientId);
        Map<Long, List<TargetInterest>> interestsByAdGroupId = getInterests(clientId, shard, adGroupIds);

        Map<Long, RetargetingCondition> interestsConditions =
                listToMap(retargetingConditionService.getRetargetingConditions(clientId, null, adGroupIds, null,
                        singleton(RetargetingConditionsRetargetingConditionsType.interests),
                        LimitOffset.limited(adGroupIds.size())), RetargetingCondition::getId);

        List<ComplexTextAdGroup> complexAdGroups;
        if (isCaEnabled) {
            complexAdGroups = StreamEx.of(input.getUpdateItems())
                    .mapToEntry(GdUpdateTextAdGroupItem::getAdGroupId, identity())
                    .mapKeyValue((id, item) -> getComplexTextAdGroupWithCa(
                            clientId, adGroupTypes.get(id), keywordsByAdGroupIds.get(id),
                            interestsByAdGroupId.get(id), interestsConditions.keySet(), item
                    )).toList();
        } else {
            complexAdGroups = toComplexAdGroups(input.getUpdateItems(), keywordsByAdGroupIds, adGroupTypes,
                    interestsByAdGroupId, interestsConditions, clientId, translationService, featureService);
        }

        fillSmartFeedFilters(clientId, complexAdGroups,
                mapList(input.getUpdateItems(), GdUpdateTextAdGroupItem::getSmartFeedFilter));

        fillAdGroupsTags(shard, complexAdGroups);

        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);

        ShowConditionAutoPriceParams showConditionAutoPriceParams = getAutoPriceParams(input.getUpdateItems());

        List<TargetInterest> targetInterests = StreamEx.of(complexAdGroups)
                .map(ComplexTextAdGroup::getTargetInterests)
                .nonNull()
                .flatMap(Collection::stream)
                .toList();
        updateDefaultRetargetingConditionShortcutIds(shard, clientId, targetInterests, false);

        boolean saveDraft = nvl(input.getSaveDraft(), false);
        MassResult<Long> result =
                complexAdGroupUpdateOperationFactory
                        .createRestrictedTextAdGroupUpdateOperation(complexAdGroups, geoTree, true,
                                showConditionAutoPriceParams, operatorUid, clientId, uidAndClientId.getUid(),
                                saveDraft, propertiesToUpdate)
                        .prepareAndApply();

        adGenerationLoggingService.logGroupKeywords(operatorUid, clientId, complexAdGroups, result);

        GdValidationResult validationResult = textAdGroupValidationService.getValidationResult(
                result.getValidationResult(), path(field(PATH_FOR_UPDATE_TEXT_AD_GROUP)));

        return new GdUpdateAdGroupPayload()
                .withUpdatedAdGroupItems(getGdUpdateAdGroupPayloadItems(result))
                .withValidationResult(validationResult);
    }

    private ComplexTextAdGroup getComplexTextAdGroupWithCa(ClientId clientId,
                                                           AdGroupType adGroupType,
                                                           List<Keyword> keywords,
                                                           List<TargetInterest> interests,
                                                           Set<Long> interestsConditionIds,
                                                           GdUpdateTextAdGroupItem item) {
        var rcGoalsResult = getRetargetingGoalsForCa(item.getCaRetargetingCondition());
        boolean isSearchRetargetingEnabled = featureService
                .isEnabledForClientId(clientId, FeatureName.SEARCH_RETARGETING_ENABLED);

        return toComplexTextAdGroupForCa(item, keywords, adGroupType,
                interests,
                clientId, interestsConditionIds, translationService, isSearchRetargetingEnabled,
                rcGoalsResult);
    }

    /**
     * Поддержка совместимости с фронтом.
     * Проверяет, заполнены ли фронтом nullable поля в запросе обновления группы.
     * Если поля заполнены, включаем их обновление в комплексной операции
     * Делаем проверку по первому заполненному полю, т.к. есть соответствующая валидация.
     *
     * @param input запрос на обновление группы
     * @return набор пропертей которые нужно обновлять в комплексной операции
     */
    private Set<ModelProperty> detectPropertiesToUpdate(GdUpdateTextAdGroup input, boolean isCaEnabled) {
        Set<ModelProperty> propertiesToUpdate = new HashSet<>();

        StreamEx.of(input.getUpdateItems())
                .findFirst(item -> item.getKeywords() != null)
                .ifPresent((item) -> propertiesToUpdate.add(ComplexTextAdGroup.KEYWORDS));

        StreamEx.of(input.getUpdateItems())
                .findFirst(item -> item.getRelevanceMatch() != null)
                .ifPresent((item) -> propertiesToUpdate.add(ComplexTextAdGroup.RELEVANCE_MATCHES));

        StreamEx.of(input.getUpdateItems())
                .findFirst(item -> item.getOfferRetargeting() != null)
                .ifPresent((item) -> propertiesToUpdate.add(ComplexTextAdGroup.OFFER_RETARGETINGS));

        StreamEx.of(input.getUpdateItems())
                .findFirst(item -> item.getRetargetings() != null)
                .ifPresent((item) -> propertiesToUpdate.add(ComplexTextAdGroup.TARGET_INTERESTS));

        StreamEx.of(input.getUpdateItems())
                .findFirst(item -> isCaEnabled
                        ? item.getCaRetargetingCondition() != null
                        : item.getRetargetingCondition() != null)
                .ifPresent((item) -> propertiesToUpdate.addAll(asList(ComplexTextAdGroup.RETARGETING_CONDITION,
                        ComplexTextAdGroup.TARGET_INTERESTS)));

        StreamEx.of(input.getUpdateItems())
                .map(GdUpdateTextAdGroupItem::getUseBidModifiers)
                .nonNull()
                .findAny(useBidModifiers -> useBidModifiers)
                .ifPresent((item) -> propertiesToUpdate.add(ComplexTextAdGroup.COMPLEX_BID_MODIFIER));

        return propertiesToUpdate;
    }

    /**
     * Параметры для установки ставки на группу
     *
     * @param updateAdGroupItems обновляемые группы
     */
    private ShowConditionAutoPriceParams getAutoPriceParams(List<GdUpdateTextAdGroupItem> updateAdGroupItems) {

        ShowConditionFixedAutoPrices fixedAutoPrices = ShowConditionFixedAutoPrices.ofPerAdGroupFixedPrices(
                StreamEx.of(updateAdGroupItems)
                        .mapToEntry(GdUpdateTextAdGroupItem::getAdGroupId, GdUpdateTextAdGroupItem::getGeneralPrice)
                        .nonNullValues()
                        .toMap());

        return new ShowConditionAutoPriceParams(fixedAutoPrices, recentStatisticsService);
    }

    /**
     * Получение параметров для автоматического выставления недостающих ставок.
     * <p>
     * Если в добавляемой группе есть параметр {@code generalPrice},
     * то указываем, что эту ставку нужно выставить всем условиям показов.
     * <p>
     * Тут ожидается, что добавлять можно только одну группу за запрос, т.к.
     * иначе механизм выставления фиксированных автоставок нужно переделать.
     * Поэтому этот механизм не используется при копировании групп,
     * так как за раз можно копировать несколько групп.
     */
    private ShowConditionAutoPriceParams getAutoPriceParamsForAdd(List<GdAddTextAdGroupItem> adGroups) {
        ShowConditionFixedAutoPrices fixedAdGroupAutoPrices =
                ShowConditionFixedAutoPrices.ofGlobalFixedPrice(adGroups.get(0).getGeneralPrice());
        return new ShowConditionAutoPriceParams(fixedAdGroupAutoPrices, recentStatisticsService);
    }

    /**
     * Параметры для установки ставки на охватные группы при добавлении
     *
     * @param updateCpmAdGroupItems обновляемые группы
     * @param clientCurrency        валюта клиента
     */
    private ShowConditionAutoPriceParams getAutoPriceParamsForCpmGroupsToAdd(
            List<GdUpdateCpmAdGroupItem> updateCpmAdGroupItems, Currency clientCurrency,
            Supplier<BigDecimal> cpmYndxFrontpageMinPrice) {
        // .get(0) потому-что подогнали под фронт он пишет в первый элемент generalPrice всегда,
        // + сейчас на фронте добавление всегда происходит по одному, массовых добавлений нет
        // в идеале generalPrice должен быть видимо не в GdUpdateCpmAdGroupItem, а в GdUpdateCpmAdGroup
        ShowConditionFixedAutoPrices fixedAdGroupAutoPrices = ShowConditionFixedAutoPrices
                .ofGlobalFixedPrice(nvl(updateCpmAdGroupItems.get(0).getGeneralPrice(),
                        calcCpmDefaultPrice(updateCpmAdGroupItems.get(0), clientCurrency, cpmYndxFrontpageMinPrice)));

        return new ShowConditionAutoPriceParams(fixedAdGroupAutoPrices, recentStatisticsService);
    }

    /**
     * Параметры для установки ставки на охватные группы при обновлении
     *
     * @param updateCpmAdGroupItems обновляемые группы
     * @param clientCurrency        валюта клиента
     */
    private ShowConditionAutoPriceParams getAutoPriceParamsForCpmGroupsToUpdate(
            List<GdUpdateCpmAdGroupItem> updateCpmAdGroupItems, Currency clientCurrency,
            Map<Long, BigDecimal> frontpageAutoPriceByAdGroupId) {

        ShowConditionFixedAutoPrices fixedAutoPrices = ShowConditionFixedAutoPrices.ofPerAdGroupFixedPrices(
                StreamEx.of(updateCpmAdGroupItems)
                        .mapToEntry(GdUpdateCpmAdGroupItem::getAdGroupId,
                                gdUpdateCpmAdGroupItem -> nvl(gdUpdateCpmAdGroupItem.getGeneralPrice(),
                                        calcCpmDefaultPrice(gdUpdateCpmAdGroupItem, clientCurrency,
                                                () -> frontpageAutoPriceByAdGroupId
                                                        .get(gdUpdateCpmAdGroupItem.getAdGroupId()))))
                        .nonNullKeys()
                        .toMap());

        return new ShowConditionAutoPriceParams(fixedAutoPrices, recentStatisticsService);
    }

    /**
     * Подсчёт дефолтной ставки для cpm-группы
     *
     * @param item           обновляемая группа
     * @param clientCurrency валюта клиента
     */
    private BigDecimal calcCpmDefaultPrice(GdUpdateCpmAdGroupItem item, Currency clientCurrency,
                                           Supplier<BigDecimal> cpmYndxFrontpageMinPrice) {
        if (item.getType() == GdCpmGroupType.CPM_YNDX_FRONTPAGE) {
            return cpmYndxFrontpageMinPrice.get();
        }
        return clientCurrency.getMinCpmPrice();
    }

    /**
     * Создание перформанс-групп объявлений
     */
    GdAddAdGroupPayload addPerformanceAdGroups(ClientId clientId, Long operatorUid, GdAddSmartAdGroup input) {
        if (isEmpty(input.getAddItems())) {
            return createEmptyGdAddAdGroupPayload();
        }

        //Валидируем и сохраняем группы
        performanceAdGroupValidationService.validateAddPerformanceAdGroups(input);
        List<AdGroup> adGroups = toCoreSmartGroup(clientId, input.getAddItems());
        MassResult<Long> result =
                adGroupService.addAdGroupsPartial(adGroups, MINUS_PHRASE_VALIDATION_MODE, operatorUid, clientId);

        GdValidationResult validationResult = performanceAdGroupValidationService
                .getValidationResult(result.getValidationResult(), path(field(GdAddSmartAdGroup.ADD_ITEMS)));

        List<GdAddAdGroupPayloadItem> successfullyAddedAdGroups =
                getResults(result, id -> new GdAddAdGroupPayloadItem().withAdGroupId(id));

        List<Long> addedAdGroupIds = successfullyAddedAdGroups.stream()
                .filter(Objects::nonNull)
                .map(GdAddAdGroupPayloadItem::getAdGroupId)
                .collect(toList());

        //Добавляем дефолтные смарт-фильтры
        try {
            GdAddSmartFilters defaultSmartFilters = new GdAddSmartFilters().withAddItems(
                    mapList(addedAdGroupIds, this::createDefaultSmartFilter)
            );
            GdAddSmartFiltersPayload addSmartFiltersPayload = smartFilterDataService
                    .addSmartFilters(clientId, operatorUid, defaultSmartFilters);

            GdValidationResult filtersValidationResult = addSmartFiltersPayload.getValidationResult();

            if (filtersValidationResult != null) {
                logValidationError(SMART_NAME, addedAdGroupIds, JsonUtils.toJson(filtersValidationResult));
            }
        } catch (RuntimeException e) {
            logRuntimeError(SMART_NAME, addedAdGroupIds, e);
        }

        return new GdAddAdGroupPayload()
                .withAddedAdGroupItems(successfullyAddedAdGroups)
                .withValidationResult(validationResult);
    }

    private List<ComplexTextAdGroup> toCoreTextGroup(List<GdAddTextAdGroupItem> items, ClientId clientId) {
        var isCAEnabled = featureService.isEnabledForClientId(clientId, FeatureName.CUSTOM_AUDIENCE_ENABLED);

        return EntryStream.of(items).mapKeyValue((index, gdAddTextAdGroupItem) ->
        {
            var complexTextAdGroup = new ComplexTextAdGroup();
            List<TargetInterest> targetInterestsToUpdate = mapList(gdAddTextAdGroupItem.getRetargetings(),
                    r -> toTargetInterest(gdAddTextAdGroupItem.getCampaignId(), r));

            var retargetingCondition = isCAEnabled
                    ? getRetargetingConditionForCa(clientId, gdAddTextAdGroupItem)
                    : getRetargetingCondition(clientId, gdAddTextAdGroupItem);
            if (retargetingCondition != null) {
                complexTextAdGroup
                        .withRetargetingCondition(retargetingCondition);
                if (CollectionUtils.isEmpty(targetInterestsToUpdate)) {
                    targetInterestsToUpdate = singletonList(retargetingCondition.getTargetInterest());
                } else {
                    targetInterestsToUpdate.add(retargetingCondition.getTargetInterest());
                }
            }

            return complexTextAdGroup
                    .withAdGroup(toTextAdGroup(gdAddTextAdGroupItem))
                    .withKeywords(gdAddTextAdGroupItem.getKeywords() != null
                            ? toCoreKeywords(gdAddTextAdGroupItem.getKeywords(), null)
                            : null)
                    .withRelevanceMatches(gdAddTextAdGroupItem.getRelevanceMatch() != null
                            ? toCoreRelevanceMatches(gdAddTextAdGroupItem.getRelevanceMatch())
                            : null)
                    .withOfferRetargetings(gdAddTextAdGroupItem.getOfferRetargeting() != null
                            ? toCoreOfferRetargetings(gdAddTextAdGroupItem.getOfferRetargeting())
                            : null)
                    .withComplexBidModifier(
                            featureService.isEnabledForClientId(clientId, FeatureName.SEARCH_RETARGETING_ENABLED)
                                    ? toComplexBidModifier(
                                    gdAddTextAdGroupItem.getSearchRetargetings(),
                                    gdAddTextAdGroupItem.getBidModifiers(),
                                    gdAddTextAdGroupItem.getCampaignId(), null
                            ) : toComplexBidModifier(gdAddTextAdGroupItem.getBidModifiers()))
                    .withTargetInterests(targetInterestsToUpdate);
        }).toList();
    }

    /**
     * Заполняет в группах поле feedFilter, смотря только на feedId (у группы своего id может еще не быть)
     */
    private void fillSmartFeedFilters(ClientId clientId, List<ComplexTextAdGroup> complexTextAdGroups,
                                      List<GdFeedFilter> gdFilters) {
        if (complexTextAdGroups.size() != gdFilters.size()) {
            throw new IllegalArgumentException("input lists should be of same size");
        }

        var textAdGroups = mapList(complexTextAdGroups, complexAdGroup -> (TextAdGroup) complexAdGroup.getAdGroup());

        var adGroupsWithFeedAndFilterIndices =
                IntStreamEx.ofIndices(complexTextAdGroups)
                        .filter(i -> textAdGroups.get(i).getFeedId() != null && gdFilters.get(i) != null)
                        .toArray();
        if (adGroupsWithFeedAndFilterIndices.length == 0) {
            return;
        }

        var feeds = feedService.getFeeds(clientId,
                IntStreamEx.of(adGroupsWithFeedAndFilterIndices)
                        .mapToObj(i -> textAdGroups.get(i).getFeedId())
                        .toList());

        var filterSchemaByFeedId = StreamEx.of(feeds)
                .mapToEntry(Feed::getId, feed -> filterSchemaStorage.getFilterSchema(
                        feed.getBusinessType(), feed.getFeedType(), feed.getSource()))
                .toMap();

        for (int i : adGroupsWithFeedAndFilterIndices) {
            var adGroup = textAdGroups.get(i);
            var filterSchema = filterSchemaByFeedId.get(adGroup.getFeedId());
            if (filterSchema == null) {
                continue;
            }
            adGroup.setFeedFilter(FeedFilterGdConverter.fromGdFeedFilter(gdFilters.get(i), filterSchema));
        }
    }

    @Nullable
    private RetargetingCondition getRetargetingCondition(ClientId clientId, GdAddTextAdGroupItem gdAddTextAdGroupItem) {
        if (!hasRetargetingCondition(gdAddTextAdGroupItem)) {
            return null;
        }

        TargetInterest targetInterestWithInterestsCondition = new TargetInterest()
                .withAdGroupId(0L);

        return toRetargetingCondition(
                clientId,
                targetInterestWithInterestsCondition,
                gdAddTextAdGroupItem.getRetargetingCondition(),
                true,
                translationService
        );
    }

    @Nullable
    private RetargetingCondition getRetargetingConditionForCa(ClientId clientId,
                                                              GdAddTextAdGroupItem gdAddTextAdGroupItem) {
        if (!hasCaRetargetingCondition(gdAddTextAdGroupItem)) {
            return null;
        }

        TargetInterest targetInterestWithInterestsCondition = new TargetInterest()
                .withAdGroupId(0L);

        var rcGoalsResult = getRetargetingGoalsForCa(gdAddTextAdGroupItem.getCaRetargetingCondition());

        return toCaRetargetingCondition(
                clientId, targetInterestWithInterestsCondition, rcGoalsResult, translationService
        );
    }

    private List<Goal> getRetargetingGoalsForCa(List<GdCryptaGoalsSuggestItem> suggestGoals) {
        var cryptaSuggestedGoals = mapList(suggestGoals, CryptaGoalsConverter::toCryptaGoalsSuggestItem);
        List<Goal> result = List.of();
        try {
            result = cryptaSuggestService.getRetargetingGoals(cryptaSuggestedGoals);
        } catch (InvalidCryptaSegmentException e) {
            gridValidationService.throwGridValidationExceptionIfHasErrors(
                    ValidationResult.failed(suggestGoals, CommonDefects.inconsistentState())
            );
        }
        return result;
    }

    private boolean hasRetargetingCondition(GdAddTextAdGroupItem item) {
        return item.getRetargetingCondition() != null
                && !CollectionUtils.isEmpty(item.getRetargetingCondition().getConditionRules());
    }

    private boolean hasCaRetargetingCondition(GdAddTextAdGroupItem item) {
        return !CollectionUtils.isEmpty(item.getCaRetargetingCondition());
    }

    private static TargetInterest toTargetInterest(Long campaignId,
                                                   GdUpdateAdGroupRetargetingItem adGroupRetargetingItem) {
        return new TargetInterest()
                .withCampaignId(campaignId)
                .withId(adGroupRetargetingItem.getId())
                .withRetargetingConditionId(adGroupRetargetingItem.getRetCondId());
    }

    private static TextAdGroup toTextAdGroup(GdAddTextAdGroupItem adGroupAddItem) {
        return new TextAdGroup()
                .withCampaignId(adGroupAddItem.getCampaignId())
                .withName(adGroupAddItem.getName())
                .withMinusKeywords(adGroupAddItem.getAdGroupMinusKeywords())
                .withLibraryMinusKeywordsIds(adGroupAddItem.getLibraryMinusKeywordsIds())
                .withGeo(mapList(adGroupAddItem.getRegionIds(), Integer::longValue))
                .withHyperGeoId(adGroupAddItem.getHyperGeoId())
                .withType(AdGroupType.BASE)
                .withPageGroupTags(adGroupAddItem.getPageGroupTags())
                .withTargetTags(adGroupAddItem.getTargetTags())
                .withContentCategoriesRetargetingConditionRules(
                        toCoreContentCategoriesRetargetingRules(
                                adGroupAddItem.getContentCategoriesRetargetingConditionRules()))
                .withFeedId(adGroupAddItem.getSmartFeedId())
                .withUsersSegments(Boolean.TRUE.equals(adGroupAddItem.getCollectAudience()) ?
                        List.of(new UsersSegment().withType(AdShowType.START)) : emptyList());
    }

    private List<AdGroup> toCoreSmartGroup(ClientId clientId, List<GdAddSmartAdGroupItem> items) {
        Set<Long> campaignIds = listToSet(items, GdAddAdGroupItem::getCampaignId);
        Map<Long, List<Long>> geoByCampaignId = adGroupService.getDefaultGeoByCampaignId(clientId, campaignIds);

        return mapList(items, gdAddSmartAdGroupItem ->
        {
            Long campaignId = gdAddSmartAdGroupItem.getCampaignId();
            List<Long> geo = geoByCampaignId.get(campaignId);
            return new PerformanceAdGroup()
                    .withType(AdGroupType.PERFORMANCE)
                    .withName(gdAddSmartAdGroupItem.getName())
                    .withCampaignId(campaignId)
                    .withFeedId(gdAddSmartAdGroupItem.getFeedId())
                    .withGeo(geo);
        });
    }

    private GdAddSmartFiltersItem createDefaultSmartFilter(Long adGroupId) {
        return new GdAddSmartFiltersItem()
                .withAdGroupId(adGroupId)
                .withName(translationService.translate(PerformanceFilterTranslations.INSTANCE.defaultSmartFilterName()))
                .withConditions(emptyList())
                .withPriceCpc(BigDecimal.valueOf(0))
                .withTargetFunnel(GdSmartFilterTargetFunnel.SAME_PRODUCTS)
                .withTab(GdSmartFilterTab.ALL_PRODUCTS)
                .withIsSuspended(false);
    }

    /**
     * Обновление перформанс-групп объявлений
     */
    GdUpdateAdGroupPayload updatePerformanceAdGroups(ClientId clientId, Long operatorUid,
                                                     GdUpdatePerformanceAdGroup input) {
        if (isEmpty(input.getUpdateItems())) {
            return createEmptyGdUpdateAdGroupPayload();
        }
        performanceAdGroupValidationService.validateUpdatePerformanceAdGroups(clientId, input);
        boolean isSearchRetargetingEnabled = featureService
                .isEnabledForClientId(clientId, FeatureName.SEARCH_RETARGETING_ENABLED);

        int shard = shardHelper.getShardByClientId(clientId);

        boolean isNewSmartSchemeEnabled = featureService
                .isEnabledForClientId(clientId, FeatureName.CREATIVE_FREE_INTERFACE);
        List<PerformanceBannerMain> banners = !isNewSmartSchemeEnabled ? null : bannerTypedRepository
                .getBannersByGroupIds(shard, mapList(input.getUpdateItems(), GdUpdatePerformanceAdGroupItem::getId),
                        PerformanceBannerMain.class);
        Map<Long, PerformanceBannerMain> bannerByAdGroupId = listToMap(banners, BannerWithAdGroupId::getAdGroupId);
        List<ComplexPerformanceAdGroup> complexAdGroups = mapList(input.getUpdateItems(),
                group -> AdGroupsMutationDataConverter.toComplexPerformanceAdGroup(group, bannerByAdGroupId,
                        isSearchRetargetingEnabled));

        fillAdGroupsTags(shard, complexAdGroups);

        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);

        boolean useBidModifiers = StreamEx.of(input.getUpdateItems()).anyMatch(item -> item.getBidModifiers() != null
                || (item.getSearchRetargetings() != null && isSearchRetargetingEnabled));

        boolean saveDraft = nvl(input.getSaveDraft(), false);
        ComplexPerformanceAdGroupUpdateOperation complexPerformanceAdGroupUpdateOperation =
                complexAdGroupUpdateOperationFactory
                        .createComplexPerformanceAdGroupUpdateOperation(Applicability.FULL, complexAdGroups, geoTree,
                                useBidModifiers, operatorUid, clientId,
                                saveDraft ? ModerationMode.FORCE_SAVE_DRAFT : ModerationMode.FORCE_MODERATE);
        MassResult<Long> result = complexPerformanceAdGroupUpdateOperation.prepareAndApply();
        GdValidationResult validationResult = textAdGroupValidationService.getValidationResult(
                result.getValidationResult(), path(field(GdUpdatePerformanceAdGroup.UPDATE_ITEMS)));

        List<GdUpdateAdGroupPayloadItem> successfullyUpdatedAdGroups = getGdUpdateAdGroupPayloadItems(result);

        // При включенной новой схеме, мы обновляем логотип на PerformanceBannerMain'е, привязанному к группе,
        // в рамках операции в текущем методе. Старые баннеры и креативы при этом не затрагиваются ни на бекенде,
        // ни на фронтенде. Соответственно, чтобы избежать показов старых баннеров со старыми логотипами,
        // остановим их - показы во всех необходимых форматах будут обеспечены новым родительским баннером.
        // До обновления проблем нет, т.к. логотип на родительском баннере в момент его добавления проставляется
        // с учетом логотипа на креативах, привязанным к старым баннерам группы (выбирается наиболее частый).
        // После отключения показов старых смарт-баннеров на стороне БК, костыль нужно выпилить.
        if (isNewSmartSchemeEnabled) {
            List<PerformanceBanner> oldBanners = bannerTypedRepository.getBannersByGroupIds(shard, mapList(
                    successfullyUpdatedAdGroups, GdUpdateAdGroupPayloadItem::getAdGroupId), PerformanceBanner.class);
            List<ModelChanges<BannerWithSystemFields>> modelChanges = mapList(oldBanners, oldBanner ->
                    new ModelChanges<>(oldBanner.getId(), BannerWithSystemFields.class)
                            .process(false, BannerWithSystemFields.STATUS_SHOW));
            MassResult<Long> suspensionResult = bannerSuspendResumeService
                    .suspendResumeBanners(clientId, operatorUid, modelChanges, false);
            if (!isEmpty(suspensionResult.getErrors())) {
                logger.error("Could not suspend all old performance banners: {}", suspensionResult.getErrors());
            }
        }

        return new GdUpdateAdGroupPayload()
                .withUpdatedAdGroupItems(successfullyUpdatedAdGroups)
                .withValidationResult(validationResult);
    }

    /**
     * Обновление охватных групп объявлений
     */
    GdUpdateAdGroupPayload saveCpmAdGroups(ClientId clientId, Long operatorUid, GdUpdateCpmAdGroup input) {
        if (isEmpty(input.getUpdateCpmAdGroupItems())) {
            return createEmptyGdUpdateAdGroupPayload();
        }

        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        Currency clientCurrency = clientService.getWorkCurrency(clientId);
        List<Long> adGroupIds = mapList(input.getUpdateCpmAdGroupItems(), GdUpdateCpmAdGroupItem::getAdGroupId);
        Map<Long, List<Keyword>> keywordsByAdGroupIds = keywordService.getKeywordsByAdGroupIds(clientId, adGroupIds);
        Set<String> enabledFeatures = featureService.getEnabledForClientId(clientId);

        Map<Long, AdGroup> idToAdGroup = input.getIsNewGroups() ? Collections.emptyMap() :
                adGroupService.getAdGroups(clientId, mapList(input.getUpdateCpmAdGroupItems(),
                                GdUpdateCpmAdGroupItem::getAdGroupId))
                        .stream().collect(Collectors.toMap(AdGroup::getId, ag -> ag));

        List<AdGroupSimple> fakeCoreAdGroups = mapList(input.getUpdateCpmAdGroupItems(), adGroup -> new AdGroup()
                .withCampaignId(input.getIsNewGroups() ? adGroup.getCampaignId() :
                        idToAdGroup.get(adGroup.getAdGroupId()).getCampaignId())
                .withType(ifNotNull(adGroup, a -> AdGroupTypeUtils.ADGROUP_TYPE_BY_CPM_GROUP_TYPE.get(a.getType())))
                .withGeo(ifNotNull(adGroup, a -> mapList(adGroup.getRegionIds(), Integer::longValue)))
        );
        var cpmYndxFrontpageCurrencyRestrictions = cpmYndxFrontpageCurrencyService
                .getAdGroupIndexesToPriceDataMapByAdGroups(fakeCoreAdGroups, shard, clientCurrency);

        ValidationResult<GdUpdateCpmAdGroup, Defect> preValidationResult =
                cpmAdGroupValidationService.validateUpdateCpmAdGroups(shard, clientCurrency, keywordsByAdGroupIds,
                        input, enabledFeatures, cpmYndxFrontpageCurrencyRestrictions);
        if (preValidationResult.hasAnyErrors()) {
            return new GdUpdateAdGroupPayload()
                    .withUpdatedAdGroupItems(emptyList())
                    .withValidationResult(cpmAdGroupValidationService.getValidationResult(
                            preValidationResult, emptyPath()));
        }

        Map<Long, List<TargetInterest>> interestsByAdGroupId
                = input.getIsNewGroups() ? emptyMap() : getInterests(clientId, shard, adGroupIds);

        boolean isSearchRetargetingEnabled = featureService
                .isEnabledForClientId(clientId, FeatureName.SEARCH_RETARGETING_ENABLED);
        List<ComplexCpmAdGroup> complexAdGroups = mapList(input.getUpdateCpmAdGroupItems(),
                g -> {
                    List<TargetInterest> targetInterests = nvl(interestsByAdGroupId.get(g.getAdGroupId()), emptyList());

                    //  Если ретаргетинги удалены - создаем. Это может произойти из-за лазейки в api5
                    if (!input.getIsNewGroups() && targetInterests.isEmpty()) {
                        RetargetingCondition retargetingCondition = toRetargetingCondition(clientId,
                                new TargetInterest(),
                                g.getRetargetingCondition(), true, translationService);

                        AddRetargetingConditionsSubOperation retCondOperation =
                                new AddRetargetingConditionsSubOperation(
                                        retargetingConditionOperationFactory,
                                        singletonList(toRetargetingCondition(clientId, new TargetInterest(),
                                                g.getRetargetingCondition(), true, translationService)),
                                        clientId);
                        ValidationResult<List<RetargetingConditionBase>, Defect> vr = retCondOperation.prepare();
                        if (!vr.hasAnyErrors()) {
                            retCondOperation.apply();
                            Long retCondId = retCondOperation
                                    .getRetargetingConditions()
                                    .stream()
                                    .findFirst()
                                    .map(RetargetingConditionBase::getId)
                                    .orElse(null);

                            if (retCondId != null) {
                                var retOperation = retargetingService.createAddOperation(
                                        Applicability.PARTIAL, singletonList(
                                                retargetingCondition
                                                        .getTargetInterest()
                                                        .withAdGroupId(g.getAdGroupId())
                                                        .withRetargetingConditionId(retCondId)),
                                        operatorUid, clientId, operatorUid);

                                retOperation.prepareAndApply();
                                targetInterests = getInterests(clientId, shard, singletonList(g.getAdGroupId()))
                                        .get(g.getAdGroupId());
                            }
                        }
                    }

                    return fromUpdateItemToComplexCpmAdGroup(clientId, g, targetInterests, input.getIsNewGroups(),
                            translationService, isSearchRetargetingEnabled);
                });

        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);

        boolean saveDraft = nvl(input.getSaveDraft(), false);
        MassResult<Long> result;
        if (input.getIsNewGroups()) {
            ShowConditionAutoPriceParams autoPriceParams
                    = getAutoPriceParamsForCpmGroupsToAdd(input.getUpdateCpmAdGroupItems(), clientCurrency,
                    () -> cpmYndxFrontpageCurrencyService
                            .getAdGroupIndexesToPriceDataMapByAdGroups(mapList(complexAdGroups,
                                            ComplexAdGroup::getAdGroup),
                                    shard, clientCurrency)
                            .get(0)
                            .getCpmYndxFrontpageMinPrice());

            ComplexCpmAdGroupAddOperation addOperation = complexAdGroupAddOperationFactory
                    .createCpmAdGroupAddOperation(saveDraft, complexAdGroups, geoTree,
                            true, autoPriceParams, operatorUid, clientId, operatorUid, true);
            result = addOperation.prepareAndApply();
        } else {
            fillAdGroupsTags(shard, complexAdGroups);
            fillMinusPhrases(shard, complexAdGroups);
            fillCampaignIds(shard, complexAdGroups);
            Map<Long, BigDecimal> cpmYndxFrontpageForUpdate =
                    EntryStream.of(
                                    cpmYndxFrontpageCurrencyService
                                            .getAdGroupIdsToPriceDataMapByAdGroups(mapList(complexAdGroups,
                                                            ComplexAdGroup::getAdGroup),
                                                    shard, clientCurrency))
                            .mapValues(t -> t.getCpmYndxFrontpageMinPrice())
                            .filterValues(Objects::nonNull)
                            .toMap();
            ShowConditionAutoPriceParams autoPriceParams
                    = getAutoPriceParamsForCpmGroupsToUpdate(input.getUpdateCpmAdGroupItems(), clientCurrency,
                    cpmYndxFrontpageForUpdate);
            ComplexCpmAdGroupUpdateOperation updateOperation = complexAdGroupUpdateOperationFactory
                    .createCpmAdGroupUpdateOperation(complexAdGroups, geoTree, true, autoPriceParams,
                            operatorUid, clientId, operatorUid, saveDraft);
            result = updateOperation.prepareAndApply();
        }

        GdValidationResult validationResult = cpmAdGroupValidationService.getValidationResult(
                result.getValidationResult(), path(field(GdUpdateCpmAdGroup.UPDATE_CPM_AD_GROUP_ITEMS)));

        if (validationResult != null) {
            // Подгоняем валидацию ядра под модели фронта
            validationResult.getErrors().forEach(e -> e.setPath(e.getPath()
                    .replace("retargetingConditions[0]", "retargetingCondition")
                    .replace(".rules", ".conditionRules")
                    .replace(".geo", ".regionIds")
            ));
        }

        List<GdUpdateAdGroupPayloadItem> successfullyUpdatedAdGroups = getGdUpdateAdGroupPayloadItems(result);

        return new GdUpdateAdGroupPayload()
                .withUpdatedAdGroupItems(successfullyUpdatedAdGroups)
                .withValidationResult(validationResult);
    }

    private Map<Long, List<TargetInterest>> getInterests(ClientId clientId, int shard, List<Long> adGroupIds) {
        return retargetingService.getTargetInterestsWithInterestByAdGroupIds(adGroupIds, clientId, shard)
                .stream()
                .collect(groupingBy(TargetInterest::getAdGroupId));
    }

    /**
     * Добавление или удаление библиотечных наборов к текущим наборам минус-фраз группы
     */
    GdUpdateAdGroupMinusKeywordsPayload updateAdGroupMinusKeywords(ClientId clientId, Long operatorUid,
                                                                   GdUpdateAdGroupMinusKeywords input) {
        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);
        int shard = shardHelper.getShardByClientId(clientId);

        Map<Long, List<Long>> actualAdGroupToPacksMap =
                packRepository.getAdGroupsLibraryMinusKeywordsPacks(shard, input.getAdGroupIds());

        List<ModelChanges<AdGroup>> modelChangesList =
                getUpdateLibMinusKeywordsModelChanges(input, actualAdGroupToPacksMap);

        MassResult<Long> massResult = adGroupService.updateAdGroupsPartialWithFullValidation(modelChangesList, geoTree,
                MINUS_PHRASE_VALIDATION_MODE, operatorUid, clientId);

        return new GdUpdateAdGroupMinusKeywordsPayload()
                .withUpdatedAdGroupIds(getSuccessfullyUpdatedIds(massResult, identity()));
    }

    /**
     * Замена библиотечных наборов к текущим наборам минус-фраз группы
     */
    GdReplaceAdGroupMinusKeywordsPayload replaceAdGroupMinusKeywords(ClientId clientId, Long operatorUid,
                                                                     GdRepalceAdGroupMinusKeywords input) {
        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);
        int shard = shardHelper.getShardByClientId(clientId);

        Map<Long, List<Long>> actualAdGroupToPacksMap =
                packRepository.getAdGroupsLibraryMinusKeywordsPacks(shard, input.getAdGroupIds());

        List<ModelChanges<AdGroup>> modelChangesList =
                getReplaceLibMinusKeywordsModelChanges(input, actualAdGroupToPacksMap);

        MassResult<Long> massResult = adGroupService.updateAdGroupsPartialWithFullValidation(modelChangesList, geoTree,
                MINUS_PHRASE_VALIDATION_MODE, operatorUid, clientId);

        return new GdReplaceAdGroupMinusKeywordsPayload()
                .withReplacedAdGroupIds(getSuccessfullyUpdatedIds(massResult, identity()));
    }

    /**
     * Добавить или убрать (в зависимости от action) наборы минус-фраз из текущего списка наборов минус-фраз группы.
     * Вернуть список ModelChanges содержащий изменения привязанных библиотечных наборов минус-фраз у группы.
     *
     * @param actualAdGroupToPacksMap - текущие наборы минус-фраз у групп
     * @return список изменений привязанных наборов минус-фраз у группы
     */
    private List<ModelChanges<AdGroup>> getUpdateLibMinusKeywordsModelChanges(GdUpdateAdGroupMinusKeywords input,
                                                                              Map<Long, List<Long>>
                                                                                      actualAdGroupToPacksMap) {
        List<ModelChanges<AdGroup>> modelChangesList = new ArrayList<>(actualAdGroupToPacksMap.size());

        actualAdGroupToPacksMap.forEach((adGroupId, actualPackIds) -> {

            Set<Long> newPackIds = new HashSet<>(actualPackIds);
            List<Long> inputPackIds = input.getMinusKeywordsPackIds();

            switch (input.getAction()) {
                case ADD:
                    newPackIds.addAll(inputPackIds);
                    break;
                case REMOVE:
                    newPackIds.removeAll(inputPackIds);
                    break;
                default:
                    throw new IllegalArgumentException("Unknown update mode");
            }

            modelChangesList.add(new ModelChanges<>(adGroupId, AdGroup.class)
                    .process(new ArrayList<>(newPackIds), AdGroup.LIBRARY_MINUS_KEYWORDS_IDS));
        });

        return modelChangesList;
    }

    /**
     * Заменить наборы минус-фраз из текущего списка наборов минус-фраз группы.
     * Вернуть список ModelChanges содержащий изменения привязанных библиотечных наборов минус-фраз у группы.
     *
     * @param actualAdGroupToPacksMap - текущие наборы минус-фраз у групп
     * @return список изменений привязанных наборов минус-фраз у группы
     */
    private List<ModelChanges<AdGroup>> getReplaceLibMinusKeywordsModelChanges(
            GdRepalceAdGroupMinusKeywords input,
            Map<Long, List<Long>> actualAdGroupToPacksMap) {
        List<ModelChanges<AdGroup>> modelChangesList = new ArrayList<>(actualAdGroupToPacksMap.size());

        actualAdGroupToPacksMap.forEach((adGroupId, actualPackIds) -> {

            Set<Long> newPackIds = new HashSet<>(input.getMinusKeywordsPackIds());
            modelChangesList.add(new ModelChanges<>(adGroupId, AdGroup.class)
                    .process(new ArrayList<>(newPackIds), AdGroup.LIBRARY_MINUS_KEYWORDS_IDS));
        });

        return modelChangesList;
    }

    private <T extends ComplexAdGroup> void fillAdGroupsTags(int shard, List<T> complexAdGroups) {
        Map<Long, List<Tag>> tagsMap = tagRepository.getAdGroupsTags(shard,
                mapList(complexAdGroups, complexAdGroup -> complexAdGroup.getAdGroup().getId())
        );
        complexAdGroups.forEach(complexAdGroup -> complexAdGroup.getAdGroup()
                .withTags(
                        mapList(tagsMap.get(complexAdGroup.getAdGroup().getId()), Tag::getId))
        );
    }

    private void fillMinusPhrases(int shard, List<ComplexCpmAdGroup> complexAdGroups) {
        Map<Long, MinusKeywordsPack> minusKeywordsMap = packRepository.getMinusKeywordsByAdGroupIds(shard,
                mapList(complexAdGroups, complexAdGroup -> complexAdGroup.getAdGroup().getId())
        );
        complexAdGroups.forEach(complexAdGroup -> complexAdGroup.getAdGroup()
                .withMinusKeywords(ifNotNull(minusKeywordsMap.get(complexAdGroup.getAdGroup().getId()),
                        MinusKeywordsPack::getMinusKeywords))
        );
    }

    private void fillCampaignIds(int shard, List<ComplexCpmAdGroup> complexAdGroups) {
        Map<Long, Long> campaignIdsMap = adGroupRepository.getCampaignIdsByAdGroupIds(shard,
                mapList(complexAdGroups, complexAdGroup -> complexAdGroup.getAdGroup().getId()));
        complexAdGroups.forEach(complexAdGroup -> complexAdGroup.getAdGroup()
                .withCampaignId(campaignIdsMap.get(complexAdGroup.getAdGroup().getId()))
        );
    }

    /**
     * Создание mcbanner групп
     */
    GdAddAdGroupPayload addMcBannerAdGroups(UidAndClientId client, Long operatorUid, GdAddMcBannerAdGroup input) {
        if (isEmpty(input.getAddItems())) {
            return createEmptyGdAddAdGroupPayload();
        }

        ClientId clientId = client.getClientId();

        //region TODO(darkkeks) DIRECT-130906 -- Убрать после полного перехода фронта на честное создание mcbanner групп
        if (input.getAddItems().get(0).getAdGroupMinusKeywords() == null) {
            mcBannerAdGroupValidationService.validatePartialAddMcBannerAdGroups(input);
            List<AdGroup> adGroups = toCoreMcBannerGroup(clientId, input.getAddItems());
            MassResult<Long> result =
                    adGroupService.addAdGroupsPartial(adGroups, MINUS_PHRASE_VALIDATION_MODE, operatorUid, clientId);
            GdValidationResult validationResult = mcBannerAdGroupValidationService
                    .getValidationResult(result.getValidationResult(), path(field(GdAddMcBannerAdGroup.ADD_ITEMS)));

            List<GdAddAdGroupPayloadItem> successfullyAddedAdGroups =
                    getResults(result, id -> new GdAddAdGroupPayloadItem().withAdGroupId(id));

            return new GdAddAdGroupPayload()
                    .withAddedAdGroupItems(successfullyAddedAdGroups)
                    .withValidationResult(validationResult);
        }
        //endregion

        mcBannerAdGroupValidationService.validateAddMcBannerAdGroups(input);
        mcBannerAdGroupValidationService.additionalValidationOfAddAdGroup(clientId, input);

        List<ComplexMcBannerAdGroup> complexAdGroups =
                toComplexMcBannerAdGroups(
                        input.getAddItems(),
                        featureService.isEnabledForClientId(clientId, FeatureName.SEARCH_RETARGETING_ENABLED)
                );

        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);

        ShowConditionAutoPriceParams showConditionAutoPriceParams =
                getAutoPriceParamsForAddMcBanner(input.getAddItems(), recentStatisticsService);

        ComplexMcBannerAdGroupAddOperation addOperation = complexAdGroupAddOperationFactory
                .createMcBannerAdGroupAddOperation(false, complexAdGroups, geoTree,
                        true, showConditionAutoPriceParams,
                        operatorUid, clientId, client.getUid());
        MassResult<Long> result = addOperation.prepareAndApply();

        GdValidationResult validationResult = mcBannerAdGroupValidationService
                .getValidationResult(result.getValidationResult(), path(field(GdAddMcBannerAdGroup.ADD_ITEMS)));

        List<GdAddAdGroupPayloadItem> successfullyAddedAdGroups = getGdAddAdGroupPayloadItems(result);

        return new GdAddAdGroupPayload()
                .withAddedAdGroupItems(successfullyAddedAdGroups)
                .withValidationResult(validationResult);
    }

    private List<AdGroup> toCoreMcBannerGroup(ClientId clientId, List<GdAddMcBannerAdGroupItem> items) {
        Set<Long> campaignIds = listToSet(items, GdAddAdGroupItem::getCampaignId);
        Map<Long, List<Long>> geoByCampaignId = adGroupService.getDefaultGeoByCampaignId(clientId, campaignIds);
        return mapList(items, gdAddMcBannerAdGroupItem ->
        {
            Long campaignId = gdAddMcBannerAdGroupItem.getCampaignId();
            List<Long> geo = geoByCampaignId.get(campaignId);
            return new McBannerAdGroup()
                    .withType(AdGroupType.MCBANNER)
                    .withName(gdAddMcBannerAdGroupItem.getName())
                    .withCampaignId(campaignId)
                    .withGeo(geo);
        });
    }

    /**
     * Обновление mcbanner групп
     *
     * @param clientId    идентификатор клиента
     * @param operatorUid идентификатор пользователя оператора
     * @param input       запрос на редактирование группы
     */
    GdUpdateAdGroupPayload updateMcBannerAdGroup(ClientId clientId, Long operatorUid, GdUpdateMcBannerAdGroup input) {
        if (isEmpty(input.getUpdateItems())) {
            return createEmptyGdUpdateAdGroupPayload();
        }
        mcBannerAdGroupValidationService.validateUpdateAdGroups(input);

        List<Long> adGroupIds = mapList(input.getUpdateItems(), GdUpdateMcBannerAdGroupItem::getAdGroupId);
        Map<Long, AdGroupType> adGroupTypes = adGroupService.getAdGroupTypes(clientId, adGroupIds);

        mcBannerAdGroupValidationService.additionalValidationOfUpdateAdGroup(clientId, adGroupTypes, input);
        Map<Long, List<Keyword>> keywordsByAdGroupIds = keywordService.getKeywordsByAdGroupIds(clientId, adGroupIds);

        List<ComplexMcBannerAdGroup> complexAdGroups =
                toComplexMcBannerAdGroups(input.getUpdateItems(), keywordsByAdGroupIds, adGroupTypes,
                        featureService.isEnabledForClientId(clientId, FeatureName.SEARCH_RETARGETING_ENABLED));

        int shard = shardHelper.getShardByClientId(clientId);
        fillAdGroupsTags(shard, complexAdGroups);

        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);

        ShowConditionAutoPriceParams showConditionAutoPriceParams =
                getAutoPriceParamsForUpdateMcBanner(input.getUpdateItems(), recentStatisticsService);

        boolean saveDraft = nvl(input.getSaveDraft(), false);
        MassResult<Long> result = complexAdGroupUpdateOperationFactory
                .createMcBannerAdGroupUpdateOperation(complexAdGroups, geoTree, true,
                        showConditionAutoPriceParams, operatorUid, clientId, operatorUid, saveDraft)
                .prepareAndApply();

        GdValidationResult validationResult = mcBannerAdGroupValidationService.getValidationResult(
                result.getValidationResult(), path(field(GdUpdateMcBannerAdGroup.UPDATE_ITEMS)));

        List<GdUpdateAdGroupPayloadItem> successfullyUpdatedAdGroups = getGdUpdateAdGroupPayloadItems(result);

        return new GdUpdateAdGroupPayload()
                .withUpdatedAdGroupItems(successfullyUpdatedAdGroups)
                .withValidationResult(validationResult);
    }

    GdAddAdGroupPayload addContentPromotionAdGroups(User subjectUser, Long operatorUid,
                                                    GdAddContentPromotionAdGroup input) {
        if (isEmpty(input.getAddItems())) {
            return createEmptyGdAddAdGroupPayload();
        }
        ClientId clientId = subjectUser.getClientId();
        Long clientUid = subjectUser.getUid();

        contentPromotionAdGroupValidationService.validateAddContentPromotionAdGroups(input, clientId);

        boolean isSearchRetargetingEnabled = featureService
                .isEnabledForClientId(clientId, FeatureName.SEARCH_RETARGETING_ENABLED);
        List<ComplexContentPromotionAdGroup> complexAdGroups = mapList(input.getAddItems(), group ->
                AdGroupsMutationDataConverter.toComplexContentPromotionAdGroup(group, isSearchRetargetingEnabled));

        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);
        ShowConditionAutoPriceParams showConditionAutoPriceParams =
                getAutoPriceParamsForAddContentPromotion(input.getAddItems(), recentStatisticsService);

        boolean saveDraft = nvl(input.getSaveDraft(), false);
        MassResult<Long> result =
                complexAdGroupAddOperationFactory
                        .createContentPromotionAdGroupAddOperation(saveDraft, complexAdGroups, geoTree, true,
                                showConditionAutoPriceParams, operatorUid, clientId, clientUid)
                        .prepareAndApply();

        GdValidationResult validationResult = contentPromotionAdGroupValidationService.getValidationResult(
                result.getValidationResult(), path(field(GdAddContentPromotionAdGroup.ADD_ITEMS)));

        List<GdAddAdGroupPayloadItem> successfullyAddedAdGroups =
                getResults(result, id -> new GdAddAdGroupPayloadItem().withAdGroupId(id));

        return new GdAddAdGroupPayload()
                .withAddedAdGroupItems(successfullyAddedAdGroups)
                .withValidationResult(validationResult);
    }

    GdUpdateAdGroupPayload updateContentPromotionAdGroups(UidAndClientId uidAndClientId, Long operatorUid,
                                                          GdUpdateContentPromotionAdGroup input) {
        if (isEmpty(input.getUpdateItems())) {
            return createEmptyGdUpdateAdGroupPayload();
        }
        ClientId clientId = uidAndClientId.getClientId();
        contentPromotionAdGroupValidationService.preValidateUpdateContentPromotionAdGroups(input);

        List<Long> adGroupIds = mapList(input.getUpdateItems(), GdUpdateContentPromotionAdGroupItem::getAdGroupId);
        Map<Long, List<Keyword>> keywordsByAdGroupIds = keywordService.getKeywordsByAdGroupIds(clientId, adGroupIds);
        Map<Long, AdGroupType> adGroupTypeByAdGroupId = adGroupService.getAdGroupTypes(clientId, adGroupIds);

        contentPromotionAdGroupValidationService.validateUpdateContentPromotionAdGroups(input, clientId,
                adGroupTypeByAdGroupId);
        boolean isSearchRetargetongEnabled = featureService.
                isEnabledForClientId(clientId, FeatureName.SEARCH_RETARGETING_ENABLED);
        List<ComplexContentPromotionAdGroup> complexAdGroups = mapList(input.getUpdateItems(),
                adGroupUpdateItem -> toComplexContentPromotionAdGroup(adGroupUpdateItem,
                        keywordsByAdGroupIds.get(adGroupUpdateItem.getAdGroupId()),
                        adGroupTypeByAdGroupId.get(adGroupUpdateItem.getAdGroupId()),
                        isSearchRetargetongEnabled));

        fillAdGroupsTags(shardHelper.getShardByClientId(clientId), complexAdGroups);

        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);

        ShowConditionAutoPriceParams showConditionAutoPriceParams =
                getAutoPriceParamsForUpdateContentPromotion(input.getUpdateItems(), recentStatisticsService);

        boolean saveDraft = nvl(input.getSaveDraft(), false);
        MassResult<Long> result =
                complexAdGroupUpdateOperationFactory
                        .createContentPromotionAdGroupUpdateOperation(complexAdGroups, geoTree, true,
                                showConditionAutoPriceParams, operatorUid, clientId, uidAndClientId.getUid(), saveDraft)
                        .prepareAndApply();

        GdValidationResult validationResult = contentPromotionAdGroupValidationService.getValidationResult(
                result.getValidationResult(), path(field(GdUpdateContentPromotionAdGroup.UPDATE_ITEMS)));

        List<GdUpdateAdGroupPayloadItem> successfullyUpdatedAdGroups = getGdUpdateAdGroupPayloadItems(result);

        return new GdUpdateAdGroupPayload()
                .withUpdatedAdGroupItems(successfullyUpdatedAdGroups)
                .withValidationResult(validationResult);
    }

    /**
     * Создание mobile_content групп
     */
    GdAddAdGroupPayload addMobileContentAdGroups(User subjectUser, Long operatorUid, GdAddMobileContentAdGroup input) {
        if (isEmpty(input.getAddItems())) {
            return createEmptyGdAddAdGroupPayload();
        }
        ClientId clientId = subjectUser.getClientId();
        Long clientUid = subjectUser.getUid();

        mobileContentAdGroupValidationService.validateAddAdGroups(input);

        int shard = shardHelper.getShardByClientId(clientId);
        List<Long> campaignIds = mapList(input.getAddItems(), GdAddAdGroupItem::getCampaignId);
        Map<Long, String> campaignIdToStoreUrl = campaignRepository.getStoreUrlByCampaignIds(shard, campaignIds);

        boolean isSearcRetargetingEnabled = featureService
                .isEnabledForClientId(clientId, FeatureName.SEARCH_RETARGETING_ENABLED);
        List<ComplexMobileContentAdGroup> complexAdGroups =
                mapList(input.getAddItems(), group -> AdGroupsMutationDataConverter
                        .toComplexMobileContentAdGroup(group, campaignIdToStoreUrl, isSearcRetargetingEnabled));

        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);
        ShowConditionAutoPriceParams showConditionAutoPriceParams =
                getAutoPriceParamsForAddMobileContent(input.getAddItems(), recentStatisticsService);

        List<TargetInterest> targetInterests = StreamEx.of(complexAdGroups)
                .map(ComplexMobileContentAdGroup::getTargetInterests)
                .nonNull()
                .flatMap(Collection::stream)
                .toList();
        updateDefaultRetargetingConditionShortcutIds(shard, clientId, targetInterests, true);

        boolean saveDraft = nvl(input.getSaveDraft(), false);
        MassResult<Long> result = complexAdGroupAddOperationFactory
                .createMobileContentAdGroupAddOperation(saveDraft, complexAdGroups, geoTree, true,
                        showConditionAutoPriceParams, operatorUid, clientId, clientUid)
                .prepareAndApply();

        GdValidationResult validationResult = mobileContentAdGroupValidationService.getValidationResult(
                result.getValidationResult(), path(field(GdAddMobileContentAdGroup.ADD_ITEMS)));

        List<GdAddAdGroupPayloadItem> successfullyAddedAdGroups =
                getResults(result, id -> new GdAddAdGroupPayloadItem().withAdGroupId(id));

        return new GdAddAdGroupPayload()
                .withAddedAdGroupItems(successfullyAddedAdGroups)
                .withValidationResult(validationResult);
    }

    /**
     * Обновление mobile_content групп
     *
     * @param clientId    идентификатор клиента
     * @param operatorUid идентификатор пользователя оператора
     * @param input       запрос на редактирование группы
     */
    GdUpdateAdGroupPayload updateMobileContentAdGroup(ClientId clientId, Long operatorUid,
                                                      GdUpdateMobileContentAdGroup input) {
        if (isEmpty(input.getUpdateItems())) {
            return createEmptyGdUpdateAdGroupPayload();
        }
        mobileContentAdGroupValidationService.validateUpdateAdGroups(input);

        List<Long> adGroupIds = mapList(input.getUpdateItems(), GdUpdateMobileContentAdGroupItem::getAdGroupId);
        Map<Long, AdGroupType> adGroupTypes = adGroupService.getAdGroupTypes(clientId, adGroupIds);

        mobileContentAdGroupValidationService.additionalValidationOfUpdateAdGroup(clientId, adGroupTypes, input);
        Map<Long, List<Keyword>> keywordsByAdGroupIds = keywordService.getKeywordsByAdGroupIds(clientId, adGroupIds);

        int shard = shardHelper.getShardByClientId(clientId);
        Map<Long, String> adGroupIdToStoreUrl = mobileContentRepository.getStoreUrlByAdGroupIds(shard, adGroupIds);

        boolean isSearchRetargetingEnabled = featureService
                .isEnabledForClientId(clientId, FeatureName.SEARCH_RETARGETING_ENABLED);
        List<ComplexMobileContentAdGroup> complexAdGroups = toComplexMobileContentAdGroups(input.getUpdateItems(),
                keywordsByAdGroupIds, adGroupTypes, adGroupIdToStoreUrl, isSearchRetargetingEnabled);

        fillAdGroupsTags(shard, complexAdGroups);

        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);

        ShowConditionAutoPriceParams showConditionAutoPriceParams =
                getAutoPriceParamsForUpdateMobileContent(input.getUpdateItems(), recentStatisticsService);

        List<TargetInterest> targetInterests = StreamEx.of(complexAdGroups)
                .map(ComplexMobileContentAdGroup::getTargetInterests)
                .flatMap(Collection::stream)
                .toList();

        List<TargetInterest> targetsWithInterest = targetInterests.stream()
                .filter(targetInterest -> targetInterest.getInterestId() != null)
                .collect(Collectors.toList());
        if (!targetsWithInterest.isEmpty()) {
            // Создаем недостающие ссылки на интересы
            retargetingService
                    .getAllExistingInterestLinksWithCreationMissing(targetsWithInterest, shard, clientId);
        }

        updateDefaultRetargetingConditionShortcutIds(shard, clientId, targetInterests, false);

        boolean saveDraft = nvl(input.getSaveDraft(), false);
        MassResult<Long> result = complexAdGroupUpdateOperationFactory
                .createMobileContentAdGroupUpdateOperation(complexAdGroups, geoTree, true,
                        showConditionAutoPriceParams, operatorUid, clientId, operatorUid, saveDraft)
                .prepareAndApply();

        GdValidationResult validationResult = mobileContentAdGroupValidationService.getValidationResult(
                result.getValidationResult(), path(field(GdUpdateMobileContentAdGroup.UPDATE_ITEMS)));

        List<GdUpdateAdGroupPayloadItem> successfullyUpdatedAdGroups = getGdUpdateAdGroupPayloadItems(result);

        return new GdUpdateAdGroupPayload()
                .withUpdatedAdGroupItems(successfullyUpdatedAdGroups)
                .withValidationResult(validationResult);
    }

    /**
     * Создание динамических групп
     */
    GdAddAdGroupPayload addDynamicAdGroups(ClientId clientId, Long operatorUid, GdAddDynamicAdGroup input) {
        if (isEmpty(input.getAddItems())) {
            return createEmptyGdAddAdGroupPayload();
        }
        dynamicAdGroupValidationService.validateAddDynamicAdGroups(input);

        List<AdGroup> adGroups = toCoreDynamicGroup(clientId, input.getAddItems());
        MassResult<Long> result =
                adGroupService.addAdGroupsPartial(adGroups, MINUS_PHRASE_VALIDATION_MODE, operatorUid, clientId);

        GdValidationResult validationResult = dynamicAdGroupValidationService
                .getValidationResult(result.getValidationResult(), path(field(GdAddDynamicAdGroup.ADD_ITEMS)));

        List<GdAddAdGroupPayloadItem> successfullyAddedAdGroups =
                getResults(result, id -> new GdAddAdGroupPayloadItem().withAdGroupId(id));

        var adGroupIdsPartition = EntryStream.zip(result.getResult(), adGroups)
                .filterKeys(r -> r.isSuccessful() && r.getResult() != null)
                .mapKeys(Result::getResult)
                .collect(Collectors.partitioningBy(entry -> entry.getValue() instanceof DynamicFeedAdGroup,
                        Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        fillDynamicAdTargets(adGroupIdsPartition, clientId, operatorUid);

        return new GdAddAdGroupPayload()
                .withAddedAdGroupItems(successfullyAddedAdGroups)
                .withValidationResult(validationResult);
    }

    private List<AdGroup> toCoreDynamicGroup(ClientId clientId, List<GdAddDynamicAdGroupItem> items) {
        Set<Long> campaignIds = listToSet(items, GdAddAdGroupItem::getCampaignId);
        Map<Long, List<Long>> geoByCampaignId = adGroupService.getDefaultGeoByCampaignId(clientId, campaignIds);

        return mapList(items, gdAddDynamicAdGroupItem -> {
            Long campaignId = gdAddDynamicAdGroupItem.getCampaignId();
            List<Long> geo = geoByCampaignId.get(campaignId);

            DynamicAdGroup dynamicAdGroup = (gdAddDynamicAdGroupItem.getFeedId() != null)
                    ? new DynamicFeedAdGroup().withFeedId(gdAddDynamicAdGroupItem.getFeedId())
                    : new DynamicTextAdGroup().withDomainUrl(gdAddDynamicAdGroupItem.getDomainUrl());

            return dynamicAdGroup
                    .withType(AdGroupType.DYNAMIC)
                    .withName(gdAddDynamicAdGroupItem.getName())
                    .withCampaignId(campaignId)
                    .withGeo(geo);
        });
    }

    private DynamicFeedAdTarget createDefaultFeedDynamicFilter(Long adGroupId, Map<Long, Feed> feedByAdGroupId) {
        Feed feed = feedByAdGroupId.get(adGroupId);
        BusinessType businessType = feed.getBusinessType();
        FeedType feedType = feed.getFeedType();
        List<DynamicFeedRule> conditions = emptyList();

        return new DynamicFeedAdTarget()
                .withAdGroupId(adGroupId)
                .withConditionName(translationService.translate(
                        DynamicTextAdTargetTranslations.INSTANCE.defaultFeedDynamicConditionName()))
                .withIsSuspended(false)
                .withBusinessType(businessType)
                .withFeedType(feedType)
                .withCondition(conditions)
                .withConditionHash(getHashForDynamicFeedRules(conditions))
                .withTab(DynamicAdTargetTab.ALL_PRODUCTS);
    }

    private DynamicTextAdTarget createDefaultWebpageDynamicFilter(Long adGroupId) {
        List<WebpageRule> conditions = emptyList();

        return new DynamicTextAdTarget()
                .withAdGroupId(adGroupId)
                .withConditionName(translationService.translate(
                        DynamicTextAdTargetTranslations.INSTANCE.defaultWebpageDynamicConditionName()))
                .withCondition(conditions)
                .withIsSuspended(false)
                .withConditionHash(DynamicTextAdTargetHashUtils.getHash(conditions))
                .withConditionUniqHash(DynamicTextAdTargetHashUtils.getUniqHash(conditions));
    }

    /**
     * Обновление динамических групп
     */
    GdUpdateAdGroupPayload updateDynamicAdGroups(ClientId clientId, Long operatorUid, GdUpdateDynamicAdGroup input) {
        if (isEmpty(input.getUpdateItems())) {
            return createEmptyGdUpdateAdGroupPayload();
        }
        dynamicAdGroupValidationService.validateUpdateDynamicAdGroups(clientId, input);

        boolean isSearchRetargeting = featureService
                .isEnabledForClientId(clientId, FeatureName.SEARCH_RETARGETING_ENABLED);
        List<ComplexDynamicAdGroup> complexAdGroups =
                mapList(input.getUpdateItems(), group
                        -> AdGroupsMutationDataConverter.toComplexDynamicAdGroup(group, isSearchRetargeting));

        int shard = shardHelper.getShardByClientId(clientId);
        fillAdGroupsTags(shard, complexAdGroups);

        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(clientId);

        boolean saveDraft = nvl(input.getSaveDraft(), false);
        MassResult<Long> result = complexAdGroupUpdateOperationFactory
                .createDynamicAdGroupUpdateOperation(complexAdGroups, geoTree,
                        operatorUid, clientId, saveDraft)
                .prepareAndApply();

        GdValidationResult validationResult = dynamicAdGroupValidationService.getValidationResult(
                result.getValidationResult(), path(field(GdUpdateDynamicAdGroup.UPDATE_ITEMS)));

        List<GdUpdateAdGroupPayloadItem> successfullyUpdatedAdGroups = getGdUpdateAdGroupPayloadItems(result);

        return new GdUpdateAdGroupPayload()
                .withUpdatedAdGroupItems(successfullyUpdatedAdGroups)
                .withValidationResult(validationResult);
    }

    /**
     * Замена дефолтных id шорткатов (условий ретаргетинга) существующими или создание новых
     *
     * @param shard              номер шарда
     * @param clientId           id клиента
     * @param targetInterests    список условий ретаргетинга, среди которых могут быть шорткаты с дефолтными id
     * @param isCampaignIdFilled заполнено ли у условий ретаргетинга поле id кампании (если нет - значит, заполнено
     *                           поле id группы)
     */
    protected void updateDefaultRetargetingConditionShortcutIds(int shard, ClientId clientId,
                                                                List<TargetInterest> targetInterests,
                                                                Boolean isCampaignIdFilled) {
        if (isEmpty(targetInterests)) {
            return;
        }

        // Достаем шорткаты с дефолтными id
        List<TargetInterest> shortcutRetargetingConditionTargets = targetInterests.stream()
                .filter(target -> target.getRetargetingConditionId() != null
                        && RETARGETING_CONDITION_SHORTCUT_DEFAULT_IDS.contains(target.getRetargetingConditionId())
                        && (isCampaignIdFilled ? target.getCampaignId() != null : target.getAdGroupId() != null))
                .collect(Collectors.toList());

        // Шорткаты уникальны в рамках одной кампании; разбиваем дефолтные id по кампаниям
        Map<Long, List<Long>> shortcutRetargetingConditionIdsByCid;
        Map<Long, Long> campaignIdByAdGroupId = Map.of();
        if (isCampaignIdFilled) {
            shortcutRetargetingConditionIdsByCid = StreamEx.of(shortcutRetargetingConditionTargets)
                    .groupingBy(Retargeting::getCampaignId,
                            mapping(TargetInterest::getRetargetingConditionId, toList()));
        } else {
            var adGroupIds = shortcutRetargetingConditionTargets.stream()
                    .map(Retargeting::getAdGroupId)
                    .distinct()
                    .collect(Collectors.toList());
            campaignIdByAdGroupId = adGroupRepository.getCampaignIdsByAdGroupIds(shard, clientId, adGroupIds);
            var shortcutRetargetingConditionIdsByPid = StreamEx.of(shortcutRetargetingConditionTargets)
                    .groupingBy(Retargeting::getAdGroupId,
                            mapping(TargetInterest::getRetargetingConditionId, toList()));
            shortcutRetargetingConditionIdsByCid = EntryStream.of(shortcutRetargetingConditionIdsByPid)
                    .mapKeys(campaignIdByAdGroupId::get)
                    .nonNullKeys()
                    .toMap();
        }

        // Получаем уже существующие id шорткатов или создаем новые
        Map<Long, Map<Long, Long>> addedIdByDefaultIdByCid =
                retargetingConditionService.findOrCreateRetargetingConditionShortcuts(
                        shard, clientId, shortcutRetargetingConditionIdsByCid);

        // Подменяем дефолтные id шорткатов
        for (var shortcutTarget : shortcutRetargetingConditionTargets) {
            var defaultRetargetingId = shortcutTarget.getRetargetingConditionId();
            var cid = isCampaignIdFilled
                    ? shortcutTarget.getCampaignId()
                    : campaignIdByAdGroupId.get(shortcutTarget.getAdGroupId());
            var addedRetargetingId = addedIdByDefaultIdByCid.getOrDefault(cid, Map.of()).get(defaultRetargetingId);
            shortcutTarget.setRetargetingConditionId(addedRetargetingId);
        }
    }

    private void logRuntimeError(String filterType, List<Long> adGroupIds, Throwable e) {
        var msg = MessageFormatter.format(DEFAULT_FILTERS_NOT_ADDED_RUNTIME_MESSAGE, filterType, adGroupIds);
        logger.warn(msg.getMessage(), e);
    }

    private void logValidationError(String filterType, List<Long> adGroupIds, String validationResult) {
        logger.warn(DEFAULT_FILTERS_NOT_ADDED_VALIDATION_MESSAGE, filterType, adGroupIds, validationResult);
    }
}
