package ru.yandex.direct.grid.processing.service.group;

import java.util.List;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.keyword.service.KeywordRecentStatisticsProvider;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionFixedAutoPrices;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddContentPromotionAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddMcBannerAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddMobileContentAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateContentPromotionAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateMcBannerAdGroupItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateMobileContentAdGroupItem;

class AdGroupMutationUtils {

    /**
     * Возвращает контейнер с параметрами для автоматического выставления недостающих ставок
     * в условиях показов для групп продвижения контента.
     */
    static ShowConditionAutoPriceParams getAutoPriceParamsForAddContentPromotion(List<GdAddContentPromotionAdGroupItem> addAdGroupItems,
                                                                                 KeywordRecentStatisticsProvider keywordRecentStatisticsProvider) {
        ShowConditionFixedAutoPrices fixedAdGroupAutoPrices =
                ShowConditionFixedAutoPrices.ofGlobalFixedPrice(addAdGroupItems.get(0).getGeneralPrice());

        return new ShowConditionAutoPriceParams(fixedAdGroupAutoPrices, keywordRecentStatisticsProvider);
    }

    /**
     * Возвращает контейнер с параметрами для автоматического выставления недостающих ставок
     * в условиях показов для групп продвижения контента.
     */
    static ShowConditionAutoPriceParams getAutoPriceParamsForUpdateContentPromotion(List<GdUpdateContentPromotionAdGroupItem> updateAdGroupItems,
                                                                                    KeywordRecentStatisticsProvider keywordRecentStatisticsProvider) {
        ShowConditionFixedAutoPrices fixedAutoPrices = ShowConditionFixedAutoPrices.ofPerAdGroupFixedPrices(
                StreamEx.of(updateAdGroupItems)
                        .mapToEntry(GdUpdateContentPromotionAdGroupItem::getAdGroupId, GdUpdateContentPromotionAdGroupItem::getGeneralPrice)
                        .nonNullValues()
                        .toMap());

        return new ShowConditionAutoPriceParams(fixedAutoPrices, keywordRecentStatisticsProvider);
    }

    /**
     * Возвращает контейнер с параметрами для автоматического выставления недостающих ставок
     * в условиях показов для групп РМП.
     */
    static ShowConditionAutoPriceParams getAutoPriceParamsForAddMobileContent(
            List<GdAddMobileContentAdGroupItem> addAdGroupItems,
            KeywordRecentStatisticsProvider keywordRecentStatisticsProvider) {
        ShowConditionFixedAutoPrices fixedAdGroupAutoPrices =
                ShowConditionFixedAutoPrices.ofGlobalFixedPrice(addAdGroupItems.get(0).getGeneralPrice());

        return new ShowConditionAutoPriceParams(fixedAdGroupAutoPrices, keywordRecentStatisticsProvider);
    }

    /**
     * Параметры для установки ставки на группу
     *
     * @param updateAdGroupItems обновляемые группы
     */
    static ShowConditionAutoPriceParams getAutoPriceParamsForUpdateMobileContent(
            List<GdUpdateMobileContentAdGroupItem> updateAdGroupItems,
            KeywordRecentStatisticsProvider keywordRecentStatisticsProvider) {

        ShowConditionFixedAutoPrices fixedAutoPrices = ShowConditionFixedAutoPrices.ofPerAdGroupFixedPrices(
                StreamEx.of(updateAdGroupItems)
                        .mapToEntry(GdUpdateMobileContentAdGroupItem::getAdGroupId,
                                GdUpdateMobileContentAdGroupItem::getGeneralPrice)
                        .nonNullValues()
                        .toMap());

        return new ShowConditionAutoPriceParams(fixedAutoPrices, keywordRecentStatisticsProvider);
    }

    /**
     * Возвращает контейнер с параметрами для автоматического выставления недостающих ставок
     * в условиях показов для групп McBanner.
     */
    static ShowConditionAutoPriceParams getAutoPriceParamsForAddMcBanner(
            List<GdAddMcBannerAdGroupItem> addMcBannerAdGroupItems,
            KeywordRecentStatisticsProvider keywordRecentStatisticsProvider) {
        ShowConditionFixedAutoPrices fixedAutoPrices =
                ShowConditionFixedAutoPrices.ofGlobalFixedPrice(addMcBannerAdGroupItems.get(0).getGeneralPrice());

        return new ShowConditionAutoPriceParams(fixedAutoPrices, keywordRecentStatisticsProvider);
    }

    /**
     * Параметры для установки ставки на группу
     */
    static ShowConditionAutoPriceParams getAutoPriceParamsForUpdateMcBanner(
            List<GdUpdateMcBannerAdGroupItem> updateMcBannerAdGroupItems,
            KeywordRecentStatisticsProvider keywordRecentStatisticsProvider) {
        ShowConditionFixedAutoPrices fixedAutoPrices = ShowConditionFixedAutoPrices.ofPerAdGroupFixedPrices(
                StreamEx.of(updateMcBannerAdGroupItems)
                        .mapToEntry(GdUpdateMcBannerAdGroupItem::getAdGroupId,
                                GdUpdateMcBannerAdGroupItem::getGeneralPrice)
                        .nonNullValues()
                        .toMap());

        return new ShowConditionAutoPriceParams(fixedAutoPrices, keywordRecentStatisticsProvider);
    }
}
