package ru.yandex.direct.grid.processing.service.group.converter;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupStates;
import ru.yandex.direct.core.entity.adgroup.model.CpmBannerAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmVideoAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CriterionType;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.bidmodifier.container.MultipliersBounds;
import ru.yandex.direct.core.entity.mobilecontent.model.OsType;
import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.grid.core.entity.group.container.GdiAdGroupRegionsInfo;
import ru.yandex.direct.grid.core.entity.group.container.GdiGroupRelevanceMatch;
import ru.yandex.direct.grid.core.entity.group.model.GdiBaseGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiContentPromotionGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiContentPromotionGroupType;
import ru.yandex.direct.grid.core.entity.group.model.GdiCpmAudioGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiCpmBannerGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiCpmGeoPinGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiCpmGeoproductGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiCpmIndoorGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiCpmOutdoorGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiCpmVideoGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiCpmYndxFrontpageGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiDynamicGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiGroupFilter;
import ru.yandex.direct.grid.core.entity.group.model.GdiGroupModerationStatus;
import ru.yandex.direct.grid.core.entity.group.model.GdiGroupOrderBy;
import ru.yandex.direct.grid.core.entity.group.model.GdiGroupStatus;
import ru.yandex.direct.grid.core.entity.group.model.GdiInternalGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiMcbannerGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiMinusKeywordsPackInfo;
import ru.yandex.direct.grid.core.entity.group.model.GdiMobileContentGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiMobileContentPrices;
import ru.yandex.direct.grid.core.entity.group.model.GdiPerformanceGroup;
import ru.yandex.direct.grid.core.entity.group.service.GridAdGroupConstants;
import ru.yandex.direct.grid.core.entity.recommendation.model.GdiRecommendation;
import ru.yandex.direct.grid.core.entity.retargeting.model.GdiRetargetingConditionRuleItem;
import ru.yandex.direct.grid.model.GdEntityStats;
import ru.yandex.direct.grid.model.campaign.GdCampaignStatus;
import ru.yandex.direct.grid.model.campaign.GdCampaignTruncated;
import ru.yandex.direct.grid.model.campaign.GdCampaignType;
import ru.yandex.direct.grid.model.campaign.GdiBaseCampaign;
import ru.yandex.direct.grid.model.entity.adgroup.AdGroupTypeConverter;
import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;
import ru.yandex.direct.grid.model.feed.GdFeed;
import ru.yandex.direct.grid.processing.model.group.GdAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupAccess;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupFeatures;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupFilter;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupModerationStatus;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupMultipliersBounds;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupOrderBy;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupOrderByField;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupPageBlock;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupPrimaryStatus;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupPrimaryStatusDesc;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupRegionsInfo;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupStatus;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupWithTotals;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupsContainer;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupsContext;
import ru.yandex.direct.grid.processing.model.group.GdBannerAction;
import ru.yandex.direct.grid.processing.model.group.GdContentPromotionAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmAudioAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmBannerAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmGeoPinAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmGeoproductAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmIndoorAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmOutdoorAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmPriceAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmPriceAudioAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmPriceBannerAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmPriceVideoAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmVideoAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCpmYndxFrontpageAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCriterionType;
import ru.yandex.direct.grid.processing.model.group.GdDynamicAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdGroupBlGenerationStatus;
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdMcBannerAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdMinusKeywordsPackInfo;
import ru.yandex.direct.grid.processing.model.group.GdMobileContentAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdMobileContentAdGroupDeviceTypeTargeting;
import ru.yandex.direct.grid.processing.model.group.GdMobileContentAdGroupNetworkTargeting;
import ru.yandex.direct.grid.processing.model.group.GdMobileContentAdGroupOsType;
import ru.yandex.direct.grid.processing.model.group.GdMobileContentPrices;
import ru.yandex.direct.grid.processing.model.group.GdSmartAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdStoreActionForPrices;
import ru.yandex.direct.grid.processing.model.group.GdTextAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdVideoGoalType;
import ru.yandex.direct.grid.processing.model.group.mutation.GdContentPromotionGroupType;
import ru.yandex.direct.grid.processing.model.group.mutation.GdRelevanceMatchCategory;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateAdGroupRelevanceMatchItem;
import ru.yandex.direct.grid.processing.model.recommendation.GdRecommendation;
import ru.yandex.direct.grid.processing.model.retargeting.GdRetargetingConditionRuleItem;
import ru.yandex.direct.grid.processing.model.showcondition.GdShowConditionType;
import ru.yandex.direct.grid.processing.model.tag.GdTag;
import ru.yandex.direct.grid.processing.service.group.AdGroupActionConditionsUtil;
import ru.yandex.direct.grid.processing.service.group.AvailableAdGroupTypesCalculator;
import ru.yandex.direct.grid.processing.service.group.container.GroupsCacheFilterData;
import ru.yandex.direct.grid.processing.service.group.container.GroupsCacheRecordInfo;
import ru.yandex.direct.grid.processing.service.operator.OperatorAllowedActionsUtils;
import ru.yandex.direct.grid.processing.service.showcondition.converter.RetargetingConverter;
import ru.yandex.direct.grid.processing.util.StatHelper;
import ru.yandex.direct.utils.ListUtils;

import static java.lang.String.format;
import static java.util.Collections.emptyList;
import static java.util.Collections.singleton;
import static ru.yandex.direct.core.entity.campaign.converter.MobileContentInfoConverter.generateIconUrl;
import static ru.yandex.direct.grid.core.entity.recommendation.service.GridRecommendationService.GDI_RECOMMENDATION_GD_RECOMMENDATION_FUNCTION;
import static ru.yandex.direct.grid.model.entity.adgroup.AdGroupTypeConverter.toGdAdGroupType;
import static ru.yandex.direct.grid.model.entity.adgroup.AdGroupTypeConverter.toInternalAdGroupType;
import static ru.yandex.direct.grid.model.utils.RfConverter.toGdRfPeriod;
import static ru.yandex.direct.grid.processing.model.client.GdOperatorAction.SEND_TO_MODERATION_BY_CLIENT;
import static ru.yandex.direct.grid.processing.service.banner.BannerDataConverter.toGdBannerImage;
import static ru.yandex.direct.grid.processing.service.group.AdGroupActionConditionsUtil.isCpmPriceDefaultAdGroup;
import static ru.yandex.direct.grid.processing.service.group.AdGroupActionConditionsUtil.isCpmPriceDefaultAdGroupReadyToStart;
import static ru.yandex.direct.grid.processing.service.group.AvailableAdGroupTypesCalculator.canCopyAdGroup;
import static ru.yandex.direct.grid.processing.service.group.AvailableAdGroupTypesCalculator.canEditAdGroup;
import static ru.yandex.direct.grid.processing.service.group.AvailableAdGroupTypesCalculator.canEditAdGroupAds;
import static ru.yandex.direct.grid.processing.service.group.AvailableAdGroupTypesCalculator.canEditAdGroupKeywords;
import static ru.yandex.direct.grid.processing.util.ResultConverterHelper.getCountOfTrueBooleanValues;
import static ru.yandex.direct.grid.processing.util.StatHelper.calcTotalGoalStats;
import static ru.yandex.direct.grid.processing.util.StatHelper.calcTotalStats;
import static ru.yandex.direct.grid.processing.util.StatHelper.recalcTotalStatsForUnitedGrid;
import static ru.yandex.direct.utils.CollectionUtils.isEmpty;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.utils.FunctionalUtils.mapSet;

@ParametersAreNonnullByDefault
public class AdGroupDataConverter {

    private AdGroupDataConverter() {
    }

    public static GdAdGroup toOuter(int index, GdiGroup internal, GdiBaseCampaign gdiBaseCampaign,
                                    GdCampaignTruncated campaign,
                                    @Nullable List<GdTag> tags, User operator, Set<String> enabledFeatures,
                                    Map<Long, GdFeed> gdFeedsById,
                                    boolean cpcAndCpmOnOneGridEnabled,
                                    @Nullable PricePackage pricePackage) {
        GdAdGroupStatus status = toGdAdGroupStatus(internal.getStatus());
        GdAdGroup gdAdGroup = getGroupImplementation(internal, campaign.getType(), gdFeedsById)
                .withIndex(index)
                .withId(internal.getId())
                .withCampaignId(internal.getCampaignId())
                .withCampaign(campaign)
                .withName(internal.getName())
                .withMinusKeywords(nvl(internal.getMinusKeywords(), emptyList()))
                .withLibraryMinusKeywordsPacks(
                        mapList(internal.getLibraryMinusKeywordsPacks(), AdGroupDataConverter::toGdMinusKeywordPack))
                .withRegionsInfo(getRegionsInfo(internal.getRegionsInfo()))
                .withHyperGeoId(internal.getHyperGeoId())
                .withTags(tags)
                .withAccess(toGdAdGroupAccess(internal, status, gdiBaseCampaign, campaign, operator, enabledFeatures))
                .withStats(ifNotNull(internal.getStat(),
                        stat -> StatHelper.internalStatsToOuter(stat, campaign.getType(), cpcAndCpmOnOneGridEnabled)))
                .withGoalStats(mapList(internal.getGoalStats(), StatHelper::internalGoalStatToOuter))
                .withMultipliersBounds(
                        ifNotNull(internal.getMultipliersBounds(), AdGroupDataConverter::toGdAdGroupMultipliersBounds))
                .withRecommendations(toGdRecommendations(internal.getRecommendations()))
                .withStatus(status)
                .withPageGroupTags(internal.getPageGroupTags())
                .withTargetTags(internal.getTargetTags())
                .withProjectParamConditions(internal.getProjectParamConditions())
                .withContentCategoriesRetargetingConditionRules(
                        toGdRetargetingConditionRules(internal.getContentCategoriesRetargetingConditionRules()))
                .withAggregatedStatus(internal.getAggregatedStatus())
                .withAggregatedStatusInfo(internal.getAggregatedStatusInfo())
                .withRelevanceMatch(toGdUpdateAdGroupRelevanceMatchItem(internal.getRelevanceMatch()));

        // Бывает удобно заполнять тип прямо в методе getGroupImplementation при работе с синтетическими типами групп.
        // В этом случае затирать тип не нужно.
        return gdAdGroup
                .withType(nvl(gdAdGroup.getType(), toGdAdGroupType(internal.getType(), campaign.getType(), pricePackage)));
    }

    @Nullable
    private static List<GdRecommendation> toGdRecommendations(@Nullable List<GdiRecommendation> recommendations) {
        if (recommendations == null) {
            return null;
        }
        return mapList(recommendations, GDI_RECOMMENDATION_GD_RECOMMENDATION_FUNCTION);
    }

    private static GdAdGroupStatus toGdAdGroupStatus(GdiGroupStatus groupStatus) {
        return new GdAdGroupStatus()
                .withActive(groupStatus.getStateFlags().getActive())
                .withArchived(groupStatus.getStateFlags().getArchived())
                .withShowing(groupStatus.getStateFlags().getShowing())
                .withBsEverSynced(groupStatus.getStateFlags().getBsEverSynced())
                .withModerationStatus(GdAdGroupModerationStatus.fromSource(groupStatus.getModerationStatus()))
                .withBlGenerationStatus(GdGroupBlGenerationStatus.fromSource(groupStatus.getBlGenerationStatus()))
                .withPrimaryStatus(GdAdGroupPrimaryStatus.fromSource(groupStatus.getPrimaryStatus()))
                .withPrimaryStatusDesc(getAdGroupPrimaryStatusDesc(groupStatus));
    }

    private static GdAdGroupPrimaryStatusDesc getAdGroupPrimaryStatusDesc(GdiGroupStatus groupStatus) {
        if (groupStatus.getStateFlags().getActive()) {
            return (groupStatus.getModerationStatus() == GdiGroupModerationStatus.MODERATION ||
                    groupStatus.getModerationStatus() == GdiGroupModerationStatus.REJECTED) ?
                    GdAdGroupPrimaryStatusDesc.PREVIOUS_VERSION_SHOWING :
                    GdAdGroupPrimaryStatusDesc.SHOWING;
        } else {
            return null;
        }

    }

    private static GdAdGroupMultipliersBounds toGdAdGroupMultipliersBounds(MultipliersBounds multipliersBounds) {
        return new GdAdGroupMultipliersBounds().withLower(multipliersBounds.getLower())
                .withUpper(multipliersBounds.getUpper());
    }


    private static GdAdGroupAccess toGdAdGroupAccess(GdiGroup internal, GdAdGroupStatus status,
                                                     GdiBaseCampaign gdiBaseCampaign,
                                                     GdCampaignTruncated campaign, User operator,
                                                     Set<String> enabledFeatures) {
        // На фронте старого директа тут (group.enable || group.banners_quantity > 0 && group.archive !== 'Yes') &&
        // !campaignIsReadonly
        // Но мы точно знаем, что группа архивна только когда у нее есть баннеры и все они архивны, так что проверка
        // group.banners_quantity > 0 не нужна,
        // group.enable - непонятно что и нигде не вычисляется, так что его тоже пропустим
        boolean canEdit = campaign.getAccess().getCanEdit() && !status.getArchived()
                && canEditAdGroup(gdiBaseCampaign.getType(), internal.getType(), enabledFeatures);
        boolean canCopy = canEdit && canCopyAdGroup(internal.getType(), gdiBaseCampaign.getType(), enabledFeatures);
        boolean canEditAds = canEdit && canEditAdGroupAds(internal.getType(), enabledFeatures);
        boolean canEditKeywords = canEdit && canEditAdGroupKeywords(internal.getType());
        boolean canViewRegions = AvailableAdGroupTypesCalculator.canEditAdGroupRegions(internal.getType())
                && !isCpmPriceDefaultAdGroup(internal, campaign);
        boolean canEditRegions = canEdit && canViewRegions;
        boolean canBeSentToModerationByClient = calcCanBeSentToModerationByClient(operator, canEdit,
                internal.getStatus().getStateFlags(), campaign.getStatus(), gdiBaseCampaign, internal);
        Set<GdBannerAction> bannerActions = calcGdBannerActions(status, enabledFeatures);

        return new GdAdGroupAccess()
                .withAdGroupId(internal.getId())
                .withType(internal.getType())
                .withStatus(status)
                .withMainAdStatusModerate(ifNotNull(internal.getMainAd(), BannerWithSystemFields::getStatusModerate))
                .withBannerActions(bannerActions)
                .withCanEdit(canEdit)
                .withCanEditAds(canEditAds)
                .withCanEditKeywords(canEditKeywords)
                .withCanEditRegions(canEditRegions)
                .withCanViewRegions(canViewRegions)
                .withCanCopy(canCopy)
                .withCanBeSentToModerationByClient(canBeSentToModerationByClient)
                .withShowGeneralPriceOnEdit(!campaign.getFlatStrategy().getIsAutoBudget());
    }

    private static List<GdRetargetingConditionRuleItem> toGdRetargetingConditionRules(
            List<GdiRetargetingConditionRuleItem> gdiRetargetingConditionRuleItems) {
        return mapList(gdiRetargetingConditionRuleItems, RetargetingConverter::toGdRetargetingConditionRuleItem);
    }

    private static boolean calcCanBeSentToModerationByClient(User operator, boolean canEdit,
                                                             AdGroupStates adGroupStates,
                                                             GdCampaignStatus campaignStatus,
                                                             GdiBaseCampaign gdiBaseCampaign,
                                                             GdiGroup gdiGroup) {
        return OperatorAllowedActionsUtils.hasAction(SEND_TO_MODERATION_BY_CLIENT, operator)
                && AdGroupActionConditionsUtil.canBeSentToModerationByClient(canEdit, adGroupStates, campaignStatus)
                && !isCpmPriceDefaultAdGroupReadyToStart(gdiGroup, gdiBaseCampaign);
    }

    private static Set<GdBannerAction> calcGdBannerActions(GdAdGroupStatus status, Set<String> enabledFeatures) {
        if (enabledFeatures.contains(FeatureName.ADGROUP_INDIVISIBLE_DRAFT_STATUS.getName())
                && status.getModerationStatus() == GdAdGroupModerationStatus.DRAFT) {
            return Set.of(GdBannerAction.SAVE_AS_DRAFT, GdBannerAction.SAVE_AND_MODERATE_GROUP);
        }
        return singleton(GdBannerAction.SAVE_AND_MODERATE);
    }

    private static GdAdGroup getGroupImplementation(GdiGroup internal, GdCampaignType campaignType,
                                                    Map<Long, GdFeed> gdFeedsById) {
        if (internal instanceof GdiDynamicGroup) {
            GdiDynamicGroup dynamicGroup = (GdiDynamicGroup) internal;
            return new GdDynamicAdGroup()
                    .withMainDomain(dynamicGroup.getMainDomain())
                    .withDynamicFeedId(dynamicGroup.getDynamicFeedId())
                    .withFieldToUseAsName(dynamicGroup.getFieldToUseAsName())
                    .withFieldToUseAsBody(dynamicGroup.getFieldToUseAsBody())
                    .withTrackingParams(dynamicGroup.getTrackingParams());
        }
        if (internal instanceof GdiMobileContentGroup) {
            GdiMobileContentGroup mobileContentGroup = (GdiMobileContentGroup) internal;
            OsType osType = OsType.valueOf(mobileContentGroup.getOsType().name());
            return new GdMobileContentAdGroup()
                    .withStoreHref(mobileContentGroup.getStoreHref())
                    .withDeviceTypeTargeting(mapSet(mobileContentGroup.getDeviceTypeTargeting(),
                            deviceType -> GdMobileContentAdGroupDeviceTypeTargeting.valueOf(deviceType.name())))
                    .withNetworkTargeting(mapSet(mobileContentGroup.getNetworkTargeting(),
                            networkTargeting -> GdMobileContentAdGroupNetworkTargeting.valueOf(networkTargeting.name())))
                    .withStoreContentId(mobileContentGroup.getStoreContentId())
                    .withStoreCountry(mobileContentGroup.getStoreCountry())
                    .withIconHash(mobileContentGroup.getIconHash())
                    .withIconUrl(generateIconUrl(mobileContentGroup.getIconHash(), osType))
                    .withMobileContentName(mobileContentGroup.getMobileContentName())
                    .withBundleId(mobileContentGroup.getBundleId())
                    .withMinimalOsVersionFromStore(mobileContentGroup.getMinimalOsVersionFromStore())
                    .withCurrentMinimalOsVersion(mobileContentGroup.getCurrentMinimalOsVersion())
                    .withOsType(GdMobileContentAdGroupOsType.valueOf(mobileContentGroup.getOsType().name()))
                    .withMobileContentPrices(toGdMobileContentPrices(mobileContentGroup.getMobileContentPrices()))
                    .withRating(mobileContentGroup.getRating())
                    .withRatingVotes(mobileContentGroup.getRatingVotes());
        }
        if (internal instanceof GdiBaseGroup) {
            GdiBaseGroup group = (GdiBaseGroup) internal;
            GdFeed feed = group.getFeedId() != null ? gdFeedsById.get(group.getFeedId()) : null;
            return new GdTextAdGroup()
                    .withFeed(feed)
                    .withFeedFilterCategories(mapList(group.getFeedFilterCategories(),
                            String::valueOf))
                    .withFieldToUseAsName(group.getFieldToUseAsName())
                    .withFieldToUseAsBody(group.getFieldToUseAsBody())
                    .withCollectAudience(group.getCollectAudience());
        }
        if (internal instanceof GdiPerformanceGroup) {
            GdiPerformanceGroup performanceGroup = (GdiPerformanceGroup) internal;
            return new GdSmartAdGroup()
                    .withFeedId(performanceGroup.getFeedId())
                    .withFieldToUseAsName(performanceGroup.getFieldToUseAsName())
                    .withFieldToUseAsBody(performanceGroup.getFieldToUseAsBody())
                    .withLogoImage(toGdBannerImage(performanceGroup.getLogo()))
                    .withTrackingParams(performanceGroup.getTrackingParams());
        }
        if (internal instanceof GdiCpmBannerGroup) {
            GdiCpmBannerGroup gdiCpmBannerGroup = (GdiCpmBannerGroup) internal;
            if (campaignType == GdCampaignType.CPM_PRICE) {
                return new GdCpmPriceBannerAdGroup()
                        .withPriority(gdiCpmBannerGroup.getPriority())
                        .withForInBanner(gdiCpmBannerGroup.getForInBanner())
                        .withVideoGoals(mapList(((GdiCpmBannerGroup) internal).getUsersSegments(),
                                g -> GdVideoGoalType.fromSource(g.getType())))
                        .withCriterionType(GdCriterionType.fromSource(internal.getCriterionType()));
            }
            return new GdCpmBannerAdGroup()
                    .withForInBanner(gdiCpmBannerGroup.getForInBanner())
                    .withVideoGoals(mapList(((GdiCpmBannerGroup) internal).getUsersSegments(),
                            g -> GdVideoGoalType.fromSource(g.getType())))
                    .withCriterionType(GdCriterionType.fromSource(internal.getCriterionType()));
        }
        if (internal instanceof GdiCpmVideoGroup) {
            GdiCpmVideoGroup internalGroup = (GdiCpmVideoGroup) internal;

            if (campaignType == GdCampaignType.CPM_PRICE) {
                return new GdCpmPriceVideoAdGroup()
                        .withPriority(internalGroup.getPriority())
                        .withVideoGoals(mapList(((GdiCpmVideoGroup) internal).getUsersSegments(),
                                g -> GdVideoGoalType.fromSource(g.getType())))
                        .withCriterionType(GdCriterionType.fromSource(internal.getCriterionType()));
            }
            return new GdCpmVideoAdGroup()
                    .withIsNonSkippable(((GdiCpmVideoGroup) internal).getIsNonSkippable())
                    .withVideoGoals(mapList(((GdiCpmVideoGroup) internal).getUsersSegments(),
                            g -> GdVideoGoalType.fromSource(g.getType())))
                    .withCriterionType(GdCriterionType.fromSource(internal.getCriterionType()));
        }
        if (internal instanceof GdiCpmAudioGroup) {
            if (campaignType == GdCampaignType.CPM_PRICE) {
                return new GdCpmPriceAudioAdGroup()
                        .withPriority(((GdiCpmAudioGroup) internal).getPriority())
                        .withVideoGoals(mapList(((GdiCpmAudioGroup) internal).getUsersSegments(),
                                g -> GdVideoGoalType.fromSource(g.getType())));
            }
            return new GdCpmAudioAdGroup()
                    .withVideoGoals(mapList(((GdiCpmAudioGroup) internal).getUsersSegments(),
                            g -> GdVideoGoalType.fromSource(g.getType())));
        }
        if (internal instanceof GdiCpmIndoorGroup) {
            return new GdCpmIndoorAdGroup()
                    .withPageBlocks(mapList(((GdiCpmIndoorGroup) internal).getPageBlocks(),
                            p -> new GdAdGroupPageBlock().withImpId(p.getImpId()).withPageId(p.getPageId())))
                    .withVideoGoals(mapList(((GdiCpmIndoorGroup) internal).getUsersSegments(),
                            g -> GdVideoGoalType.fromSource(g.getType())));
        }
        if (internal instanceof GdiCpmOutdoorGroup) {
            return new GdCpmOutdoorAdGroup()
                    .withPageBlocks(mapList(((GdiCpmOutdoorGroup) internal).getPageBlocks(),
                            p -> new GdAdGroupPageBlock().withImpId(p.getImpId()).withPageId(p.getPageId())))
                    .withVideoGoals(mapList(((GdiCpmOutdoorGroup) internal).getUsersSegments(),
                            g -> GdVideoGoalType.fromSource(g.getType())));
        }
        if (internal instanceof GdiCpmGeoproductGroup) {
            return new GdCpmGeoproductAdGroup();
        }
        if (internal instanceof GdiCpmGeoPinGroup) {
            return new GdCpmGeoPinAdGroup();
        }
        if (internal instanceof GdiMcbannerGroup) {
            return new GdMcBannerAdGroup();
        }
        if (internal instanceof GdiInternalGroup) {
            GdiInternalGroup internalGroup = (GdiInternalGroup) internal;
            GdInternalAdGroup gdInternalAdGroup = new GdInternalAdGroup()
                    .withLevel(internalGroup.getLevel())
                    .withStartTime(internalGroup.getStartTime())
                    .withFinishTime(internalGroup.getFinishTime())
                    .withRf(internalGroup.getRf())
                    .withRfReset(internalGroup.getRfReset())
                    .withMaxClicksCount(internalGroup.getMaxClicksCount())
                    .withMaxClicksPeriod(toGdRfPeriod(internalGroup.getMaxClicksPeriod()))
                    .withMaxStopsCount(internalGroup.getMaxStopsCount())
                    .withMaxStopsPeriod(toGdRfPeriod(internalGroup.getMaxStopsPeriod()));
            var targetings = StreamEx.ofNullable(internalGroup.getTargetings())
                    .flatMap(List::stream)
                    .map(AdditionalTargetingConverter::convert)
                    .nonNull()
                    .toList();
            gdInternalAdGroup.withTargetings(targetings);
            return gdInternalAdGroup;
        }
        if (internal instanceof GdiContentPromotionGroup) {
            GdiContentPromotionGroup contentPromotionGroup = (GdiContentPromotionGroup) internal;
            GdiContentPromotionGroupType groupType = contentPromotionGroup.getContentPromotionGroupType();

            GdAdGroupType adGroupType = GdAdGroupType.valueOf(
                    format("%s_%s", contentPromotionGroup.getType(), groupType.name()));

            return new GdContentPromotionAdGroup()
                    .withType(adGroupType)
                    .withContentPromotionGroupType(GdContentPromotionGroupType.valueOf(groupType.name()));
        }
        if (internal instanceof GdiCpmYndxFrontpageGroup) {
            GdiCpmYndxFrontpageGroup internalGroup = (GdiCpmYndxFrontpageGroup) internal;
            if (campaignType == GdCampaignType.CPM_PRICE) {
                return new GdCpmPriceAdGroup()
                        .withPriority(internalGroup.getPriority());
            } else {
                return new GdCpmYndxFrontpageAdGroup();
            }
        }
        throw new IllegalArgumentException("Unknown internal group class :" + internal.getClass().getName());
    }

    private static GdAdGroupRegionsInfo getRegionsInfo(GdiAdGroupRegionsInfo internal) {
        return new GdAdGroupRegionsInfo()
                .withRegionIds(ListUtils.longToIntegerList(internal.getRegionIds()))
                .withEffectiveRegionIds(
                        ifNotNull(internal.getEffectiveRegionIds(), ListUtils::longToIntegerList)
                )
                .withRestrictedRegionIds(
                        ifNotNull(internal.getRestrictedRegionIds(), ListUtils::longToIntegerList)
                );
    }

    public static GroupsCacheRecordInfo toGroupsCacheRecordInfo(long clientId, GdAdGroupsContainer input) {
        return new GroupsCacheRecordInfo(clientId, input.getCacheKey(),
                new GroupsCacheFilterData()
                        .withFilter(input.getFilter())
                        .withOrderBy(input.getOrderBy())
                        .withStatRequirements(input.getStatRequirements()));
    }

    public static GdAdGroupsContext toGdAdGroupsContext(GdAdGroupWithTotals adGroupsWithTotals,
                                                        GdAdGroupFilter inputFilter,
                                                        boolean cpcAndCpmOnOneGridEnabled) {
        var rowsetFull = adGroupsWithTotals.getGdAdGroups();
        var totalStats = nvl(adGroupsWithTotals.getTotalStats(),
                calcTotalStats(mapList(rowsetFull, GdAdGroup::getStats)));

        if (cpcAndCpmOnOneGridEnabled) {
            Map<GdCampaignType, List<GdEntityStats>> campaignTypeToStats = StreamEx.of(rowsetFull)
                    .mapToEntry(gdAdGroup -> gdAdGroup.getCampaign().getType(), GdAdGroup::getStats)
                    .grouping();
            recalcTotalStatsForUnitedGrid(totalStats, campaignTypeToStats);
        }

        // показываем предупреждение если есть тоталы из БД и был фильтр по коду (либо мог быть)
        var totalStatsWithoutFiltersWarn = adGroupsWithTotals.getTotalStats() != null
                && (rowsetFull.size() < GridAdGroupConstants.getMaxGroupRows() || hasAnyCodeFilter(inputFilter));
        return new GdAdGroupsContext()
                .withTotalCount(rowsetFull.size())
                .withAdGroupIds(listToSet(rowsetFull, GdAdGroup::getId))
                .withFeatures(toGdAdGroupFeatures(rowsetFull))
                .withTotalStats(totalStats)
                .withTotalStatsWithoutFiltersWarn(totalStatsWithoutFiltersWarn)
                .withTotalGoalStats(calcTotalGoalStats(totalStats, mapList(rowsetFull, GdAdGroup::getGoalStats)));
    }

    /**
     * Присутствуют ли в фильтре поля, которые фильтруют группы в коде, а не в запросе к БД
     */
    private static boolean hasAnyCodeFilter(GdAdGroupFilter inputFilter) {
        return inputFilter.getArchived() != null
                || !isEmpty(inputFilter.getPrimaryStatusIn())
                || !isEmpty(inputFilter.getTagIdIn())
                || !isEmpty(inputFilter.getReasonsContainSome());
    }

    private static GdAdGroupFeatures toGdAdGroupFeatures(List<GdAdGroup> rowsetFull) {
        List<GdAdGroupAccess> gdAdGroupAccesses = mapList(rowsetFull, GdAdGroup::getAccess);
        int canBeSentToModerationByClientAdGroupsCount =
                getCountOfTrueBooleanValues(gdAdGroupAccesses, GdAdGroupAccess::getCanBeSentToModerationByClient);
        int canBeCopied = getCountOfTrueBooleanValues(gdAdGroupAccesses, GdAdGroupAccess::getCanCopy);
        int canBeEditedRegionsCount = getCountOfTrueBooleanValues(gdAdGroupAccesses,
                GdAdGroupAccess::getCanEditRegions);

        return new GdAdGroupFeatures()
                .withAdGroupAccesses(gdAdGroupAccesses)
                .withCanBeCopied(canBeCopied)
                .withCanBeEditedRegionsCount(canBeEditedRegionsCount)
                .withCanBeSentToModerationByClientAdGroupsCount(canBeSentToModerationByClientAdGroupsCount)
                .withHasAdGroupsOverLimit(rowsetFull.size() >= GridAdGroupConstants.getMaxGroupRows());
    }

    public static AdGroup toInternalGroup(GdAdGroup g) {
        AdGroup adGroup;
        if (g instanceof GdCpmBannerAdGroup) {
            GdCpmBannerAdGroup gdCpmBannerAdGroup = (GdCpmBannerAdGroup) g;
            adGroup = new CpmBannerAdGroup()
                    .withForInBanners(gdCpmBannerAdGroup.getForInBanner() == null ? false :
                            gdCpmBannerAdGroup.getForInBanner())
                    .withCriterionType(CriterionType.valueOf(((GdCpmBannerAdGroup) g).getCriterionType().name()));
        } else if (g instanceof GdCpmVideoAdGroup) {
            adGroup = new CpmVideoAdGroup()
                    .withIsNonSkippable(((GdCpmVideoAdGroup) g).getIsNonSkippable())
                    .withCriterionType(CriterionType.valueOf(((GdCpmVideoAdGroup) g).getCriterionType().name()));
        } else {
            adGroup = new AdGroup();
        }

        return adGroup
                .withId(g.getId())
                .withCampaignId(g.getCampaignId())
                .withType(toInternalAdGroupType(g.getType()))
                .withPageGroupTags(g.getPageGroupTags())
                .withTargetTags(g.getTargetTags());
    }

    public static GdiGroupFilter toInternalFilter(GdAdGroupFilter filter) {
        return new GdiGroupFilter()
                .withCampaignIdIn(filter.getCampaignIdIn())
                .withGroupIdIn(filter.getAdGroupIdIn())
                .withGroupIdNotIn(filter.getAdGroupIdNotIn())
                .withGroupIdContainsAny(filter.getAdGroupIdContainsAny())
                .withArchived(filter.getArchived())

                .withNameIn(filter.getNameIn())
                .withNameNotIn(filter.getNameNotIn())
                .withNameContains(filter.getNameContains())
                .withNameNotContains(filter.getNameNotContains())
                .withMwPackNameContains(filter.getMwPackNameContains())
                .withMwPackNameNotContains(filter.getMwPackNameNotContains())

                .withShowConditionTypeIn(mapSet(filter.getShowConditionTypeIn(), GdShowConditionType::toSource))
                .withTypeIn(mapSet(filter.getTypeIn(), AdGroupTypeConverter::toInternalAdGroupType))
                .withPrimaryStatusIn(mapSet(filter.getPrimaryStatusIn(), GdAdGroupPrimaryStatus::toSource))
                .withStats(StatHelper.toInternalStatsFilter(filter.getStats()))
                .withGoalStats(mapList(filter.getGoalStats(), StatHelper::toInternalGoalStatsFilter))
                .withLibraryMwIdIn(filter.getLibraryMwIdIn())
                .withReasonsContainSome(filter.getReasonsContainSome());
    }

    public static GdiGroupOrderBy toInternalOrderBy(GdAdGroupOrderBy orderBy) {
        return new GdiGroupOrderBy()
                .withOrder(orderBy.getOrder())
                .withField(GdAdGroupOrderByField.toSource(orderBy.getField()))
                .withGoalId(orderBy.getParams() == null ? null : orderBy.getParams().getGoalId());
    }

    private static GdMinusKeywordsPackInfo toGdMinusKeywordPack(GdiMinusKeywordsPackInfo gdiMinusKeywordsPackInfo) {
        return new GdMinusKeywordsPackInfo()
                .withId(gdiMinusKeywordsPackInfo.getId())
                .withName(gdiMinusKeywordsPackInfo.getName());
    }

    private static List<GdMobileContentPrices> toGdMobileContentPrices(List<GdiMobileContentPrices> mobileContentPrices) {
        return mapList(mobileContentPrices,
                price -> new GdMobileContentPrices()
                        .withCountry(price.getCountry())
                        .withPrice(price.getPrice())
                        .withPriceCurrency(price.getPriceCurrency())
                        .withStoreActionForPrices(GdStoreActionForPrices.fromSource(price.getStoreActionForPrices())));
    }

    @Nullable
    private static GdUpdateAdGroupRelevanceMatchItem toGdUpdateAdGroupRelevanceMatchItem(@Nullable GdiGroupRelevanceMatch relevanceMatch) {
        if (relevanceMatch == null) {
            return null;
        }
        return new GdUpdateAdGroupRelevanceMatchItem()
                .withId(relevanceMatch.getId())
                .withIsActive(relevanceMatch.getIsActive())
                .withRelevanceMatchCategories(mapSet(relevanceMatch.getRelevanceMatchCategories(), category
                        -> GdRelevanceMatchCategory.fromTypedValue(category.getTypedValue())));
    }
}
