package ru.yandex.direct.grid.processing.service.group.converter;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargeting;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingBrowserEngines;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingBrowserNames;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingCallerReferrers;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingClidTypes;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingClids;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingDesktopInstalledApps;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingDeviceIds;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingDeviceNames;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingDeviceVendors;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingFeaturesInPP;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingHasLCookie;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingHasPassportId;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingInterfaceLangs;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingInternalNetwork;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingIsDefaultYandexSearch;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingIsMobile;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingIsPPLoggedIn;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingIsTablet;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingIsTouch;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingIsVirused;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingIsYandexPlus;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingMobileInstalledApps;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingOsFamilies;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingOsNames;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingPlusUserSegments;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingQueryOptions;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingQueryReferers;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingSearchText;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingShowDates;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingSids;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingTestIds;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingTime;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingUatraits;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingUserAgents;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingUuids;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingVersioned;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingYandexUids;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingYandexuidAge;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingYpCookies;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingYsCookies;
import ru.yandex.direct.grid.model.campaign.timetarget.GdTimeTarget;
import ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargeting;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingBrowserEngines;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingBrowserNames;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingCallerReferrers;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingClidTypes;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingClids;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingDesktopInstalledApps;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingDeviceIds;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingDeviceNames;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingDeviceVendors;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingFeaturesInPP;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingHasLCookie;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingHasPassportId;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingInterfaceLangs;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingInternalNetwork;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingIsDefaultYandexSearch;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingIsMobile;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingIsPPLoggedIn;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingIsTablet;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingIsTouch;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingIsVirused;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingIsYandexPlus;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingJoinType;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingMobileInstalledApps;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingMode;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingOsFamilies;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingOsNames;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingPlusUserSegments;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingQueryOptions;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingQueryReferers;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingSearchText;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingShowDates;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingSids;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingTestIds;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingTime;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingUatraits;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingUserAgents;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingUuids;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingVersioned;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingYandexUids;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingYandexuidAge;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingYpCookies;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingYsCookies;
import ru.yandex.direct.libs.timetarget.TimeTarget;

import static com.google.common.base.Preconditions.checkState;
import static java.util.Map.entry;

@ParametersAreNonnullByDefault
public class AdditionalTargetingConverter {
    private static final Map<Class<?>, Function<GdiAdditionalTargeting, ? extends GdAdditionalTargeting>>
            CONVERTERS = Map.ofEntries(
            entry(
                    GdiAdditionalTargetingHasPassportId.class,
                    t -> convertGdTargeting(GdAdditionalTargetingHasPassportId::new, t)
            ),
            entry(
                    GdiAdditionalTargetingIsVirused.class,
                    t -> convertGdTargeting(GdAdditionalTargetingIsVirused::new, t)
            ),
            entry(
                    GdiAdditionalTargetingHasLCookie.class,
                    t -> convertGdTargeting(GdAdditionalTargetingHasLCookie::new, t)
            ),
            entry(
                    GdiAdditionalTargetingInternalNetwork.class,
                    t -> convertGdTargeting(GdAdditionalTargetingInternalNetwork::new, t)
            ),
            entry(
                    GdiAdditionalTargetingIsMobile.class,
                    t -> convertGdTargeting(GdAdditionalTargetingIsMobile::new, t)
            ),
            entry(
                    GdiAdditionalTargetingIsTablet.class,
                    t -> convertGdTargeting(GdAdditionalTargetingIsTablet::new, t)
            ),
            entry(
                    GdiAdditionalTargetingIsTouch.class,
                    t -> convertGdTargeting(GdAdditionalTargetingIsTouch::new, t)
            ),
            entry(
                    GdiAdditionalTargetingYandexuidAge.class,
                    t -> convertGdTargeting(GdAdditionalTargetingYandexuidAge::new, t)
                            .withValue(((GdiAdditionalTargetingYandexuidAge) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingYandexUids.class,
                    t -> convertGdTargeting(GdAdditionalTargetingYandexUids::new, t)
                            .withValue(((GdiAdditionalTargetingYandexUids) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingQueryReferers.class,
                    t -> convertGdTargeting(GdAdditionalTargetingQueryReferers::new, t)
                            .withValue(((GdiAdditionalTargetingQueryReferers) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingCallerReferrers.class,
                    t -> convertGdTargeting(GdAdditionalTargetingCallerReferrers::new, t)
                            .withValue(((GdiAdditionalTargetingCallerReferrers) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingInterfaceLangs.class,
                    t -> convertGdTargeting(GdAdditionalTargetingInterfaceLangs::new, t)
                            .withValue(((GdiAdditionalTargetingInterfaceLangs) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingUserAgents.class,
                    t -> convertGdTargeting(GdAdditionalTargetingUserAgents::new, t)
                            .withValue(((GdiAdditionalTargetingUserAgents) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingBrowserEngines.class,
                    t -> convertGdTargeting(GdAdditionalTargetingBrowserEngines::new, t)
                            .withValue(convertVersionedValue(((GdiAdditionalTargetingBrowserEngines) t).getValue()))
            ),
            entry(
                    GdiAdditionalTargetingBrowserNames.class,
                    t -> convertGdTargeting(GdAdditionalTargetingBrowserNames::new, t)
                            .withValue(convertVersionedValue(((GdiAdditionalTargetingBrowserNames) t).getValue()))
            ),
            entry(
                    GdiAdditionalTargetingOsFamilies.class,
                    t -> convertGdTargeting(GdAdditionalTargetingOsFamilies::new, t)
                            .withValue(convertVersionedValue(((GdiAdditionalTargetingOsFamilies) t).getValue()))
            ),
            entry(
                    GdiAdditionalTargetingOsNames.class,
                    t -> convertGdTargeting(GdAdditionalTargetingOsNames::new, t)
                            .withValue(convertUatraitsValue(((GdiAdditionalTargetingOsNames) t).getValue()))
            ),
            entry(
                    GdiAdditionalTargetingDeviceVendors.class,
                    t -> convertGdTargeting(GdAdditionalTargetingDeviceVendors::new, t)
                            .withValue(convertUatraitsValue(((GdiAdditionalTargetingDeviceVendors) t).getValue()))
            ),
            entry(
                    GdiAdditionalTargetingDeviceNames.class,
                    t -> convertGdTargeting(GdAdditionalTargetingDeviceNames::new, t)
                            .withValue(((GdiAdditionalTargetingDeviceNames) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingShowDates.class,
                    t -> convertGdTargeting(GdAdditionalTargetingShowDates::new, t)
                            .withValue(((GdiAdditionalTargetingShowDates) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingDesktopInstalledApps.class,
                    t -> convertGdTargeting(GdAdditionalTargetingDesktopInstalledApps::new, t)
                            .withValue(((GdiAdditionalTargetingDesktopInstalledApps) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingClidTypes.class,
                    t -> convertGdTargeting(GdAdditionalTargetingClidTypes::new, t)
                            .withValue(((GdiAdditionalTargetingClidTypes) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingClids.class,
                    t -> convertGdTargeting(GdAdditionalTargetingClids::new, t)
                            .withValue(((GdiAdditionalTargetingClids) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingQueryOptions.class,
                    t -> convertGdTargeting(GdAdditionalTargetingQueryOptions::new, t)
                            .withValue(((GdiAdditionalTargetingQueryOptions) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingTestIds.class,
                    t -> convertGdTargeting(GdAdditionalTargetingTestIds::new, t)
                            .withValue(((GdiAdditionalTargetingTestIds) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingYsCookies.class,
                    t -> convertGdTargeting(GdAdditionalTargetingYsCookies::new, t)
                            .withValue(((GdiAdditionalTargetingYsCookies) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingIsYandexPlus.class,
                    t -> convertGdTargeting(GdAdditionalTargetingIsYandexPlus::new, t)
            ),
            entry(
                    GdiAdditionalTargetingIsPPLoggedIn.class,
                    t -> convertGdTargeting(GdAdditionalTargetingIsPPLoggedIn::new, t)
            ),
            entry(
                    GdiAdditionalTargetingMobileInstalledApps.class,
                    t -> convertGdTargeting(GdAdditionalTargetingMobileInstalledApps::new, t)
                            .withValue(((GdiAdditionalTargetingMobileInstalledApps) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingFeaturesInPP.class,
                    t -> convertGdTargeting(GdAdditionalTargetingFeaturesInPP::new, t)
                            .withValue(((GdiAdditionalTargetingFeaturesInPP) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingYpCookies.class,
                    t -> convertGdTargeting(GdAdditionalTargetingYpCookies::new, t)
                            .withValue(((GdiAdditionalTargetingYpCookies) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingIsDefaultYandexSearch.class,
                    t -> convertGdTargeting(GdAdditionalTargetingIsDefaultYandexSearch::new, t)
            ),
            entry(
                    GdiAdditionalTargetingSids.class,
                    t -> convertGdTargeting(GdAdditionalTargetingSids::new, t)
                            .withValue(((GdiAdditionalTargetingSids) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingUuids.class,
                    t -> convertGdTargeting(GdAdditionalTargetingUuids::new, t)
                            .withValue(((GdiAdditionalTargetingUuids) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingDeviceIds.class,
                    t -> convertGdTargeting(GdAdditionalTargetingDeviceIds::new, t)
                            .withValue(((GdiAdditionalTargetingDeviceIds) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingPlusUserSegments.class,
                    t -> convertGdTargeting(GdAdditionalTargetingPlusUserSegments::new, t)
                            .withValue(((GdiAdditionalTargetingPlusUserSegments) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingSearchText.class,
                    t -> convertGdTargeting(GdAdditionalTargetingSearchText::new, t)
                            .withValue(((GdiAdditionalTargetingSearchText) t).getValue())
            ),
            entry(
                    GdiAdditionalTargetingTime.class,
                    t -> convertGdTargeting(GdAdditionalTargetingTime::new, t)
                            .withValue(convertTimeTarget(((GdiAdditionalTargetingTime) t).getValue()))
            )
    );

    private AdditionalTargetingConverter() {
    }

    private static <T extends GdAdditionalTargeting> T convertGdTargeting(
            Supplier<T> targetingCreator, GdiAdditionalTargeting targeting) {
        T gdTargeting = targetingCreator.get();
        gdTargeting
                .withTargetingMode(GdAdditionalTargetingMode.fromSource(targeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.fromSource(targeting.getJoinType()));
        return gdTargeting;
    }

    private static List<GdAdditionalTargetingVersioned> convertVersionedValue(List<GdiAdditionalTargetingVersioned> targeting) {
        return targeting.stream()
                .map(v -> new GdAdditionalTargetingVersioned()
                        .withTargetingValueEntryId(v.getTargetingValueEntryId())
                        .withMaxVersion(v.getMaxVersion())
                        .withMinVersion(v.getMinVersion()))
                .collect(Collectors.toList());
    }

    private static List<GdAdditionalTargetingUatraits> convertUatraitsValue(List<GdiAdditionalTargetingUatraits> targeting) {
        return targeting.stream()
                .map(v -> new GdAdditionalTargetingVersioned()
                        .withTargetingValueEntryId(v.getTargetingValueEntryId()))
                .collect(Collectors.toList());
    }

    private static GdTimeTarget convertTimeTarget(List<TimeTarget> targeting) {
        checkState(targeting.size() == 1);
        return CampaignDataConverter.toGdTimeTarget(targeting.get(0)).withIdTimeZone(-1L);
    }

    @Nullable
    public static GdAdditionalTargeting convert(GdiAdditionalTargeting targeting) {
        var converter = CONVERTERS.get(targeting.getClass());
        if (converter == null) {
            throw new IllegalArgumentException("Unknown targeting type: " + targeting.getClass());
        }
        return converter.apply(targeting);
    }
}
