package ru.yandex.direct.grid.processing.service.group.internalad

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.adgroup.model.InternalAdGroup
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.configuration.AdGroupAdditionalTargetingValueAccessor
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.configuration.AdGroupAdditionalTargetingsConfigurationProvider.getCollectionValueAccessorByTargetingClass
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.configuration.AdGroupAdditionalTargetingsConfigurationProvider.getValueAccessorByTargetingClass
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.CallerReferrersAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasPassportIdAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryReferersAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.TestIdsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UserAgentsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexUidsAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexuidAgeAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YpCookiesAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserName
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserNamesAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsFamiliesAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsFamily
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.VersionedTargeting
import ru.yandex.direct.grid.model.utils.RfConverter.toGdRfPeriod
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeBrowserNames
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeCallerReferrers
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeClids
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeFinishTime
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeHasPassportId
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeMaxClicksCount
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeMaxClicksPeriod
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeMaxStopsCount
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeMaxStopsPeriod
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeOsFamilies
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeQueryReferers
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeRf
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeRfReset
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeStartTime
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeTestIds
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeUserAgents
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeValue
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeYandexUids
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeYandexuidAge
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeYpCookies
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateBrowserNames
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateCallerReferrers
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateClids
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateFinishTime
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateHasPassportId
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateMaxClicksCount
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateMaxClicksPeriod
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateMaxStopsCount
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateMaxStopsPeriod
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateOsFamilies
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateQueryReferers
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateRf
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateRfReset
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateStartTime
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateTestIds
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateUserAgents
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateYandexUids
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateYandexuidAge
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateYpCookies
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingVersioned
import ru.yandex.direct.grid.processing.util.RfConverter.toCoreRfPeriod
import ru.yandex.direct.model.ModelProperty
import java.time.LocalDateTime
import kotlin.reflect.KClass
import kotlin.reflect.full.createInstance

typealias CoreAdditionalTargetingValue<VAL> = ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdditionalTargetingValue<VAL>

// Операции для полей InternalAdGroup
class SimpleInternalAdGroupFieldOperations<T>(
    val getter: (grp: InternalAdGroup) -> T?,
    val setter: (grp: InternalAdGroup, value: T?) -> Unit
) : InternalAdGroupFieldOperations<T> {

    constructor(modelProperty: ModelProperty<InternalAdGroup, T>) : this(modelProperty::get, modelProperty::set)

    override fun extract(obj: InternalAdGroupWithTargeting): List<T> {
        return getter(obj.adGroup)?.let { listOf(it) } ?: emptyList()
    }

    override fun remove(obj: InternalAdGroupWithTargeting, value: T) {
        setter(obj.adGroup, null)
    }

    override fun add(obj: InternalAdGroupWithTargeting, value: T) {
        setter(obj.adGroup, value)
    }
}

// Операции для таргетингов без поля value (boolean таргетинги)
open class AdditionalTargetingWithoutValueFieldOperations<TARG : AdGroupAdditionalTargeting>(
    private val targetingClass: Class<TARG>
) : InternalAdGroupTargetingOperations<Unit> {
    override fun extract(obj: InternalAdGroupWithTargeting): List<AdditionalTargetingValue<Unit>> {
        return obj.targetings[targetingClass.kotlin]
            .map { AdditionalTargetingValue(it.targetingMode, it.joinType, Unit) }
    }

    override fun add(obj: InternalAdGroupWithTargeting, value: AdditionalTargetingValue<Unit>) {
        if (obj.targetings[targetingClass.kotlin, value.targetingMode, value.joinType] == null) {
            val newTargeting = targetingClass.kotlin.createInstance().apply {
                targetingMode = value.targetingMode
                joinType = value.joinType
            }
            obj.targetings.store(newTargeting)
        }
    }

    override fun remove(obj: InternalAdGroupWithTargeting, value: AdditionalTargetingValue<Unit>) {
        val key = TargetingIndex.Key(
            targetingClass.kotlin, value.targetingMode, value.joinType
        )
        obj.targetings.erase(key)
    }
}

// Операции для таргетингов, у которых поле value - простое
// (value имеет тип CoreAdditionalTargetingValue<VAL>, является контейнером для одного значения типа VAL)
// Пример такого таргетинга - YandexuidAgeAdGroupAdditionalTargeting
open class AdditionalTargetingWithSimpleValueFieldOperations<TARG : AdGroupAdditionalTargeting, VAL>(
    private val targetingClass: Class<TARG>,
    private val targetingAccessor: AdGroupAdditionalTargetingValueAccessor<TARG, CoreAdditionalTargetingValue<VAL>> = getValueAccessorByTargetingClass(
        targetingClass,
        CoreAdditionalTargetingValue::class.java
    )!!,
) : InternalAdGroupTargetingOperations<VAL> {
    override fun extract(obj: InternalAdGroupWithTargeting): List<AdditionalTargetingValue<VAL>> {
        return obj.targetings[targetingClass.kotlin].map {
            AdditionalTargetingValue(
                it.targetingMode,
                it.joinType,
                targetingAccessor.getValue(it).value
            )
        }
    }

    override fun add(obj: InternalAdGroupWithTargeting, value: AdditionalTargetingValue<VAL>) {
        val newTargeting = targetingAccessor.newTargeting().apply {
            targetingMode = value.targetingMode
            joinType = value.joinType
        }
        targetingAccessor.setValue(newTargeting, CoreAdditionalTargetingValue<VAL>().withValue(value.innerValue))
        obj.targetings.store(newTargeting)
    }

    override fun remove(obj: InternalAdGroupWithTargeting, value: AdditionalTargetingValue<VAL>) {
        val key = TargetingIndex.Key(
            targetingClass.kotlin, value.targetingMode, value.joinType
        )
        obj.targetings.erase(key)
    }
}

// Абстрактный класс для таргетингов, у которых поле value имеет тип коллекции
abstract class AdditionalTargetingWithCollectionFieldOperations<TARG : AdGroupAdditionalTargeting, VAL, COL : MutableCollection<VAL>>(
    private val targetingClass: Class<TARG>,
    protected val targetingAccessor: AdGroupAdditionalTargetingValueAccessor<TARG, COL> = getCollectionValueAccessorByTargetingClass(
        targetingClass
    )!!,
) : InternalAdGroupTargetingOperations<VAL> {

    override fun extract(obj: InternalAdGroupWithTargeting): List<AdditionalTargetingValue<VAL>> {
        return obj.targetings[targetingClass.kotlin]
            .flatMap {
                targetingAccessor.getValue(it)
                    .map { v -> AdditionalTargetingValue(it.targetingMode, it.joinType, v) }
            }
    }

    override fun add(obj: InternalAdGroupWithTargeting, value: AdditionalTargetingValue<VAL>) {
        val curTargeting = obj.targetings[targetingClass.kotlin, value.targetingMode, value.joinType]
        val newTargeting = targetingAccessor.newTargeting().apply {
            targetingMode = value.targetingMode
            joinType = value.joinType
        }
        setNewTargetingValue(curTargeting, newTargeting, value.innerValue)
        obj.targetings.store(newTargeting)
    }

    abstract fun setNewTargetingValue(curTargeting: TARG?, newTargeting: TARG, newValue: VAL)

    override fun remove(obj: InternalAdGroupWithTargeting, value: AdditionalTargetingValue<VAL>) {
        val key = TargetingIndex.Key(targetingClass.kotlin, value.targetingMode, value.joinType)
        val targeting = obj.targetings[key] ?: return
        targetingAccessor.getValue(targeting).remove(value.innerValue)
        if (targetingAccessor.getValue(targeting).isEmpty()) {
            obj.targetings.erase(key)
        }
    }
}

open class AdditionalTargetingWithSetFieldOperations<TARG : AdGroupAdditionalTargeting, VAL>(
    targetingClass: Class<TARG>,
) : AdditionalTargetingWithCollectionFieldOperations<TARG, VAL, MutableSet<VAL>>(targetingClass) {

    override fun setNewTargetingValue(curTargeting: TARG?, newTargeting: TARG, newValue: VAL) {
        if (curTargeting == null) {
            targetingAccessor.setValue(newTargeting, mutableSetOf(newValue))
        } else {
            val curValue = targetingAccessor.getValue(curTargeting)
            targetingAccessor.setValue(newTargeting, (curValue + newValue) as MutableSet<VAL>)
        }
    }
}

open class AdditionalTargetingWithListFieldOperations<TARG : AdGroupAdditionalTargeting, VAL>(
    targetingClass: Class<TARG>,
) : AdditionalTargetingWithCollectionFieldOperations<TARG, VAL, MutableList<VAL>>(targetingClass) {

    override fun setNewTargetingValue(curTargeting: TARG?, newTargeting: TARG, newValue: VAL) {
        if (curTargeting == null) {
            targetingAccessor.setValue(newTargeting, mutableListOf(newValue))
        } else {
            val curValue = targetingAccessor.getValue(curTargeting)
            targetingAccessor.setValue(newTargeting, (curValue + newValue) as MutableList<VAL>)
        }
    }
}

object HasPassportIdFieldOperations :
    AdditionalTargetingWithoutValueFieldOperations<HasPassportIdAdGroupAdditionalTargeting>(
        HasPassportIdAdGroupAdditionalTargeting::class.java
    )

object YandexuidAgeFieldOperations :
    AdditionalTargetingWithSimpleValueFieldOperations<YandexuidAgeAdGroupAdditionalTargeting, Int>(
        YandexuidAgeAdGroupAdditionalTargeting::class.java
    )

object TestIdFieldOperations :
    AdditionalTargetingWithSetFieldOperations<TestIdsAdGroupAdditionalTargeting, Long>(
        TestIdsAdGroupAdditionalTargeting::class.java
    )

object ClidFieldOperations :
    AdditionalTargetingWithSetFieldOperations<ClidsAdGroupAdditionalTargeting, Long>(
        ClidsAdGroupAdditionalTargeting::class.java
    )

object YpCookieFieldOperations :
    AdditionalTargetingWithSetFieldOperations<YpCookiesAdGroupAdditionalTargeting, String>(
        YpCookiesAdGroupAdditionalTargeting::class.java
    )

object QueryRefererFieldOperations :
    AdditionalTargetingWithListFieldOperations<QueryReferersAdGroupAdditionalTargeting, String>(
        QueryReferersAdGroupAdditionalTargeting::class.java
    )

object CallerReferrerFieldOperations :
    AdditionalTargetingWithListFieldOperations<CallerReferrersAdGroupAdditionalTargeting, String>(
        CallerReferrersAdGroupAdditionalTargeting::class.java
    )

object UserAgentFieldOperations :
    AdditionalTargetingWithListFieldOperations<UserAgentsAdGroupAdditionalTargeting, String>(
        UserAgentsAdGroupAdditionalTargeting::class.java
    )

object YandexUidFieldOperations :
    AdditionalTargetingWithListFieldOperations<YandexUidsAdGroupAdditionalTargeting, String>(
        YandexUidsAdGroupAdditionalTargeting::class.java
    )

object OsFamilyFieldOperations :
    AdditionalTargetingWithListFieldOperations<OsFamiliesAdGroupAdditionalTargeting, OsFamily>(
        OsFamiliesAdGroupAdditionalTargeting::class.java
    )

object BrowserNameFieldOperations :
    AdditionalTargetingWithListFieldOperations<BrowserNamesAdGroupAdditionalTargeting, BrowserName>(
        BrowserNamesAdGroupAdditionalTargeting::class.java
    )

@Component
class StartTimeMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<LocalDateTime> {
    override val operations = SimpleInternalAdGroupFieldOperations(InternalAdGroup.START_TIME)

    override fun convertToGdFieldState(value: LocalDateTime) =
        GdInternalAdGroupFieldStateStartTime().apply {
            startTime = value
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeStartTime -> input.innerValue
            else -> null
        }
}

@Component
class FinishTimeMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<LocalDateTime> {
    override val operations = SimpleInternalAdGroupFieldOperations(InternalAdGroup.FINISH_TIME)

    override fun convertToGdFieldState(value: LocalDateTime) =
        GdInternalAdGroupFieldStateFinishTime().apply {
            finishTime = value
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeFinishTime -> input.innerValue
            else -> null
        }
}

@Component
class RfMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<Int> {
    override val operations = SimpleInternalAdGroupFieldOperations(InternalAdGroup.RF)

    override fun convertToGdFieldState(value: Int) =
        GdInternalAdGroupFieldStateRf().apply {
            rf = value
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeRf -> input.innerValue
            else -> null
        }
}

@Component
class RfResetMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<Int> {
    override val operations = SimpleInternalAdGroupFieldOperations(InternalAdGroup.RF_RESET)

    override fun convertToGdFieldState(value: Int) =
        GdInternalAdGroupFieldStateRfReset().apply {
            rfReset = value
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeRfReset -> input.innerValue
            else -> null
        }
}

@Component
class MaxClicksCountMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<Int> {
    override val operations = SimpleInternalAdGroupFieldOperations(InternalAdGroup.MAX_CLICKS_COUNT)

    override fun convertToGdFieldState(value: Int) =
        GdInternalAdGroupFieldStateMaxClicksCount().apply {
            maxClicksCount = value
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeMaxClicksCount -> input.innerValue
            else -> null
        }
}

@Component
class MaxClicksPeriodMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<Int> {
    override val operations = SimpleInternalAdGroupFieldOperations(InternalAdGroup.MAX_CLICKS_PERIOD)

    override fun convertToGdFieldState(value: Int) =
        GdInternalAdGroupFieldStateMaxClicksPeriod().apply {
            maxClicksPeriod = toGdRfPeriod(value)
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeMaxClicksPeriod -> toCoreRfPeriod(input.innerValue)
            else -> null
        }
}

@Component
class MaxStopsCountMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<Int> {
    override val operations = SimpleInternalAdGroupFieldOperations(InternalAdGroup.MAX_STOPS_COUNT)

    override fun convertToGdFieldState(value: Int) =
        GdInternalAdGroupFieldStateMaxStopsCount().apply {
            maxStopsCount = value
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeMaxStopsCount -> input.innerValue
            else -> null
        }
}

@Component
class MaxStopsPeriodMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<Int> {
    override val operations = SimpleInternalAdGroupFieldOperations(InternalAdGroup.MAX_STOPS_PERIOD)

    override fun convertToGdFieldState(value: Int) =
        GdInternalAdGroupFieldStateMaxStopsPeriod().apply {
            maxStopsPeriod = toGdRfPeriod(value)
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeMaxStopsPeriod -> toCoreRfPeriod(input.innerValue)
            else -> null
        }
}

@Component
class YandexuidAgeMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<AdditionalTargetingValue<Int>> {
    override val operations = YandexuidAgeFieldOperations

    override fun convertToGdFieldState(value: AdditionalTargetingValue<Int>) =
        GdInternalAdGroupFieldStateYandexuidAge().apply {
            targetingMode = value.targetingMode.toGdEnum()
            joinType = value.joinType.toGdEnum()
            yandexuidAge = value.innerValue
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeYandexuidAge -> AdditionalTargetingValue(
                input.targetingMode.toCoreEnum()!!, input.joinType.toCoreEnum()!!, input.innerValue
            )
            else -> null
        }
}

@Component
class TestIdsMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<AdditionalTargetingValue<Long>> {
    override val operations = TestIdFieldOperations

    override fun convertToGdFieldState(value: AdditionalTargetingValue<Long>) =
        GdInternalAdGroupFieldStateTestIds().apply {
            targetingMode = value.targetingMode.toGdEnum()
            joinType = value.joinType.toGdEnum()
            testId = value.innerValue
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeTestIds -> AdditionalTargetingValue(
                input.targetingMode.toCoreEnum()!!, input.joinType.toCoreEnum()!!, input.innerValue
            )
            else -> null
        }
}

@Component
class ClidsMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<AdditionalTargetingValue<Long>> {
    override val operations = ClidFieldOperations

    override fun convertToGdFieldState(value: AdditionalTargetingValue<Long>) =
        GdInternalAdGroupFieldStateClids().apply {
            targetingMode = value.targetingMode.toGdEnum()
            joinType = value.joinType.toGdEnum()
            clid = value.innerValue
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeClids -> AdditionalTargetingValue(
                input.targetingMode.toCoreEnum()!!, input.joinType.toCoreEnum()!!, input.innerValue
            )
            else -> null
        }
}

@Component
class QueryReferersMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<AdditionalTargetingValue<String>> {
    override val operations = QueryRefererFieldOperations

    override fun convertToGdFieldState(value: AdditionalTargetingValue<String>) =
        GdInternalAdGroupFieldStateQueryReferers().apply {
            targetingMode = value.targetingMode.toGdEnum()
            joinType = value.joinType.toGdEnum()
            queryReferer = value.innerValue
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeQueryReferers -> AdditionalTargetingValue(
                input.targetingMode.toCoreEnum()!!, input.joinType.toCoreEnum()!!, input.innerValue
            )
            else -> null
        }
}

@Component
class CallerReferrersMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<AdditionalTargetingValue<String>> {
    override val operations = CallerReferrerFieldOperations

    override fun convertToGdFieldState(value: AdditionalTargetingValue<String>) =
        GdInternalAdGroupFieldStateCallerReferrers().apply {
            targetingMode = value.targetingMode.toGdEnum()
            joinType = value.joinType.toGdEnum()
            callerReferrer = value.innerValue
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeCallerReferrers -> AdditionalTargetingValue(
                input.targetingMode.toCoreEnum()!!, input.joinType.toCoreEnum()!!, input.innerValue
            )
            else -> null
        }
}

@Component
class UserAgentsMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<AdditionalTargetingValue<String>> {
    override val operations = UserAgentFieldOperations

    override fun convertToGdFieldState(value: AdditionalTargetingValue<String>) =
        GdInternalAdGroupFieldStateUserAgents().apply {
            targetingMode = value.targetingMode.toGdEnum()
            joinType = value.joinType.toGdEnum()
            userAgent = value.innerValue
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeUserAgents -> AdditionalTargetingValue(
                input.targetingMode.toCoreEnum()!!, input.joinType.toCoreEnum()!!, input.innerValue
            )
            else -> null
        }
}

@Component
class YandexUidsMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<AdditionalTargetingValue<String>> {
    override val operations = YandexUidFieldOperations

    override fun convertToGdFieldState(value: AdditionalTargetingValue<String>) =
        GdInternalAdGroupFieldStateYandexUids().apply {
            targetingMode = value.targetingMode.toGdEnum()
            joinType = value.joinType.toGdEnum()
            yandexUid = value.innerValue
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeYandexUids -> AdditionalTargetingValue(
                input.targetingMode.toCoreEnum()!!, input.joinType.toCoreEnum()!!, input.innerValue
            )
            else -> null
        }
}

@Component
class YpCookiesMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<AdditionalTargetingValue<String>> {
    override val operations = YpCookieFieldOperations

    override fun convertToGdFieldState(value: AdditionalTargetingValue<String>) =
        GdInternalAdGroupFieldStateYpCookies().apply {
            targetingMode = value.targetingMode.toGdEnum()
            joinType = value.joinType.toGdEnum()
            ypCookie = value.innerValue
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeYpCookies -> AdditionalTargetingValue(
                input.targetingMode.toCoreEnum()!!, input.joinType.toCoreEnum()!!, input.innerValue
            )
            else -> null
        }
}

@Component
class OsFamiliesMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<AdditionalTargetingValue<OsFamily>> {
    override val operations = OsFamilyFieldOperations

    override fun convertToGdFieldState(value: AdditionalTargetingValue<OsFamily>) =
        GdInternalAdGroupFieldStateOsFamilies().apply {
            targetingMode = value.targetingMode.toGdEnum()
            joinType = value.joinType.toGdEnum()
            osFamily = convertCoreVersionedTargetingToGdVersionedTargeting(value.innerValue)
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeOsFamilies -> AdditionalTargetingValue(
                input.targetingMode.toCoreEnum()!!,
                input.joinType.toCoreEnum()!!,
                convertGdVersionedTargetingToCoreVersionedTargeting(OsFamily::class, input.innerValue)
            )
            else -> null
        }
}

@Component
class BrowserNamesMassUpdateFieldSupport :
    InternalAdGroupMassUpdateFieldSupport<AdditionalTargetingValue<BrowserName>> {
    override val operations = BrowserNameFieldOperations

    override fun convertToGdFieldState(value: AdditionalTargetingValue<BrowserName>) =
        GdInternalAdGroupFieldStateBrowserNames().apply {
            targetingMode = value.targetingMode.toGdEnum()
            joinType = value.joinType.toGdEnum()
            browserName = convertCoreVersionedTargetingToGdVersionedTargeting(value.innerValue)
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeBrowserNames -> AdditionalTargetingValue(
                input.targetingMode.toCoreEnum()!!,
                input.joinType.toCoreEnum()!!,
                convertGdVersionedTargetingToCoreVersionedTargeting(BrowserName::class, input.innerValue)
            )
            else -> null
        }
}

@Component
class HasPassportIdMassUpdateFieldSupport : InternalAdGroupMassUpdateFieldSupport<AdditionalTargetingValue<Unit>> {
    override val operations = HasPassportIdFieldOperations

    override fun convertToGdFieldState(value: AdditionalTargetingValue<Unit>) =
        GdInternalAdGroupFieldStateHasPassportId().apply {
            targetingMode = value.targetingMode.toGdEnum()
            joinType = value.joinType.toGdEnum()
        }

    override fun extractInputInnerValue(input: GdInternalAdGroupFieldChangeValue<Any>) =
        when (input) {
            is GdInternalAdGroupFieldChangeHasPassportId -> AdditionalTargetingValue(
                input.targetingMode.toCoreEnum()!!, input.joinType.toCoreEnum()!!, Unit
            )
            else -> null
        }
}

private fun <T : VersionedTargeting> convertCoreVersionedTargetingToGdVersionedTargeting(coreTargeting: T) =
    GdAdditionalTargetingVersioned().apply {
        targetingValueEntryId = coreTargeting.targetingValueEntryId
        minVersion = coreTargeting.minVersion
        maxVersion = coreTargeting.maxVersion
    }

private fun <T : VersionedTargeting> convertGdVersionedTargetingToCoreVersionedTargeting(
    coreTargetingClass: KClass<T>,
    gdTargeting: GdAdditionalTargetingVersioned
) = coreTargetingClass.createInstance().apply {
    targetingValueEntryId = gdTargeting.targetingValueEntryId
    minVersion = gdTargeting.minVersion
    maxVersion = gdTargeting.maxVersion
}
