package ru.yandex.direct.grid.processing.service.group.internalad

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargetingJoinType
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargetingMode
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeValue
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldChangeValueUnion
import ru.yandex.direct.grid.processing.model.group.GdInternalAdGroupFieldStateValue
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingJoinType
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingMode
import ru.yandex.direct.grid.processing.service.internalad.FieldOperations
import ru.yandex.direct.grid.processing.service.internalad.MassUpdateFieldSupport


interface InternalAdGroupFieldOperations<V> : FieldOperations<V, InternalAdGroupWithTargeting>

interface InternalAdGroupTargetingOperations<V> : InternalAdGroupFieldOperations<AdditionalTargetingValue<V>>

interface InternalAdGroupMassUpdateFieldSupport<V> : MassUpdateFieldSupport<InternalAdGroupWithTargeting, V, GdInternalAdGroupFieldStateValue, GdInternalAdGroupFieldChangeValue<Any>>

/**
 * Содержит одно из значений additional targeting
 * @param[VAL] Класс для значения в additional targeting
 */
data class AdditionalTargetingValue<VAL>(
    val targetingMode: AdGroupAdditionalTargetingMode,
    val joinType: AdGroupAdditionalTargetingJoinType,
    val innerValue: VAL,
)

fun AdGroupAdditionalTargetingMode.toGdEnum() = GdAdditionalTargetingMode.fromSource(this)

fun AdGroupAdditionalTargetingJoinType.toGdEnum() = GdAdditionalTargetingJoinType.fromSource(this)

fun GdAdditionalTargetingMode.toCoreEnum() = GdAdditionalTargetingMode.toSource(this)

fun GdAdditionalTargetingJoinType.toCoreEnum() = GdAdditionalTargetingJoinType.toSource(this)

fun GdInternalAdGroupFieldChangeValueUnion.getSingleValueFromUnion(): GdInternalAdGroupFieldChangeValue<Any> {
    return GdInternalAdGroupFieldChangeValueUnion.allModelProperties()
        .mapNotNull { it.getRaw(this) }
        .filterIsInstance<GdInternalAdGroupFieldChangeValue<Any>>()
        .single()
}
