package ru.yandex.direct.grid.processing.service.group.loader;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

import one.util.streamex.StreamEx;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.processing.context.container.GridGraphQLContext;
import ru.yandex.direct.grid.processing.model.banner.GdAd;
import ru.yandex.direct.grid.processing.model.client.GdClientInfo;
import ru.yandex.direct.grid.processing.model.group.GdAdGroupTruncated;
import ru.yandex.direct.grid.processing.service.banner.BannerDataService;
import ru.yandex.direct.grid.processing.service.dataloader.GridBatchingDataLoader;
import ru.yandex.direct.grid.processing.service.dataloader.GridContextProvider;

@Component
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class AdGroupsMainAdDataLoader extends GridBatchingDataLoader<GdAdGroupTruncated, GdAd> {
    public AdGroupsMainAdDataLoader(
            GridContextProvider gridContextProvider,
            BannerDataService bannerDataService) {
        dataLoader = mappedDataLoader(gridContextProvider, (adGroups, environment) -> {
            GridGraphQLContext context = environment.getContext();

            GdClientInfo client = context.getQueriedClient();
            Integer shard = client.getShard();
            ClientId clientId = ClientId.fromLong(client.getId());

            // spqr не присылает дважды одну и ту же группу, поэтому не делаем distinctKeys()
            Map<Long, GdAdGroupTruncated> adGroupsById =
                    StreamEx.of(adGroups)
                            .mapToEntry(GdAdGroupTruncated::getId, Function.identity())
                            .toMap();
            Map<Long, GdAd> mainBanners = bannerDataService.getMainBanners(shard, clientId, adGroupsById);
            Map<GdAdGroupTruncated, GdAd> result = StreamEx.of(adGroups)
                    .mapToEntry(GdAdGroupTruncated::getId)
                    .mapValues(mainBanners::get)
                    .nonNullValues()
                    .toMap();
            return CompletableFuture.completedFuture(result);
        });
    }

}
