package ru.yandex.direct.grid.processing.service.group.mutation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.adgroup.container.InternalAdGroupAddItem;
import ru.yandex.direct.core.entity.adgroup.container.InternalAdGroupUpdateItem;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.InternalAdGroup;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdditionalTargetingValue;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.CallerReferrersAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidTypesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.DesktopInstalledAppsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.DeviceIdsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.FeaturesInPPAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasLCookieAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasPassportIdAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InterfaceLangsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InternalNetworkAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsDefaultYandexSearchAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsPPLoggedInAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsVirusedAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsYandexPlusAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.MobileInstalledApp;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.MobileInstalledAppsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.PlusUserSegmentsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryOptionsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryReferersAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.SearchTextAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ShowDatesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.SidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.TestIdsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.TimeAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UserAgentsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UuidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexUidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexuidAgeAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YpCookiesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YsCookiesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserEngine;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserEnginesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserName;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceVendor;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceVendorsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsMobileAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsTabletAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsTouchAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsFamiliesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsFamily;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsName;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionBase;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingJoinType;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.GdAdditionalTargetingMode;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingBrowserEnginesRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingBrowserNamesRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingCallerReferrersRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingClidTypesRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingClidsRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingDesktopInstalledAppsRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingDeviceIdsRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingDeviceNamesRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingDeviceVendorsRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingFeaturesInPPRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingHasLCookieRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingHasPassportIdRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingInterfaceLangsRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingInternalNetworkRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingIsDefaultYandexSearchRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingIsMobileRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingIsPPLoggedInRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingIsTabletRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingIsTouchRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingIsVirusedRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingIsYandexPlusRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingMobileInstalledAppsRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingOsFamiliesRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingOsNamesRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingPlusUserSegmentsRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingQueryOptionsRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingQueryReferersRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingSearchTextRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingShowDatesRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingSidsRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingTestIdsRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingTimeRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingUnion;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingUserAgentsRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingUuidsRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingYandexUidsRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingYandexuidAgeRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingYpCookiesRequest;
import ru.yandex.direct.grid.processing.model.group.additionaltargeting.mutation.GdAdditionalTargetingYsCookiesRequest;
import ru.yandex.direct.grid.processing.model.group.mutation.GdAddInternalAdGroupsItem;
import ru.yandex.direct.grid.processing.model.group.mutation.GdUpdateInternalAdGroupsItem;
import ru.yandex.direct.grid.processing.model.retargeting.mutation.GdUpdateInternalAdRetargetingConditionItem;
import ru.yandex.direct.grid.processing.service.showcondition.converter.RetargetingConverter;
import ru.yandex.direct.model.ModelChanges;

import static com.google.common.base.Preconditions.checkNotNull;
import static java.util.Map.entry;
import static one.util.streamex.MoreCollectors.onlyOne;
import static ru.yandex.direct.core.entity.retargeting.model.ConditionType.interests;
import static ru.yandex.direct.grid.model.entity.campaign.converter.CampaignDataConverter.toTimeTarget;
import static ru.yandex.direct.grid.processing.util.RfConverter.toCoreRfPeriod;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.utils.ListUtils.integerToLongList;

@ParametersAreNonnullByDefault
class GdInternalGroupConverters {
    private static final Map<Class<?>, Function<GdAdditionalTargetingRequest, ? extends AdGroupAdditionalTargeting>>
            TYPE_TO_CONVERTER = Map.ofEntries(
            entry(GdAdditionalTargetingHasPassportIdRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingHasPassportIdRequest) targeting)),
            entry(GdAdditionalTargetingIsVirusedRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingIsVirusedRequest) targeting)),
            entry(GdAdditionalTargetingHasLCookieRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingHasLCookieRequest) targeting)),
            entry(GdAdditionalTargetingInternalNetworkRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingInternalNetworkRequest) targeting)),
            entry(GdAdditionalTargetingIsMobileRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingIsMobileRequest) targeting)),
            entry(GdAdditionalTargetingIsTabletRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingIsTabletRequest) targeting)),
            entry(GdAdditionalTargetingIsTouchRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingIsTouchRequest) targeting)),
            entry(GdAdditionalTargetingYandexuidAgeRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingYandexuidAgeRequest) targeting)),
            entry(GdAdditionalTargetingYandexUidsRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingYandexUidsRequest) targeting)),
            entry(GdAdditionalTargetingQueryReferersRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingQueryReferersRequest) targeting)),
            entry(GdAdditionalTargetingCallerReferrersRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingCallerReferrersRequest) targeting)),
            entry(GdAdditionalTargetingInterfaceLangsRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingInterfaceLangsRequest) targeting)),
            entry(GdAdditionalTargetingUserAgentsRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingUserAgentsRequest) targeting)),
            entry(GdAdditionalTargetingBrowserEnginesRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingBrowserEnginesRequest) targeting)),
            entry(GdAdditionalTargetingBrowserNamesRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingBrowserNamesRequest) targeting)),
            entry(GdAdditionalTargetingOsFamiliesRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingOsFamiliesRequest) targeting)),
            entry(GdAdditionalTargetingOsNamesRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingOsNamesRequest) targeting)),
            entry(GdAdditionalTargetingDeviceVendorsRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingDeviceVendorsRequest) targeting)),
            entry(GdAdditionalTargetingDeviceNamesRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingDeviceNamesRequest) targeting)),
            entry(GdAdditionalTargetingShowDatesRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingShowDatesRequest) targeting)),
            entry(GdAdditionalTargetingDesktopInstalledAppsRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingDesktopInstalledAppsRequest) targeting)),
            entry(GdAdditionalTargetingClidTypesRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingClidTypesRequest) targeting)),
            entry(GdAdditionalTargetingClidsRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingClidsRequest) targeting)),
            entry(GdAdditionalTargetingQueryOptionsRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingQueryOptionsRequest) targeting)),
            entry(GdAdditionalTargetingTestIdsRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingTestIdsRequest) targeting)),
            entry(GdAdditionalTargetingYsCookiesRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingYsCookiesRequest) targeting)),
            entry(GdAdditionalTargetingIsYandexPlusRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingIsYandexPlusRequest) targeting)),
            entry(GdAdditionalTargetingIsPPLoggedInRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingIsPPLoggedInRequest) targeting)),
            entry(GdAdditionalTargetingMobileInstalledAppsRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingMobileInstalledAppsRequest) targeting)),
            entry(GdAdditionalTargetingFeaturesInPPRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingFeaturesInPPRequest) targeting)),
            entry(GdAdditionalTargetingYpCookiesRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingYpCookiesRequest) targeting)),
            entry(GdAdditionalTargetingIsDefaultYandexSearchRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingIsDefaultYandexSearchRequest) targeting)),
            entry(GdAdditionalTargetingSidsRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingSidsRequest) targeting)),
            entry(GdAdditionalTargetingUuidsRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingUuidsRequest) targeting)),
            entry(GdAdditionalTargetingDeviceIdsRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingDeviceIdsRequest) targeting)),
            entry(GdAdditionalTargetingPlusUserSegmentsRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingPlusUserSegmentsRequest) targeting)),
            entry(GdAdditionalTargetingSearchTextRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingSearchTextRequest) targeting)),
            entry(GdAdditionalTargetingTimeRequest.class,
                    targeting -> toCoreTargeting((GdAdditionalTargetingTimeRequest) targeting))
    );
    public static final String DEFAULT_RETARGETING_CONDITION_NAME = "Аудитория для внутренней рекламы";

    private GdInternalGroupConverters() {
    }

    private static HasPassportIdAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingHasPassportIdRequest gdTargeting) {
        return new HasPassportIdAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()));
    }

    private static IsVirusedAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingIsVirusedRequest gdTargeting) {
        return new IsVirusedAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()));
    }

    private static HasLCookieAdGroupAdditionalTargeting toCoreTargeting(GdAdditionalTargetingHasLCookieRequest gdTargeting) {
        return new HasLCookieAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()));
    }

    private static InternalNetworkAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingInternalNetworkRequest gdTargeting) {
        return new InternalNetworkAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()));
    }

    private static IsMobileAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingIsMobileRequest gdTargeting) {
        return new IsMobileAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()));
    }

    private static IsTabletAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingIsTabletRequest gdTargeting) {
        return new IsTabletAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()));
    }

    private static IsTouchAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingIsTouchRequest gdTargeting) {
        return new IsTouchAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()));
    }

    private static YandexuidAgeAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingYandexuidAgeRequest gdTargeting) {
        return new YandexuidAgeAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(AdditionalTargetingValue.of(checkNotNull(gdTargeting.getValue())));
    }

    private static YandexUidsAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingYandexUidsRequest gdTargeting) {
        return new YandexUidsAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static QueryReferersAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingQueryReferersRequest gdTargeting) {
        return new QueryReferersAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static CallerReferrersAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingCallerReferrersRequest gdTargeting) {
        return new CallerReferrersAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static InterfaceLangsAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingInterfaceLangsRequest gdTargeting) {
        return new InterfaceLangsAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static UserAgentsAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingUserAgentsRequest gdTargeting) {
        return new UserAgentsAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static BrowserEnginesAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingBrowserEnginesRequest gdTargeting) {
        return new BrowserEnginesAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue().stream()
                        .map(v -> new BrowserEngine()
                                .withTargetingValueEntryId(v.getTargetingValueEntryId())
                                .withMaxVersion(v.getMaxVersion())
                                .withMinVersion(v.getMinVersion()))
                        .collect(Collectors.toList())));
    }

    private static BrowserNamesAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingBrowserNamesRequest gdTargeting) {
        return new BrowserNamesAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue().stream()
                        .map(v -> new BrowserName()
                                .withTargetingValueEntryId(v.getTargetingValueEntryId())
                                .withMaxVersion(v.getMaxVersion())
                                .withMinVersion(v.getMinVersion()))
                        .collect(Collectors.toList())));
    }

    private static OsFamiliesAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingOsFamiliesRequest gdTargeting) {
        return new OsFamiliesAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue().stream()
                        .map(v -> new OsFamily()
                                .withTargetingValueEntryId(v.getTargetingValueEntryId())
                                .withMaxVersion(v.getMaxVersion())
                                .withMinVersion(v.getMinVersion()))
                        .collect(Collectors.toList())));
    }

    private static OsNamesAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingOsNamesRequest gdTargeting) {
        return new OsNamesAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue().stream()
                        .map(v -> new OsName().withTargetingValueEntryId(v.getTargetingValueEntryId()))
                        .collect(Collectors.toList())));
    }

    private static DeviceNamesAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingDeviceNamesRequest gdTargeting) {
        return new DeviceNamesAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static DeviceVendorsAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingDeviceVendorsRequest gdTargeting) {
        return new DeviceVendorsAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue().stream()
                        .map(v -> new DeviceVendor().withTargetingValueEntryId(v.getTargetingValueEntryId()))
                        .collect(Collectors.toList())));
    }

    private static ShowDatesAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingShowDatesRequest gdTargeting) {
        return new ShowDatesAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static DesktopInstalledAppsAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingDesktopInstalledAppsRequest gdTargeting) {
        return new DesktopInstalledAppsAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static ClidTypesAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingClidTypesRequest gdTargeting) {
        return new ClidTypesAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static ClidsAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingClidsRequest gdTargeting) {
        return new ClidsAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static QueryOptionsAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingQueryOptionsRequest gdTargeting) {
        return new QueryOptionsAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static TestIdsAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingTestIdsRequest gdTargeting) {
        return new TestIdsAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static YsCookiesAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingYsCookiesRequest gdTargeting) {
        return new YsCookiesAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static IsYandexPlusAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingIsYandexPlusRequest gdTargeting) {
        return new IsYandexPlusAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()));
    }

    private static IsPPLoggedInAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingIsPPLoggedInRequest gdTargeting) {
        return new IsPPLoggedInAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()));
    }

    private static MobileInstalledAppsAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingMobileInstalledAppsRequest gdTargeting) {
        return new MobileInstalledAppsAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(StreamEx.of(checkNotNull(gdTargeting.getValue()))
                        .map(url -> new MobileInstalledApp().withStoreUrl(url)).toImmutableSet());
    }

    private static YpCookiesAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingYpCookiesRequest gdTargeting) {
        return new YpCookiesAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static FeaturesInPPAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingFeaturesInPPRequest gdTargeting) {
        return new FeaturesInPPAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static IsDefaultYandexSearchAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingIsDefaultYandexSearchRequest gdTargeting) {
        return new IsDefaultYandexSearchAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()));
    }

    private static SidsAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingSidsRequest gdTargeting) {
        return new SidsAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static UuidsAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingUuidsRequest gdTargeting) {
        return new UuidsAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static DeviceIdsAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingDeviceIdsRequest gdTargeting) {
        return new DeviceIdsAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static PlusUserSegmentsAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingPlusUserSegmentsRequest gdTargeting) {
        return new PlusUserSegmentsAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static SearchTextAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingSearchTextRequest gdTargeting) {
        return new SearchTextAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(checkNotNull(gdTargeting.getValue()));
    }

    private static TimeAdGroupAdditionalTargeting toCoreTargeting(
            GdAdditionalTargetingTimeRequest gdTargeting) {
        return new TimeAdGroupAdditionalTargeting()
                .withTargetingMode(GdAdditionalTargetingMode.toSource(gdTargeting.getTargetingMode()))
                .withJoinType(GdAdditionalTargetingJoinType.toSource(gdTargeting.getJoinType()))
                .withValue(List.of(toTimeTarget(checkNotNull(gdTargeting.getValue()))));
    }

    static InternalAdGroupUpdateItem toCoreUpdateItem(ClientId clientId, GdUpdateInternalAdGroupsItem item) {
        return new InternalAdGroupUpdateItem()
                .withAdGroupChanges(toInternalAdGroupChanges(item))
                .withAdditionalTargetings(toCoreTargetingList(item.getTargetings()))
                .withRetargetingConditions(convertRetargetingConditions(clientId, item.getRetargetingConditions()));
    }

    static InternalAdGroupAddItem toCoreAddItem(ClientId clientId, GdAddInternalAdGroupsItem item) {
        return new InternalAdGroupAddItem()
                .withAdGroup(toInternalAdGroup(item))
                .withAdditionalTargetings(toCoreTargetingList(item.getTargetings()))
                .withRetargetingConditions(convertRetargetingConditions(clientId, item.getRetargetingConditions()));
    }

    private static List<RetargetingConditionBase> convertRetargetingConditions(
            ClientId clientId, @Nullable List<GdUpdateInternalAdRetargetingConditionItem> retargetingConditions) {
        if (retargetingConditions == null) {
            return Collections.emptyList();
        }
        return mapList(retargetingConditions,
                rc -> GdInternalGroupConverters.convertRetargetingCondition(clientId, rc));
    }

    private static RetargetingConditionBase convertRetargetingCondition(
            ClientId clientId, GdUpdateInternalAdRetargetingConditionItem retCond) {
        return new RetargetingCondition()
                .withName(DEFAULT_RETARGETING_CONDITION_NAME)
                .withType(interests)
                .withDeleted(false)
                .withClientId(clientId.asLong())
                .withRules(mapList(retCond.getConditionRules(), RetargetingConverter::toCoreRetargetingConditionRule));
    }

    private static ModelChanges<InternalAdGroup> toInternalAdGroupChanges(GdUpdateInternalAdGroupsItem item) {
        return new ModelChanges<>(item.getId(), InternalAdGroup.class)
                .process(item.getName(), InternalAdGroup.NAME)
                .process(item.getLevel(), InternalAdGroup.LEVEL)
                .process(item.getRf(), InternalAdGroup.RF)
                .process(item.getRfReset(), InternalAdGroup.RF_RESET)
                .process(item.getMaxClicksCount(), InternalAdGroup.MAX_CLICKS_COUNT)
                .process(toCoreRfPeriod(item.getMaxClicksPeriod()), InternalAdGroup.MAX_CLICKS_PERIOD)
                .process(item.getMaxStopsCount(), InternalAdGroup.MAX_STOPS_COUNT)
                .process(toCoreRfPeriod(item.getMaxStopsPeriod()), InternalAdGroup.MAX_STOPS_PERIOD)
                .process(item.getStartTime(), InternalAdGroup.START_TIME)
                .process(item.getFinishTime(), InternalAdGroup.FINISH_TIME)
                .process(integerToLongList(item.getRegionIds()), InternalAdGroup.GEO);
    }

    private static InternalAdGroup toInternalAdGroup(GdAddInternalAdGroupsItem item) {
        return new InternalAdGroup()
                .withType(AdGroupType.INTERNAL)
                .withCampaignId(item.getCampaignId())
                .withName(item.getName())
                .withLevel(item.getLevel())
                .withRf(item.getRf())
                .withRfReset(item.getRfReset())
                .withMaxClicksCount(item.getMaxClicksCount())
                .withMaxClicksPeriod(toCoreRfPeriod(item.getMaxClicksPeriod()))
                .withMaxStopsCount(item.getMaxStopsCount())
                .withMaxStopsPeriod(toCoreRfPeriod(item.getMaxStopsPeriod()))
                .withStartTime(item.getStartTime())
                .withFinishTime(item.getFinishTime())
                .withGeo(integerToLongList(item.getRegionIds()));
    }

    private static List<AdGroupAdditionalTargeting> toCoreTargetingList(
            @Nullable List<GdAdditionalTargetingUnion> unions) {
        if (unions == null) {
            return List.of();
        }
        return StreamEx.of(unions)
                .map(GdInternalGroupConverters::getTargetingFromUnion)
                .map(GdInternalGroupConverters::convertToCoreTargeting)
                .toList();
    }

    private static GdAdditionalTargetingRequest getTargetingFromUnion(GdAdditionalTargetingUnion union) {
        return StreamEx.of(GdAdditionalTargetingUnion.allModelProperties())
                .map(x -> x.getRaw(union))
                .select(GdAdditionalTargetingRequest.class)
                .collect(onlyOne())
                .orElseThrow(() -> new IllegalArgumentException("Invalid union"));
    }

    private static AdGroupAdditionalTargeting convertToCoreTargeting(GdAdditionalTargetingRequest targeting) {
        var cls = targeting.getClass();
        var converter = GdInternalGroupConverters.TYPE_TO_CONVERTER.get(cls);
        if (converter == null) {
            throw new IllegalArgumentException("Unknown targeting type: " + cls);
        }
        return converter.apply(targeting);
    }
}
