package ru.yandex.direct.grid.processing.service.group.type;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;
import ru.yandex.direct.grid.processing.model.banner.GdAdType;
import ru.yandex.direct.grid.processing.model.group.GdContentPromotionAdGroup;
import ru.yandex.direct.grid.processing.model.showcondition.GdShowConditionType;

@Component
@ParametersAreNonnullByDefault
public class ContentPromotionGroupTypeSupport implements GroupTypeSupport<GdContentPromotionAdGroup> {

    private static final Set<GdShowConditionType> AVAILABLE_SHOW_CONDITION_TYPES = ImmutableSet.of(
            GdShowConditionType.RELEVANCE_MATCH,
            GdShowConditionType.KEYWORD,
            GdShowConditionType.RETARGETING,
            GdShowConditionType.MOBILE_INTERESTS
    );

    private static final Set<GdAdType> AVAILABLE_BANNER_TYPES = ImmutableSet.of(GdAdType.CONTENT_PROMOTION);

    @Override
    public GdAdGroupType getAdGroupType() {
        return GdAdGroupType.CONTENT_PROMOTION;
    }

    @Override
    public void setAvailableShowConditionTypesForAdGroup(int shard, ClientId clientId, Long operatorUid,
                                                         Collection<GdContentPromotionAdGroup> adGroups) {
        adGroups.forEach(adGroup -> adGroup.setAvailableShowConditionTypes(AVAILABLE_SHOW_CONDITION_TYPES));
    }

    @Override
    public void setAvailableBannerTypesForAdGroup(int shard, ClientId clientId,
                                                  Collection<GdContentPromotionAdGroup> adGroups) {
        adGroups.forEach(adGroup -> adGroup.setAvailableAdTypes(AVAILABLE_BANNER_TYPES));
    }
}
