package ru.yandex.direct.grid.processing.service.group.type;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;
import ru.yandex.direct.grid.processing.model.banner.GdAdType;
import ru.yandex.direct.grid.processing.model.group.GdCpmBannerAdGroup;
import ru.yandex.direct.grid.processing.model.group.GdCriterionType;
import ru.yandex.direct.grid.processing.model.showcondition.GdShowConditionType;

import static java.util.Objects.isNull;

@Component
@ParametersAreNonnullByDefault
public class CpmBannerGroupTypeSupport implements GroupTypeSupport<GdCpmBannerAdGroup> {
    private static final GdShowConditionType DEFAULT_SHOW_CONDITION_TYPE = GdShowConditionType.KEYWORD;
    private static final Map<GdCriterionType, GdShowConditionType> SHOW_COND_TYPE_BY_CRITERION = Map.of(
            GdCriterionType.KEYWORD, GdShowConditionType.KEYWORD,
            GdCriterionType.USER_PROFILE, GdShowConditionType.USER_PROFILE,
            GdCriterionType.CONTENT_CATEGORY, GdShowConditionType.CONTENT_CATEGORY
    );

    @Autowired
    private FeatureService featureService;

    @Override
    public GdAdGroupType getAdGroupType() {
        return GdAdGroupType.CPM_BANNER;
    }

    @Override
    public void setAvailableShowConditionTypesForAdGroup(int shard, ClientId clientId, Long operatorUid,
                                                         Collection<GdCpmBannerAdGroup> adGroups) {
        boolean extendedFeatureEnabled = featureService.isEnabledForClientId(
                clientId, FeatureName.CONTENT_CATEGORY_TARGETING_CPM_EXTENDED);

        adGroups.forEach(adGroup -> {
            var showConditionType = !isNull(adGroup.getCriterionType()) ?
                    SHOW_COND_TYPE_BY_CRITERION.getOrDefault(adGroup.getCriterionType(), DEFAULT_SHOW_CONDITION_TYPE) :
                    DEFAULT_SHOW_CONDITION_TYPE;

            if (GdShowConditionType.CONTENT_CATEGORY.equals(showConditionType) && extendedFeatureEnabled) {
                showConditionType = GdShowConditionType.USER_PROFILE;
                adGroup.setCriterionType(GdCriterionType.USER_PROFILE);
            }

            adGroup.setAvailableShowConditionTypes(ImmutableSet.of(showConditionType));
        });
    }

    @Override
    public void setAvailableBannerTypesForAdGroup(int shard, ClientId clientId,
                                                  Collection<GdCpmBannerAdGroup> adGroups) {
        adGroups.forEach(adGroup -> adGroup.setAvailableAdTypes(ImmutableSet.of(GdAdType.CPM_BANNER)));
    }
}
