package ru.yandex.direct.grid.processing.service.group.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;
import ru.yandex.direct.grid.processing.model.banner.GdAdType;
import ru.yandex.direct.grid.processing.model.group.GdCpmGeoPinAdGroup;
import ru.yandex.direct.grid.processing.model.showcondition.GdShowConditionType;

@Component
@ParametersAreNonnullByDefault
public class CpmGeoPinGroupTypeSupport implements GroupTypeSupport<GdCpmGeoPinAdGroup> {
    @Override
    public GdAdGroupType getAdGroupType() {
        return GdAdGroupType.CPM_GEO_PIN;
    }

    @Override
    public void setAvailableShowConditionTypesForAdGroup(int shard, ClientId clientId,
                                                         Long operatorUid, Collection<GdCpmGeoPinAdGroup> adGroups) {
        adGroups.forEach(
                adGroup -> adGroup.setAvailableShowConditionTypes(ImmutableSet.of(GdShowConditionType.USER_PROFILE)));
    }

    @Override
    public void setAvailableBannerTypesForAdGroup(int shard, ClientId clientId,
                                                  Collection<GdCpmGeoPinAdGroup> adGroups) {
        adGroups.forEach(adGroup -> adGroup.setAvailableAdTypes(ImmutableSet.of(GdAdType.CPM_GEO_PIN)));
    }
}
