package ru.yandex.direct.grid.processing.service.group.type;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;
import ru.yandex.direct.grid.processing.model.banner.GdAdType;
import ru.yandex.direct.grid.processing.model.group.GdCpmPriceVideoAdGroup;
import ru.yandex.direct.grid.processing.model.showcondition.GdShowConditionType;

@Component
@ParametersAreNonnullByDefault
public class CpmPriceVideoGroupTypeSupport implements GroupTypeSupport<GdCpmPriceVideoAdGroup> {

    private static final Set<GdShowConditionType> AVAILABLE_SHOW_CONDITION_TYPES = ImmutableSet.of(
            // в прайсовых видео нужен таргетинг на LTV, а LTV - часть USER_PROFILE
            GdShowConditionType.USER_PROFILE
    );

    private static final Set<GdAdType> AVAILABLE_BANNER_TYPES = ImmutableSet.of(
            GdAdType.CPM_PRICE
    );

    @Override
    public GdAdGroupType getAdGroupType() {
        return GdAdGroupType.CPM_PRICE_VIDEO;
    }

    @Override
    public void setAvailableShowConditionTypesForAdGroup(int shard, ClientId clientId,
                                                         Long operatorUid, Collection<GdCpmPriceVideoAdGroup> adGroups) {
        adGroups.forEach(adGroup -> adGroup.setAvailableShowConditionTypes(AVAILABLE_SHOW_CONDITION_TYPES));
    }

    @Override
    public void setAvailableBannerTypesForAdGroup(int shard, ClientId clientId,
                                                  Collection<GdCpmPriceVideoAdGroup> adGroups) {
        adGroups.forEach(adGroup -> adGroup.setAvailableAdTypes(AVAILABLE_BANNER_TYPES));
    }

}
