package ru.yandex.direct.grid.processing.service.group.type;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.grid.model.entity.adgroup.GdAdGroupType;
import ru.yandex.direct.grid.processing.model.banner.GdAdType;
import ru.yandex.direct.grid.processing.model.group.GdCpmYndxFrontpageAdGroup;
import ru.yandex.direct.grid.processing.model.showcondition.GdShowConditionType;

import static java.util.Collections.emptySet;
import static java.util.Collections.singleton;

@Component
@ParametersAreNonnullByDefault
public class CpmYndxFrontpageGroupTypeSupport implements GroupTypeSupport<GdCpmYndxFrontpageAdGroup> {
    @Autowired
    private FeatureService featureService;

    @Override
    public GdAdGroupType getAdGroupType() {
        return GdAdGroupType.CPM_YNDX_FRONTPAGE;
    }

    @Override
    public void setAvailableShowConditionTypesForAdGroup(
            int shard, ClientId clientId, Long operatorUid, Collection<GdCpmYndxFrontpageAdGroup> adGroups) {
        boolean isProfileEnabled = featureService.isEnabledForClientId(
                clientId, FeatureName.CPM_YNDX_FRONTPAGE_PROFILE);
        Set<GdShowConditionType> conditions = isProfileEnabled ?
                ImmutableSet.of(GdShowConditionType.USER_PROFILE) : emptySet();
        adGroups.forEach(adGroup -> adGroup.setAvailableShowConditionTypes(conditions));
    }

    @Override
    public void setAvailableBannerTypesForAdGroup(int shard, ClientId clientId,
                                                  Collection<GdCpmYndxFrontpageAdGroup> adGroups) {
        adGroups.forEach(adGroup -> adGroup.setAvailableAdTypes(singleton(GdAdType.CPM_YNDX_FRONTPAGE)));
    }


}
